/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPluginContribution;
import org.osgi.framework.Bundle;

public class WizardElement
extends NamedElement
implements IPluginContribution {
    public static final String ATT_NAME = "name";
    public static final String TAG_DESCRIPTION = "description";
    public static final String ATT_ICON = "icon";
    public static final String ATT_ID = "id";
    public static final String ATT_CLASS = "class";
    public static final String ATT_TEMPLATE = "template";
    public static final String ATT_POINT = "point";
    private String description;
    protected IConfigurationElement configurationElement;
    private IConfigurationElement template;

    public WizardElement(IConfigurationElement config) {
        super(config.getAttribute(ATT_NAME));
        this.configurationElement = config;
    }

    public Object createExecutableExtension() throws CoreException {
        return this.configurationElement.createExecutableExtension(ATT_CLASS);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getDescription() {
        IConfigurationElement[] children;
        if (this.description == null && (children = this.configurationElement.getChildren(TAG_DESCRIPTION)).length > 0) {
            this.description = this.expandDescription(children[0].getValue());
        }
        return this.description;
    }

    private String expandDescription(String source) {
        if (source == null || source.length() == 0) {
            return source;
        }
        if (source.indexOf(37) == -1) {
            return source;
        }
        Bundle bundle = Platform.getBundle((String)this.configurationElement.getNamespaceIdentifier());
        if (bundle == null) {
            return source;
        }
        ResourceBundle resourceBundle = Platform.getResourceBundle((Bundle)bundle);
        if (resourceBundle == null) {
            return source;
        }
        StringBuffer buf = new StringBuffer();
        boolean keyMode = false;
        int keyStartIndex = -1;
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == '%') {
                char c2 = source.charAt(i + 1);
                if (c2 == '%') {
                    ++i;
                    buf.append('%');
                } else if (keyMode) {
                    String key;
                    keyMode = false;
                    String value = key = source.substring(keyStartIndex, i);
                    try {
                        value = resourceBundle.getString(key);
                    }
                    catch (MissingResourceException missingResourceException) {}
                    buf.append(value);
                } else {
                    keyStartIndex = i + 1;
                    keyMode = true;
                }
            } else if (!keyMode) {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public String getID() {
        return this.configurationElement.getAttribute(ATT_ID);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String getTemplateId() {
        return this.configurationElement.getAttribute(ATT_TEMPLATE);
    }

    public boolean isTemplate() {
        return this.getTemplateId() != null;
    }

    public IConfigurationElement getTemplateElement() {
        if (this.template == null) {
            this.template = this.findTemplateElement();
        }
        return this.template;
    }

    private IConfigurationElement findTemplateElement() {
        IConfigurationElement[] templates;
        String templateId = this.getTemplateId();
        if (templateId == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = templates = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.pde.ui.templates");
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement template = iConfigurationElementArray[n2];
            String id = template.getAttribute(ATT_ID);
            if (id != null && id.equals(templateId)) {
                return template;
            }
            ++n2;
        }
        return null;
    }

    public String getContributingId() {
        IConfigurationElement tel = this.getTemplateElement();
        return tel == null ? null : tel.getAttribute("contributingId");
    }

    public String getLocalId() {
        return this.getID();
    }

    public String getPluginId() {
        return null;
    }

    public static WizardElement create(IConfigurationElement config) {
        String name = config.getAttribute(ATT_NAME);
        String id = config.getAttribute(ATT_ID);
        String className = config.getAttribute(ATT_CLASS);
        if (name == null || id == null || className == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute(ATT_ICON);
        if (imageName != null) {
            String pluginID = config.getNamespaceIdentifier();
            Image image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pluginID, imageName);
            element.setImage(image);
        }
        return element;
    }
}

