/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.history.IRefactoringDescriptorDeleteQuery;
import org.eclipse.ltk.internal.ui.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.swt.widgets.Shell;

public final class RefactoringDescriptorDeleteQuery
implements IRefactoringDescriptorDeleteQuery {
    private static final String PREFERENCE_DO_NOT_WARN_DELETE = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.warn.delete.descriptor";
    private final int fCount;
    private final IProject fProject;
    private int fReturnCode = -1;
    private final Shell fShell;
    private boolean fWarned = false;

    public RefactoringDescriptorDeleteQuery(Shell shell, IProject project, int count) {
        Assert.isNotNull((Object)shell);
        Assert.isTrue((count >= 0 ? 1 : 0) != 0);
        this.fShell = shell;
        this.fProject = project;
        this.fCount = count;
    }

    public boolean hasDeletions() {
        return this.fReturnCode == 2;
    }

    public RefactoringStatus proceed(RefactoringDescriptorProxy proxy) {
        final IPreferenceStore store = RefactoringUIPlugin.getDefault().getPreferenceStore();
        if (!this.fWarned) {
            if (!store.getBoolean(PREFERENCE_DO_NOT_WARN_DELETE)) {
                this.fShell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public final void run() {
                        if (!RefactoringDescriptorDeleteQuery.this.fShell.isDisposed()) {
                            String count = new Integer(RefactoringDescriptorDeleteQuery.this.fCount).toString();
                            String message = null;
                            message = RefactoringDescriptorDeleteQuery.this.fProject != null ? (RefactoringDescriptorDeleteQuery.this.fCount == 1 ? Messages.format(RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_pattern_singular, BasicElementLabels.getResourceName((IResource)RefactoringDescriptorDeleteQuery.this.fProject)) : Messages.format(RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_pattern_plural, new String[]{count, BasicElementLabels.getResourceName((IResource)RefactoringDescriptorDeleteQuery.this.fProject)})) : (RefactoringDescriptorDeleteQuery.this.fCount == 1 ? RefactoringUIMessages.RefactoringDescriptorDeleteQuery_confirm_deletion_singular : Messages.format(RefactoringUIMessages.RefactoringDescriptorDeleteQuery_confirm_deletion_plural, count));
                            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)RefactoringDescriptorDeleteQuery.this.fShell, (String)RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_caption, (String)message, (String)RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, (boolean)store.getBoolean(PREFERENCE_DO_NOT_WARN_DELETE), null, null);
                            store.setValue(PREFERENCE_DO_NOT_WARN_DELETE, dialog.getToggleState());
                            RefactoringDescriptorDeleteQuery.this.fReturnCode = dialog.getReturnCode();
                        }
                    }
                });
            } else {
                this.fReturnCode = 2;
            }
        }
        this.fWarned = true;
        if (this.fReturnCode == 2) {
            return new RefactoringStatus();
        }
        return RefactoringStatus.createErrorStatus((String)IDialogConstants.NO_LABEL);
    }
}

