/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.search;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.search.Q7SearchPageImpl;
import org.eclipse.rcptt.search.Q7SearchQuery;
import org.eclipse.rcptt.search.Q7SearchQueryProvider;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowDependenciesAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource[] resources = LaunchUtils.getContext((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (resources.length == 1 && resources[0] instanceof IFile) {
            IQ7NamedElement element = (IQ7NamedElement)RcpttCore.create((IResource)resources[0]);
            try {
                String[] extensions;
                int searchType;
                if (element instanceof IContext) {
                    searchType = 5;
                    extensions = Q7SearchPageImpl.Q7_SCENARIO_EXTS;
                } else if (element instanceof IVerification) {
                    searchType = 7;
                    extensions = Q7SearchPageImpl.Q7_SCENARIO_EXTS;
                } else {
                    searchType = 6;
                    extensions = Q7SearchPageImpl.Q7_TESTSUITE_EXTS;
                }
                Q7SearchPageImpl.Q7SearchPageInput input = new Q7SearchPageImpl.Q7SearchPageInput(element.getID(), true, false, this.getSearchScope(resources[0], extensions), searchType);
                Q7SearchQueryProvider searchProvider = new Q7SearchQueryProvider();
                ISearchQuery searchQuery = searchProvider.createQuery(input);
                ((Q7SearchQuery)searchQuery).setQ7ElementName(element.getElementName());
                NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
            }
            catch (ModelException e) {
                Q7UIPlugin.log((Throwable)e);
            }
        }
        return null;
    }

    private FileTextSearchScope getSearchScope(IResource resource, String[] extensions) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject project = resource.getProject();
        result.add(project);
        result.addAll(Arrays.asList(project.getReferencingProjects()));
        if (result.size() == ResourcesPlugin.getWorkspace().getRoot().getProjects().length) {
            return FileTextSearchScope.newWorkspaceScope((String[])extensions, (boolean)false);
        }
        return FileTextSearchScope.newSearchScope((IResource[])result.toArray(new IResource[0]), (String[])extensions, (boolean)false);
    }
}

