/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core;

import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.core.features.IMLFeatures;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramFeatures;
import org.eclipse.rcptt.tesla.core.utils.AbstractFeatureManager;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.util.StringUtils;

public class TeslaFeatures
extends AbstractFeatureManager {
    private static final String CAT_COMMAND_DELAYS = "Command Delays";
    private static final String TESLA_PROTOCOL_VERSION = "1.0.1";
    public static final String PROTOCOL_VERSION = "org.eclipse.rcptt.tesla.protocol.version";
    public static final String COMMAND_EXECUTION_DELAY = "org.eclipse.rcptt.tesla.ecl.execution.delay";
    public static final String INTERNAL_CLIPBOARD = "org.eclipse.rcptt.tesla.internal.clipboard";
    public static final String COMMAND_EXECUTION_DELAY_TESLA = "org.eclipse.rcptt.tesla.execution.delay";
    public static final String RECORD_ALL_SELECTIONS = "org.eclipse.rcptt.tesla.record.all.selections";
    public static final String ESCAPE_TREES_TABLES_MODE = "org.eclipse.rcptt.tesla.escape.mode";
    public static final String IDENTIFY_BY_CLASS_METHODS = "org.eclipse.rcptt.tesla.identify.by.class.methods";
    private static final String[] ESCAPE_TREES_TABLES_VALUES = new String[]{EscapeMode.ExactString.toString(), EscapeMode.EscapedRegex.toString()};
    public static final String ACTIVITY_LOGS = "com.xored.runtime.enable.activity.logs";
    public static final String TESTENGINE_LOGS = "com.xored.testengine.logs";
    public static final String ADV_OPTIONS = "adv.options";
    public static final String NONE = "";
    public static final String CP_OPTIONS = "cp.options";
    public static final String STATUS_DIALOG_ALLOWED = "com.xored.runtime.status.dialog.allowed";
    public static final String ENABLE_PROTECTED_MEMBERS = "enable.protected.members";
    public static final String LOGGING_OPTIONS = "logging.options";
    public static final String CAT_LOGGING = "Logging";
    public static String CAPTURE_EXECUTION = "q7.image.capture";
    public static String CAT_REPORTING = "Reporting";
    public static final String REPORT_PASSED_TEST_DETAILS = "com.xored.reporting.passed.test.details";
    public static final String REPORT_LOGGING_SIZE_OF_INITIAL_PART = "com.xored.reporting.logging.initial.size";
    public static final String REPORT_LOGGING_SIZE_OF_ROTATION_PART = "com.xored.reporting.logging.rotation.size";
    public static final String REPORT_INCLUDE_IGNORED_WAIT_DETAILS = "com.xored.reporting.include.ignored.wait.details";
    public static final String REPORT_PASSED_WAIT_DETAILS = "com.xored.reporting.include.passed.wait.details";
    public static final String REPORT_INCLUDE_ECLIPSE_METHODS_WAIT_DETAILS = "com.xored.reporting.include.eclipse.wait.details";
    private static TeslaFeatures features;

    public static TeslaFeatures getInstance() {
        if (features == null) {
            features = new TeslaFeatures();
            features.loadFromPreferences(TeslaCore.getPreferences());
        }
        return features;
    }

    public TeslaFeatures() {
        this.option(PROTOCOL_VERSION).name("Protocol version").value(TESLA_PROTOCOL_VERSION).editable(false).showIn(ADV_OPTIONS);
        this.option(COMMAND_EXECUTION_DELAY).name("ECL command execution delay").category(CAT_COMMAND_DELAYS).value("0").defaultValue("0").values(AbstractFeatureManager.INT_VALUES).description("Wait for specified milliseconds before execution of next Tesla ECL command").editable(true).showIn(NONE);
        this.option(COMMAND_EXECUTION_DELAY_TESLA).name("Tesla command execution delay").category(CAT_COMMAND_DELAYS).value("0").defaultValue("0").values(AbstractFeatureManager.INT_VALUES).description("Wait for specified milliseconds before execution of next Tesla command").editable(true).showIn(NONE);
        this.option(INTERNAL_CLIPBOARD).name("Use internal clipboard").category("Clipboard options").value("false").defaultValue("false").values(AbstractFeatureManager.BOOLEAN_VALUES).description("Do not use OS clipboard for copy/paste operations").editable(true).showIn(ADV_OPTIONS);
        this.option(REPORT_PASSED_TEST_DETAILS).category(CAT_REPORTING).name("Include 'trace' and 'take-screenshot' in HTML report").value("false").defaultValue("false").values(AbstractFeatureManager.BOOLEAN_VALUES).description("Command 'trace' and 'take-screenshot' can be used to add data into test report").editable(true).showIn(ADV_OPTIONS);
        this.option(REPORT_LOGGING_SIZE_OF_INITIAL_PART).category(CAT_REPORTING).name("The size of log initial part(in MB)").value("5").defaultValue("5").values(AbstractFeatureManager.INT_VALUES).description("The initial part size of logs").editable(true).showIn(ADV_OPTIONS);
        this.option(REPORT_LOGGING_SIZE_OF_ROTATION_PART).category(CAT_REPORTING).name("The size of log rotation part(in MB)").value("5").defaultValue("5").values(AbstractFeatureManager.INT_VALUES).description("The rotation size of log. At overflow works by the principle of queue.").editable(true).showIn(ADV_OPTIONS);
        this.option(REPORT_INCLUDE_IGNORED_WAIT_DETAILS).category(CAT_REPORTING).name("Include 'ignored' timers into report files").value("false").defaultValue("false").values(AbstractFeatureManager.BOOLEAN_VALUES).description("RCPTT widget details will contain ignored timer calls").editable(true).showIn(ADV_OPTIONS);
        this.option(REPORT_PASSED_WAIT_DETAILS).category(CAT_REPORTING).name("Include 'wait details' into passed report entries").value("true").defaultValue("true").values(AbstractFeatureManager.BOOLEAN_VALUES).description("RCPTT widget wait details will be also added to passed reports as separate section").editable(true).showIn(ADV_OPTIONS);
        this.option(REPORT_INCLUDE_ECLIPSE_METHODS_WAIT_DETAILS).category(CAT_REPORTING).name("Include eclipse methods into 'wait details' info").value("false").defaultValue("false").values(AbstractFeatureManager.BOOLEAN_VALUES).description("Eclipse methods will be added into 'wait details' info").editable(true).showIn(ADV_OPTIONS);
        this.option(RECORD_ALL_SELECTIONS).name("Record all selections for tables and trees").value("false").defaultValue("false").values(AbstractFeatureManager.BOOLEAN_VALUES).description("Enables or disables collapsing of selection events").editable(true).showIn(ADV_OPTIONS, CP_OPTIONS);
        this.option(ESCAPE_TREES_TABLES_MODE).name("Table/tree item literal mode").values(ESCAPE_TREES_TABLES_VALUES).defaultValue(EscapeMode.ExactString.toString()).value(EscapeMode.ExactString.toString()).showIn(ADV_OPTIONS, CP_OPTIONS);
        this.option(STATUS_DIALOG_ALLOWED).name("Allow status dialogs").description("Should the test pass, if appears the status dialog with an error?").value("false").defaultValue("false").values(AbstractFeatureManager.BOOLEAN_VALUES).editable(true).showIn(ADV_OPTIONS, CP_OPTIONS);
        this.option(ENABLE_PROTECTED_MEMBERS).name("Use protected members in Advanced properties").description("Enable assertions for protected fields and methods").value("false").defaultValue("false").values(BOOLEAN_VALUES).editable(true).showIn(ADV_OPTIONS);
        this.option(IDENTIFY_BY_CLASS_METHODS).name("Identify widgets by class methods").value(NONE).defaultValue(NONE).description("Comma-separated list of methods will be used to identify widgets of specified class\nValid format: ClassName1:getModel().getName(),ClassName2:getIdString()").editable(true).showIn(ADV_OPTIONS, CP_OPTIONS);
        DiagramFeatures.init(this);
        IMLFeatures.init(this);
        TeslaLimits.init(this);
        this.option(CAPTURE_EXECUTION).category(CAT_LOGGING).name("Enable per command image capture").description("Capture screenshots on each command execution").value("false").defaultValue("false").values(AbstractFeatureManager.BOOLEAN_VALUES).editable(true).showIn(ADV_OPTIONS, CP_OPTIONS);
        this.option(ACTIVITY_LOGS).name("Enable Activity logging").category(CAT_LOGGING).value("false").defaultValue("false").values(AbstractFeatureManager.BOOLEAN_VALUES).description("Store RCPTT runtime activity events into .metadata/.plugins/org.eclipse.rcptt.logging").editable(true).showIn(ADV_OPTIONS);
        this.option(TESTENGINE_LOGS).name("Enable Test Engine logging").category(CAT_LOGGING).value("false").defaultValue("false").values(AbstractFeatureManager.BOOLEAN_VALUES).description("Show Test Engines info messages in Error Log").editable(true).showIn(ADV_OPTIONS);
    }

    public static boolean isUseInternalClipboard() {
        return TeslaFeatures.getInstance().isTrue(INTERNAL_CLIPBOARD);
    }

    public static boolean isActivityLogging() {
        return TeslaFeatures.getInstance().isTrue(ACTIVITY_LOGS);
    }

    public static boolean isIncludeIgnoredWaitDetails() {
        return TeslaFeatures.getInstance().isTrue(REPORT_INCLUDE_IGNORED_WAIT_DETAILS);
    }

    public static boolean isIncludePassedWaitDetails() {
        return TeslaFeatures.getInstance().isTrue(REPORT_PASSED_WAIT_DETAILS);
    }

    public static boolean isIncludeEclipseMethodsWaitDetails() {
        return TeslaFeatures.getInstance().isTrue(REPORT_INCLUDE_ECLIPSE_METHODS_WAIT_DETAILS);
    }

    public static boolean isProtectedEnabled() {
        return TeslaFeatures.getInstance().isTrue(ENABLE_PROTECTED_MEMBERS);
    }

    public static boolean isIdentifyMethodsProvided() {
        String methods = TeslaFeatures.getInstance().getValue(IDENTIFY_BY_CLASS_METHODS);
        return !StringUtils.isBlank((String)methods);
    }

    public static enum EscapeMode {
        ExactString,
        EscapedRegex;

    }
}

