/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.testing;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.core.ecl.core.model.SetQ7Features;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.ecl.model.GetAdvancedInfo;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.testing.TestingPlugin;
import org.eclipse.rcptt.testing.commands.Eval;

public class EvalService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        Eval eval = (Eval)command;
        String autId = eval.getAutId();
        AutLaunch launch = AutManager.INSTANCE.getById(autId);
        if (launch == null) {
            return TestingPlugin.createErrStatus("AUT is not launched: " + autId);
        }
        try {
            SetQ7Features setQ7Features = Q7CoreFactory.eINSTANCE.createSetQ7Features();
            TeslaFeatures.getInstance().storeValues((List)setQ7Features.getFeatures());
            Q7Features.getInstance().storeValues((List)setQ7Features.getFeatures());
            launch.execute((Command)setQ7Features);
        }
        catch (CoreException e) {
            return TestingPlugin.createErrStatus("Failed to send features: " + e.getMessage(), e);
        }
        Script script = CoreFactory.eINSTANCE.createScript();
        script.setContent(eval.getScript());
        launch.execute(script, (long)(Q7Launcher.getLaunchTimeout() * 1000), (IProgressMonitor)new NullProgressMonitor());
        GetAdvancedInfo info = TeslaFactory.eINSTANCE.createGetAdvancedInfo();
        Object result = launch.execute((Command)info);
        if (result != null) {
            context.getOutput().write(result);
        }
        return Status.OK_STATUS;
    }
}

