/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.util.PrefUtil;

public class PlatformUIPreferenceListener
implements IEclipsePreferences.IPreferenceChangeListener {
    private static PlatformUIPreferenceListener singleton;

    public static IEclipsePreferences.IPreferenceChangeListener getSingleton() {
        if (singleton == null) {
            singleton = new PlatformUIPreferenceListener();
        }
        return singleton;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String propertyName;
        block28: {
            IEditorRegistry registry;
            propertyName = event.getKey();
            if ("ENABLED_DECORATORS".equals(propertyName)) {
                DecoratorManager manager = WorkbenchPlugin.getDefault().getDecoratorManager();
                manager.applyDecoratorsPreference();
                manager.clearCaches();
                manager.updateForEnablementChange();
                return;
            }
            if ("SHOW_SYSTEM_JOBS".equals(propertyName)) {
                boolean setting = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_SYSTEM_JOBS");
                ProgressManager.getInstance().setShowSystemJobs(setting);
            }
            if ("defaultPerspectiveId".equals(propertyName)) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                workbench.getPerspectiveRegistry().setDefaultPerspective(PrefUtil.getAPIPreferenceStore().getString("defaultPerspectiveId"));
                return;
            }
            if ("DOCK_PERSPECTIVE_BAR".equals(propertyName)) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    boolean cfr_ignored_0 = window instanceof WorkbenchWindow;
                    ++n2;
                }
                return;
            }
            if ("SHOW_TRADITIONAL_STYLE_TABS".equals(propertyName)) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n3];
                    boolean cfr_ignored_1 = window instanceof WorkbenchWindow;
                    ++n3;
                }
                return;
            }
            if ("resourcetypes".equals(propertyName) && (registry = WorkbenchPlugin.getDefault().getEditorRegistry()) instanceof EditorRegistry) {
                EditorRegistry editorRegistry = (EditorRegistry)registry;
                IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                Reader reader = null;
                try {
                    try {
                        String xmlString = store.getString("resourcetypes");
                        if (xmlString != null && xmlString.length() > 0) {
                            IEditorDescriptor descriptor;
                            reader = new StringReader(xmlString);
                            HashMap<String, IEditorDescriptor> editorMap = new HashMap<String, IEditorDescriptor>();
                            int i = 0;
                            IEditorDescriptor[] descriptors = editorRegistry.getSortedEditorsFromPlugins();
                            i = 0;
                            while (i < descriptors.length) {
                                descriptor = descriptors[i];
                                editorMap.put(descriptor.getId(), descriptor);
                                ++i;
                            }
                            descriptors = editorRegistry.getSortedEditorsFromOS();
                            i = 0;
                            while (i < descriptors.length) {
                                descriptor = descriptors[i];
                                editorMap.put(descriptor.getId(), descriptor);
                                ++i;
                            }
                            IFileEditorMapping[] iFileEditorMappingArray = editorRegistry.getFileEditorMappings();
                            int n = iFileEditorMappingArray.length;
                            int n4 = 0;
                            while (n4 < n) {
                                IFileEditorMapping fileEditorMapping = iFileEditorMappingArray[n4];
                                IEditorDescriptor descriptor2 = fileEditorMapping.getDefaultEditor();
                                if (descriptor2 != null && !editorMap.containsKey(descriptor2.getId())) {
                                    editorMap.put(descriptor2.getId(), descriptor2);
                                }
                                ++n4;
                            }
                            editorRegistry.readResources(editorMap, reader);
                        }
                    }
                    catch (WorkbenchException e) {
                        WorkbenchPlugin.log((Throwable)((Object)e));
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e2) {
                                WorkbenchPlugin.log(e2);
                            }
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            WorkbenchPlugin.log(e);
                        }
                    }
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        WorkbenchPlugin.log(e);
                    }
                }
            }
        }
        if ("OPEN_ON_SINGLE_CLICK".equals(propertyName) || "SELECT_ON_HOVER".equals(propertyName) || "OPEN_AFTER_DELAY".equals(propertyName) || "SELECT_ON_HOVER".equals(propertyName)) {
            PlatformUIPreferenceListener.initializeSingleClickOption();
        }
    }

    private static void initializeSingleClickOption() {
        int singleClickMethod;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean openOnSingleClick = store.getBoolean("OPEN_ON_SINGLE_CLICK");
        boolean selectOnHover = store.getBoolean("SELECT_ON_HOVER");
        boolean openAfterDelay = store.getBoolean("OPEN_AFTER_DELAY");
        int n = singleClickMethod = openOnSingleClick ? 1 : 0;
        if (openOnSingleClick) {
            if (selectOnHover) {
                singleClickMethod |= 2;
            }
            if (openAfterDelay) {
                singleClickMethod |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)singleClickMethod);
    }
}

