/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.parser;

import java.util.Properties;
import org.eclipse.help.internal.webapp.parser.ParseElement;
import org.eclipse.help.internal.webapp.parser.ResultParser;
import org.eclipse.help.internal.webapp.utils.JSonHelper;
import org.xml.sax.Attributes;

public class NavParser
extends ResultParser {
    private ParseElement element = null;

    public NavParser() {
        super("title");
    }

    @Override
    public void startElement(String uri, String lname, String name, Attributes attrs) {
        Properties properties = new Properties();
        properties.put("tagName", name);
        int i = 0;
        while (i < attrs.getLength()) {
            String qname = attrs.getQName(i);
            String val = attrs.getValue(i);
            properties.put(qname, val);
            ++i;
        }
        ParseElement elem = new ParseElement(properties, this.element);
        if (this.element != null) {
            this.element.addChild(elem);
        } else {
            this.items.add(elem);
        }
        this.element = elem;
    }

    @Override
    public void endElement(String uri, String lname, String name) {
        if (this.element != null) {
            this.element = this.element.getParent();
        }
    }

    @Override
    public String toJSON() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append("\n   ");
        buf.append(JSonHelper.getQuotes("identifier"));
        buf.append(":");
        buf.append(JSonHelper.getQuotes(this.id));
        buf.append(",");
        buf.append("\n   ");
        buf.append(JSonHelper.getQuotes("label"));
        buf.append(":");
        buf.append(JSonHelper.getQuotes(this.label));
        buf.append(",");
        ParseElement elem = (ParseElement)this.items.get(0);
        if (elem != null) {
            buf.append(elem.toJSON());
        }
        buf.append("}");
        return buf.toString();
    }
}

