/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.WizardElement;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class WizardProvider
extends QuickAccessProvider {
    private QuickAccessElement[] cachedElements;
    private Map<String, WizardElement> idToElement = new HashMap<String, WizardElement>();

    @Override
    public QuickAccessElement getElementForId(String id) {
        this.getElements();
        return this.idToElement.get(id);
    }

    @Override
    public QuickAccessElement[] getElements() {
        if (this.cachedElements == null) {
            IWizardCategory rootCategory = WorkbenchPlugin.getDefault().getNewWizardRegistry().getRootCategory();
            ArrayList<IWizardDescriptor> result = new ArrayList<IWizardDescriptor>();
            this.collectWizards(rootCategory, result);
            IWizardDescriptor[] wizards = result.toArray(new IWizardDescriptor[result.size()]);
            int i = 0;
            while (i < wizards.length) {
                if (!WorkbenchActivityHelper.filterItem(wizards[i])) {
                    WizardElement wizardElement = new WizardElement(wizards[i], this);
                    this.idToElement.put(wizardElement.getId(), wizardElement);
                }
                ++i;
            }
            this.cachedElements = this.idToElement.values().toArray(new QuickAccessElement[this.idToElement.size()]);
        }
        return this.cachedElements;
    }

    private void collectWizards(IWizardCategory category, List<IWizardDescriptor> result) {
        result.addAll(Arrays.asList(category.getWizards()));
        IWizardCategory[] iWizardCategoryArray = category.getCategories();
        int n = iWizardCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardCategory childCategory = iWizardCategoryArray[n2];
            this.collectWizards(childCategory, result);
            ++n2;
        }
    }

    @Override
    public String getId() {
        return "org.eclipse.ui.wizards";
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_New;
    }

    @Override
    protected void doReset() {
        this.cachedElements = null;
        this.idToElement.clear();
    }
}

