/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.registry.MarkerQueryResult;

public class MarkerQuery {
    private String type;
    private String[] attributes;
    private int hashCode;

    public MarkerQuery(String markerType, String[] markerAttributes) {
        if (markerAttributes == null) {
            throw new IllegalArgumentException();
        }
        this.type = markerType;
        this.attributes = markerAttributes;
        this.computeHashCode();
    }

    public MarkerQueryResult performQuery(IMarker marker) {
        try {
            if (this.type != null && !this.type.equals(marker.getType())) {
                return null;
            }
        }
        catch (CoreException e) {
            Policy.handle(e);
            return null;
        }
        String[] values = new String[this.attributes.length];
        int i = 0;
        while (i < this.attributes.length) {
            Object value;
            block7: {
                try {
                    value = marker.getAttribute(this.attributes[i]);
                    if (value != null) break block7;
                    return null;
                }
                catch (CoreException e) {
                    Policy.handle(e);
                    return null;
                }
            }
            values[i] = value.toString();
            ++i;
        }
        return new MarkerQueryResult(values);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MarkerQuery)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        MarkerQuery mq = (MarkerQuery)o;
        if (this.type == null ? mq.type != null : !this.type.equals(mq.type)) {
            return false;
        }
        if (this.attributes.length != mq.attributes.length) {
            return false;
        }
        int i = 0;
        while (i < this.attributes.length) {
            if (!this.attributes[i].equals(mq.attributes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void computeHashCode() {
        this.hashCode = 19;
        if (this.type != null) {
            this.hashCode = this.hashCode * 37 + this.type.hashCode();
        }
        String[] stringArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            this.hashCode = this.hashCode * 37 + attribute.hashCode();
            ++n2;
        }
    }

    public String getType() {
        return this.type;
    }

    public String[] getAttributes() {
        return this.attributes;
    }
}

