/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.CompositeDebugImageDescriptor;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugModelPresentationExtension;
import org.eclipse.debug.ui.IInstructionPointerPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class LazyModelPresentation
implements IDebugModelPresentation,
IDebugEditorPresentation,
IColorProvider,
IFontProvider,
IInstructionPointerPresentation,
IDebugModelPresentationExtension {
    protected HashMap<String, Object> fAttributes = new HashMap(3);
    protected IConfigurationElement fConfig = null;
    protected IDebugModelPresentation fPresentation = null;
    protected ListenerList<ILabelProviderListener> fListeners = new ListenerList();
    private DelegatingModelPresentation fOwner = null;

    @Override
    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
        IDebugModelPresentation presentation = this.getPresentation();
        if (presentation instanceof IDebugEditorPresentation) {
            ((IDebugEditorPresentation)((Object)presentation)).removeAnnotations(editorPart, thread);
        }
    }

    @Override
    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        IDebugModelPresentation presentation = this.getPresentation();
        if (presentation instanceof IDebugEditorPresentation) {
            return ((IDebugEditorPresentation)((Object)presentation)).addAnnotations(editorPart, frame);
        }
        return false;
    }

    public LazyModelPresentation(IConfigurationElement configElement) {
        this.fConfig = configElement;
    }

    public LazyModelPresentation(DelegatingModelPresentation parent, IConfigurationElement configElement) {
        this(configElement);
        this.fOwner = parent;
    }

    @Override
    public Image getImage(Object element) {
        int flags;
        this.initImageRegistry();
        Image image = this.getPresentation().getImage(element);
        if (image == null) {
            image = this.getDefaultImage(element);
        }
        if (image != null && (flags = this.computeAdornmentFlags(element)) > 0) {
            CompositeDebugImageDescriptor descriptor = new CompositeDebugImageDescriptor(image, flags);
            return DebugUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
        }
        return image;
    }

    private synchronized void initImageRegistry() {
        if (!DebugPluginImages.isInitialized()) {
            DebugUIPlugin.getDefault().getImageRegistry();
        }
    }

    private int computeAdornmentFlags(Object element) {
        if (element instanceof IBreakpoint && !DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return 1;
        }
        return 0;
    }

    protected String getDefaultText(Object element) {
        return DebugUIPlugin.getDefaultLabelProvider().getText(element);
    }

    protected Image getDefaultImage(Object element) {
        return DebugUIPlugin.getDefaultLabelProvider().getImage(element);
    }

    @Override
    public String getText(Object element) {
        String text;
        if (!(element instanceof IndexedVariablePartition) && (text = this.getPresentation().getText(element)) != null) {
            return text;
        }
        if (this.showVariableTypeNames()) {
            try {
                if (element instanceof IExpression) {
                    String type;
                    StringBuffer buf = new StringBuffer();
                    IValue value = ((IExpression)element).getValue();
                    if (value != null && (type = value.getReferenceTypeName()) != null && type.length() > 0) {
                        buf.append(type);
                        buf.append(' ');
                    }
                    buf.append(this.getDefaultText(element));
                    return buf.toString();
                }
                if (element instanceof IVariable) {
                    return new StringBuffer(((IVariable)element).getValue().getReferenceTypeName()).append(' ').append(this.getDefaultText(element)).toString();
                }
            }
            catch (DebugException de) {
                DebugUIPlugin.log(de);
            }
        }
        return this.getDefaultText(element);
    }

    protected boolean showVariableTypeNames() {
        Boolean show = (Boolean)this.fAttributes.get("org.eclipse.debug.ui.displayVariableTypeNames");
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    @Override
    public void computeDetail(IValue value, IValueDetailListener listener) {
        this.getPresentation().computeDetail(value, listener);
    }

    @Override
    public IEditorInput getEditorInput(Object element) {
        return this.getPresentation().getEditorInput(element);
    }

    @Override
    public String getEditorId(IEditorInput input, Object inputObject) {
        return this.getPresentation().getEditorId(input, inputObject);
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fPresentation != null) {
            this.getPresentation().addListener(listener);
        }
        this.fListeners.add((Object)listener);
    }

    public void dispose() {
        if (this.fPresentation != null) {
            this.getPresentation().dispose();
        }
        this.fListeners = null;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (this.fPresentation != null) {
            return this.getPresentation().isLabelProperty(element, property);
        }
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        ListenerList<ILabelProviderListener> listeners;
        if (this.fPresentation != null) {
            this.getPresentation().removeListener(listener);
        }
        if ((listeners = this.fListeners) != null) {
            listeners.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IDebugModelPresentation getPresentation() {
        if (this.fPresentation == null) {
            LazyModelPresentation lazyModelPresentation = this;
            synchronized (lazyModelPresentation) {
                if (this.fPresentation != null) {
                    return this.fPresentation;
                }
                try {
                    IDebugModelPresentation tempPresentation = (IDebugModelPresentation)DebugUIPlugin.createExtension(this.fConfig, "class");
                    if (this.fListeners != null) {
                        for (ILabelProviderListener iLabelProviderListener : this.fListeners) {
                            tempPresentation.addListener(iLabelProviderListener);
                        }
                    }
                    for (Map.Entry<String, Object> entry : this.fAttributes.entrySet()) {
                        tempPresentation.setAttribute(entry.getKey(), entry.getValue());
                    }
                    this.fPresentation = tempPresentation;
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
        return this.fPresentation;
    }

    @Override
    public void setAttribute(String id, Object value) {
        if (value == null) {
            return;
        }
        if (this.fPresentation != null) {
            this.getPresentation().setAttribute(id, value);
        }
        this.fAttributes.put(id, value);
        if (this.fOwner != null) {
            this.fOwner.basicSetAttribute(id, value);
        }
    }

    public String getDebugModelIdentifier() {
        return this.fConfig.getAttribute("id");
    }

    public SourceViewerConfiguration newDetailsViewerConfiguration() throws CoreException {
        String attr = this.fConfig.getAttribute("detailsViewerConfiguration");
        if (attr != null) {
            return (SourceViewerConfiguration)this.fConfig.createExecutableExtension("detailsViewerConfiguration");
        }
        return null;
    }

    public Map<String, Object> getAttributeMap() {
        return new HashMap<String, Object>(this.fAttributes);
    }

    public Map<String, Object> getAttributes() {
        return this.fAttributes;
    }

    public Color getForeground(Object element) {
        IDebugModelPresentation presentation = this.getPresentation();
        if (presentation instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)presentation;
            return colorProvider.getForeground(element);
        }
        return null;
    }

    public Color getBackground(Object element) {
        IDebugModelPresentation presentation = this.getPresentation();
        if (presentation instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)presentation;
            return colorProvider.getBackground(element);
        }
        return null;
    }

    public Font getFont(Object element) {
        IDebugModelPresentation presentation = this.getPresentation();
        if (presentation instanceof IFontProvider) {
            IFontProvider fontProvider = (IFontProvider)presentation;
            return fontProvider.getFont(element);
        }
        return null;
    }

    @Override
    public Annotation getInstructionPointerAnnotation(IEditorPart editorPart, IStackFrame frame) {
        IDebugModelPresentation presentation = this.getPresentation();
        if (presentation instanceof IInstructionPointerPresentation) {
            IInstructionPointerPresentation pointerPresentation = (IInstructionPointerPresentation)presentation;
            return pointerPresentation.getInstructionPointerAnnotation(editorPart, frame);
        }
        return null;
    }

    @Override
    public String getInstructionPointerAnnotationType(IEditorPart editorPart, IStackFrame frame) {
        IDebugModelPresentation presentation = this.getPresentation();
        if (presentation instanceof IInstructionPointerPresentation) {
            IInstructionPointerPresentation pointerPresentation = (IInstructionPointerPresentation)presentation;
            return pointerPresentation.getInstructionPointerAnnotationType(editorPart, frame);
        }
        return null;
    }

    @Override
    public Image getInstructionPointerImage(IEditorPart editorPart, IStackFrame frame) {
        IDebugModelPresentation presentation = this.getPresentation();
        if (presentation instanceof IInstructionPointerPresentation) {
            IInstructionPointerPresentation pointerPresentation = (IInstructionPointerPresentation)presentation;
            return pointerPresentation.getInstructionPointerImage(editorPart, frame);
        }
        return null;
    }

    @Override
    public String getInstructionPointerText(IEditorPart editorPart, IStackFrame frame) {
        IDebugModelPresentation presentation = this.getPresentation();
        if (presentation instanceof IInstructionPointerPresentation) {
            IInstructionPointerPresentation pointerPresentation = (IInstructionPointerPresentation)presentation;
            return pointerPresentation.getInstructionPointerText(editorPart, frame);
        }
        return null;
    }

    @Override
    public boolean requiresUIThread(Object element) {
        if (!DebugPluginImages.isInitialized()) {
            return true;
        }
        IDebugModelPresentation presentation = this.getPresentation();
        if (presentation instanceof IDebugModelPresentationExtension) {
            return ((IDebugModelPresentationExtension)presentation).requiresUIThread(element);
        }
        return false;
    }
}

