/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ModuleDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ModuleEncapsulationDetail;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ModuleAddExportsBlock {
    private final IStatusChangeListener fContext;
    private StringDialogField fSourceModule;
    private StringDialogField fPackage;
    private StringDialogField fTargetModules;
    private IStatus fSourceModuleStatus;
    private IStatus fPackageStatus;
    private Control fSWTWidget;
    private final ModuleEncapsulationDetail.ModuleAddExport fInitialValue;
    private IJavaElement[] fSourceJavaElements;

    public ModuleAddExportsBlock(IStatusChangeListener context, IJavaElement[] sourceJavaElements, ModuleEncapsulationDetail.ModuleAddExport initialValue) {
        this.fContext = context;
        this.fInitialValue = initialValue;
        this.fSourceJavaElements = sourceJavaElements;
        this.fSourceModuleStatus = new StatusInfo();
        this.fPackageStatus = new StatusInfo();
        IDialogFieldListener adapter = field -> this.addExportsDialogFieldChanged(field);
        this.fSourceModule = new StringDialogField();
        this.fSourceModule.setDialogFieldListener(adapter);
        this.fSourceModule.setLabelText(NewWizardMessages.AddExportsBlock_sourceModule_label);
        this.fPackage = new StringDialogField();
        this.fPackage.setDialogFieldListener(adapter);
        this.fPackage.setLabelText(NewWizardMessages.AddExportsBlock_package_label);
        this.fTargetModules = new StringDialogField();
        this.fTargetModules.setDialogFieldListener(adapter);
        this.fTargetModules.setLabelText(NewWizardMessages.AddExportsBlock_targetModules_label);
        this.setDefaults();
    }

    private void setDefaults() {
        if (this.fInitialValue != null) {
            this.fSourceModule.setText(this.fInitialValue.fSourceModule);
            if (!(this.fInitialValue.fSourceModule.isEmpty() || this.fSourceJavaElements != null && this.fSourceJavaElements.length > 1)) {
                this.fSourceModule.setEnabled(false);
            }
            this.fPackage.setText(this.fInitialValue.fPackage);
            this.fTargetModules.setText(this.fInitialValue.fTargetModules);
            this.fTargetModules.setEnabled(false);
        }
    }

    private Set<String> moduleNames() {
        HashSet<String> moduleNames = new HashSet<String>();
        if (this.fSourceJavaElements != null) {
            int i = 0;
            while (i < this.fSourceJavaElements.length) {
                IModuleDescription module;
                if (this.fSourceJavaElements[i] instanceof IPackageFragmentRoot && (module = ((IPackageFragmentRoot)this.fSourceJavaElements[i]).getModuleDescription()) != null) {
                    moduleNames.add(module.getElementName());
                }
                ++i;
            }
        }
        return moduleNames;
    }

    private String getSourceModuleText() {
        return this.fSourceModule.getText().trim();
    }

    private String getPackageText() {
        return this.fPackage.getText().trim();
    }

    private String getTargetModulesText() {
        return this.fTargetModules.getText().trim();
    }

    private IPackageFragmentRoot[] findRoots(Predicate<IModuleDescription> match) {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        if (this.fSourceJavaElements != null) {
            IJavaElement[] iJavaElementArray = this.fSourceJavaElements;
            int n = this.fSourceJavaElements.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageRoot;
                IModuleDescription module;
                IJavaElement root = iJavaElementArray[n2];
                if (root instanceof IJavaProject) {
                    try {
                        IJavaProject project = (IJavaProject)root;
                        module = project.getModuleDescription();
                        if (match.test(module)) {
                            return project.getPackageFragmentRoots();
                        }
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                    }
                } else if (root instanceof IPackageFragmentRoot && match.test(module = (packageRoot = (IPackageFragmentRoot)root).getModuleDescription())) {
                    result.add(packageRoot);
                }
                ++n2;
            }
        }
        if (!result.isEmpty()) {
            return result.toArray(new IPackageFragmentRoot[result.size()]);
        }
        return null;
    }

    public String getValue() {
        String sourceModule = this.getSourceModuleText();
        String pack = this.getPackageText();
        String targetModules = this.getTargetModulesText();
        if (sourceModule.isEmpty() || pack.isEmpty() || targetModules.isEmpty()) {
            return "";
        }
        return String.valueOf(sourceModule) + '/' + pack + '=' + targetModules;
    }

    public ModuleEncapsulationDetail.ModuleAddExport getExport(CPListElementAttribute parentAttribute) {
        String sourceModule = this.getSourceModuleText();
        String pack = this.getPackageText();
        String targetModules = this.getTargetModulesText();
        if (sourceModule.isEmpty() || pack.isEmpty() || targetModules.isEmpty()) {
            return null;
        }
        return new ModuleEncapsulationDetail.ModuleAddExport(sourceModule, pack, targetModules, parentAttribute);
    }

    public Control createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        int widthHint = converter.convertWidthInCharsToPixels(60);
        GridData gd = new GridData(4, 1, false, false, 2, 1);
        gd.widthHint = converter.convertWidthInCharsToPixels(50);
        Label message = new Label(composite, 16448);
        message.setLayoutData((Object)gd);
        message.setText(NewWizardMessages.AddExportsBlock_message);
        DialogField.createEmptySpace(composite, 2);
        this.fSourceModule.doFillIntoGrid(composite, 2);
        Text sourceModuleField = this.fSourceModule.getTextControl(null);
        LayoutUtil.setWidthHint((Control)sourceModuleField, widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)sourceModuleField);
        BidiUtils.applyBidiProcessing((Text)sourceModuleField, (String)"java");
        if (this.fSourceJavaElements != null) {
            ModuleDialog.configureModuleContentAssist(this.fSourceModule.getTextControl(composite), this.moduleNames());
        }
        DialogField.createEmptySpace(composite, 2);
        this.fPackage.doFillIntoGrid(composite, 2);
        Text packageField = this.fPackage.getTextControl(null);
        LayoutUtil.setWidthHint((Control)packageField, widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)packageField);
        BidiUtils.applyBidiProcessing((Text)packageField, (String)"java");
        this.configurePackageContentAssist(this.fPackage.getTextControl(composite));
        DialogField.createEmptySpace(composite, 2);
        this.fTargetModules.doFillIntoGrid(composite, 2);
        Text targetModulesField = this.fTargetModules.getTextControl(null);
        LayoutUtil.setWidthHint((Control)targetModulesField, widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)targetModulesField);
        BidiUtils.applyBidiProcessing((Text)targetModulesField, (String)"java");
        DialogField.createEmptySpace(composite, 2);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.annotations_attachment_dialog_context");
        return composite;
    }

    private void configurePackageContentAssist(Text textControl) {
        if (this.fSourceJavaElements == null || this.fSourceJavaElements.length == 0) {
            return;
        }
        JavaPackageCompletionProcessor packageCompletionProcessor = new JavaPackageCompletionProcessor();
        packageCompletionProcessor.setFilter(fragment -> {
            IModuleDescription module;
            block4: {
                try {
                    if (fragment.containsJavaResources()) break block4;
                    return false;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            String sourceModule = this.getSourceModuleText();
            if (!sourceModule.isEmpty() && (module = ((IPackageFragmentRoot)fragment.getParent()).getModuleDescription()) != null) {
                return sourceModule.equals(module.getElementName());
            }
            return true;
        });
        switch (this.fSourceJavaElements[0].getElementType()) {
            case 2: {
                try {
                    assert (this.fSourceJavaElements.length == 1);
                    IPackageFragmentRoot[] packageFragmentRoots = ((IJavaProject)this.fSourceJavaElements[0]).getPackageFragmentRoots();
                    int count = 0;
                    int i = 0;
                    while (i < packageFragmentRoots.length) {
                        if (packageFragmentRoots[i].getKind() == 1) {
                            packageFragmentRoots[count++] = packageFragmentRoots[i];
                        }
                        ++i;
                    }
                    if (count < packageFragmentRoots.length) {
                        packageFragmentRoots = Arrays.copyOf(packageFragmentRoots, count);
                    }
                    packageCompletionProcessor.setPackageFragmentRoot(packageFragmentRoots);
                    ControlContentAssistHelper.createTextContentAssistant(textControl, packageCompletionProcessor);
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
                break;
            }
            case 3: {
                IPackageFragmentRoot[] roots = new IPackageFragmentRoot[this.fSourceJavaElements.length];
                int i = 0;
                while (i < this.fSourceJavaElements.length) {
                    roots[i] = (IPackageFragmentRoot)this.fSourceJavaElements[i];
                    ++i;
                }
                packageCompletionProcessor.setPackageFragmentRoot(roots);
                ControlContentAssistHelper.createTextContentAssistant(textControl, packageCompletionProcessor);
            }
        }
    }

    private void addExportsDialogFieldChanged(DialogField field) {
        if (this.fSWTWidget != null) {
            if (field == this.fSourceModule && this.fSourceModule.isEnabled()) {
                this.updateModuleStatus();
            } else if (field == this.fPackage && this.fPackage.isEnabled()) {
                this.updatePackageStatus();
            }
            this.doStatusLineUpdate(field);
        }
    }

    private void updateModuleStatus() {
        this.fSourceModuleStatus = this.computeSourceModuleStatus(this.getSourceModuleText());
    }

    private void updatePackageStatus() {
        this.fPackageStatus = this.computePackageStatus(this.getPackageText());
    }

    private IStatus computeSourceModuleStatus(String value) {
        StatusInfo status = new StatusInfo();
        if (value.isEmpty()) {
            status.setError(NewWizardMessages.ModuleAddExportsBlock_sourceModuleEmpty_error);
            return status;
        }
        if (this.moduleNames().contains(value)) {
            if (!this.getPackageText().isEmpty()) {
                this.updatePackageStatus();
            }
            return status;
        }
        status.setError(Messages.format(NewWizardMessages.ModuleAddExportsBlock_wrongSourceModule_error, value));
        return status;
    }

    private IStatus computePackageStatus(String value) {
        IPackageFragmentRoot[] roots;
        StatusInfo status = new StatusInfo();
        if (value.isEmpty()) {
            status.setError(NewWizardMessages.ModuleAddExportsBlock_packageEmpty_error);
            return status;
        }
        boolean needToSetSource = false;
        String moduleName = this.getSourceModuleText();
        if (!moduleName.isEmpty()) {
            roots = this.findRoots(mod -> mod != null && mod.getElementName().equals(moduleName));
        } else {
            roots = this.findRoots(mod -> true);
            needToSetSource = true;
        }
        if (roots != null) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                IPackageFragment packageFragment = root.getPackageFragment(value);
                try {
                    if (packageFragment.exists() && packageFragment.containsJavaResources()) {
                        IModuleDescription module;
                        if (needToSetSource && (module = root.getModuleDescription()) != null) {
                            this.fSourceModule.setText(module.getElementName());
                        }
                        return status;
                    }
                }
                catch (JavaModelException e) {
                    return e.getStatus();
                }
                ++n2;
            }
        }
        status.setError(Messages.format(NewWizardMessages.ModuleAddExportsBlock_wrongPackage_error, new Object[]{value, this.getSourceModuleText()}));
        return status;
    }

    private void doStatusLineUpdate(DialogField currentField) {
        IStatus status = null;
        if (!this.fSourceModuleStatus.isOK()) {
            status = this.fSourceModuleStatus;
        } else if (!this.fPackageStatus.isOK()) {
            status = this.fPackageStatus;
            if (currentField != this.fPackage) {
                this.fPackage.setFocus();
            }
        }
        if (status == null) {
            status = this.getPackageText().isEmpty() ? ModuleDialog.newSilentError() : Status.OK_STATUS;
        }
        this.fContext.statusChanged(status);
    }
}

