/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class NewClassWizardPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewClassWizardPage";
    private static final String SETTINGS_CREATECONSTR = "create_constructor";
    private static final String SETTINGS_CREATEUNIMPLEMENTED = "create_unimplemented";
    private SelectionButtonDialogFieldGroup fMethodStubsButtons;

    public NewClassWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle(NewWizardMessages.NewClassWizardPage_title);
        this.setDescription(NewWizardMessages.NewClassWizardPage_description);
        String[] buttonNames3 = new String[]{NewWizardMessages.NewClassWizardPage_methods_main, NewWizardMessages.NewClassWizardPage_methods_constructors, NewWizardMessages.NewClassWizardPage_methods_inherited};
        this.fMethodStubsButtons = new SelectionButtonDialogFieldGroup(32, buttonNames3, 1);
        this.fMethodStubsButtons.setLabelText(NewWizardMessages.NewClassWizardPage_methods_label);
    }

    public void init(IStructuredSelection selection) {
        IDialogSettings section;
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
        boolean createMain = false;
        boolean createConstructors = false;
        boolean createUnimplemented = true;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (section = dialogSettings.getSection(PAGE_NAME)) != null) {
            createConstructors = section.getBoolean(SETTINGS_CREATECONSTR);
            createUnimplemented = section.getBoolean(SETTINGS_CREATEUNIMPLEMENTED);
        }
        this.setMethodStubSelection(createMain, createConstructors, createUnimplemented, true);
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    @Override
    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_class_wizard_page_context");
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    private void createMethodStubSelectionControls(Composite composite, int nColumns) {
        Label labelControl = this.fMethodStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, nColumns);
        DialogField.createEmptySpace(composite);
        Composite buttonGroup = this.fMethodStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, nColumns - 1);
    }

    public boolean isCreateMain() {
        return this.fMethodStubsButtons.isSelected(0);
    }

    public boolean isCreateConstructors() {
        return this.fMethodStubsButtons.isSelected(1);
    }

    public boolean isCreateInherited() {
        return this.fMethodStubsButtons.isSelected(2);
    }

    public void setMethodStubSelection(boolean createMain, boolean createConstructors, boolean createInherited, boolean canBeModified) {
        this.fMethodStubsButtons.setSelection(0, createMain);
        this.fMethodStubsButtons.setSelection(1, createConstructors);
        this.fMethodStubsButtons.setSelection(2, createInherited);
        this.fMethodStubsButtons.setEnabled(canBeModified);
    }

    @Override
    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        IDialogSettings dialogSettings;
        boolean doMain = this.isCreateMain();
        boolean doConstr = this.isCreateConstructors();
        boolean doInherited = this.isCreateInherited();
        this.createInheritedMethods(type, doConstr, doInherited, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (doMain) {
            String comment;
            StringBuffer buf = new StringBuffer();
            if (this.isAddComments() && (comment = CodeGeneration.getMethodComment(type.getCompilationUnit(), type.getTypeQualifiedName('.'), "main", new String[]{"args"}, new String[0], Signature.createTypeSignature((String)"void", (boolean)true), null, "\n")) != null) {
                buf.append(comment);
                buf.append("\n");
            }
            buf.append("public static void main(");
            buf.append(imports.addImport("java.lang.String"));
            buf.append("[] args) {");
            buf.append("\n");
            String content = CodeGeneration.getMethodBodyContent(type.getCompilationUnit(), type.getTypeQualifiedName('.'), "main", false, "", "\n");
            if (content != null && content.length() != 0) {
                buf.append(content);
            }
            buf.append("\n");
            buf.append("}");
            type.createMethod(buf.toString(), null, false, null);
        }
        if ((dialogSettings = this.getDialogSettings()) != null) {
            IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
            if (section == null) {
                section = dialogSettings.addNewSection(PAGE_NAME);
            }
            section.put(SETTINGS_CREATECONSTR, this.isCreateConstructors());
            section.put(SETTINGS_CREATEUNIMPLEMENTED, this.isCreateInherited());
        }
        if (monitor != null) {
            monitor.done();
        }
    }
}

