/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class RemotePluginTestRunner
extends RemoteTestRunner {
    private String fTestPluginName;
    private ClassLoader fLoaderClassLoader;

    public static void main(String[] args) {
        RemotePluginTestRunner testRunner = new RemotePluginTestRunner();
        testRunner.init(args);
        ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
        if (RemotePluginTestRunner.isJUnit5(args)) {
            Thread.currentThread().setContextClassLoader(RemotePluginTestRunner.getPluginClassLoader(testRunner.getfTestPluginName()));
        }
        testRunner.run();
        if (RemotePluginTestRunner.isJUnit5(args)) {
            Thread.currentThread().setContextClassLoader(currentTCCL);
        }
    }

    private static ClassLoader getPluginClassLoader(String getfTestPluginName) {
        Bundle bundle = Platform.getBundle((String)getfTestPluginName);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle \"" + getfTestPluginName + "\" not found. Possible causes include missing dependencies, too restrictive version ranges, or a non-matching required execution environment.");
        }
        return new TestBundleClassLoader(bundle);
    }

    protected ClassLoader getTestClassLoader() {
        String pluginId = this.getfTestPluginName();
        return this.getClassLoader(pluginId);
    }

    public ClassLoader getClassLoader(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle \"" + bundleId + "\" not found. Possible causes include missing dependencies, too restrictive version ranges, or a non-matching required execution environment.");
        }
        return new BundleClassLoader(bundle);
    }

    public void init(String[] args) {
        this.readPluginArgs(args);
        boolean isJUnit5 = RemotePluginTestRunner.isJUnit5(args);
        if (isJUnit5) {
            ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
            try {
                Bundle[] bundles;
                ArrayList<String> platformEngines = new ArrayList<String>();
                Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
                Bundle[] bundleArray = bundles = bundle.getBundleContext().getBundles();
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle iBundle = bundleArray[n2];
                    try {
                        BundleWiring bundleWiring = (BundleWiring)Platform.getBundle((String)iBundle.getSymbolicName()).adapt(BundleWiring.class);
                        Collection listResources = bundleWiring.listResources("META-INF/services", "org.junit.platform.engine.TestEngine", 2);
                        if (!listResources.isEmpty()) {
                            platformEngines.add(iBundle.getSymbolicName());
                        }
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
                Thread.currentThread().setContextClassLoader(this.getJUnit5Classloader(platformEngines));
                this.defaultInit(args);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentTCCL);
            }
            return;
        }
        this.defaultInit(args);
    }

    private ClassLoader getJUnit5Classloader(List<String> platformEngine) {
        ArrayList<Bundle> platformEngineBundles = new ArrayList<Bundle>();
        for (String string : platformEngine) {
            Bundle bundle = Platform.getBundle((String)string);
            platformEngineBundles.add(bundle);
        }
        return new MultiBundleClassLoader(platformEngineBundles);
    }

    private static boolean isJUnit5(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("org.eclipse.jdt.internal.junit5.runner.JUnit5TestLoader")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void readPluginArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (this.isFlag(args, i, "-testpluginname")) {
                this.setfTestPluginName(args[i + 1]);
            }
            if (this.isFlag(args, i, "-loaderpluginname")) {
                this.fLoaderClassLoader = this.getClassLoader(args[i + 1]);
            }
            ++i;
        }
        if (this.getfTestPluginName() == null) {
            throw new IllegalArgumentException("Parameter -testpluginnname not specified.");
        }
        if (this.fLoaderClassLoader == null) {
            this.fLoaderClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
    }

    protected Class<?> loadTestLoaderClass(String className) throws ClassNotFoundException {
        return this.fLoaderClassLoader.loadClass(className);
    }

    private boolean isFlag(String[] args, int i, String wantedFlag) {
        String lowerCase = args[i].toLowerCase(Locale.ENGLISH);
        return lowerCase.equals(wantedFlag) && i < args.length - 1;
    }

    public String getfTestPluginName() {
        return this.fTestPluginName;
    }

    public void setfTestPluginName(String fTestPluginName) {
        this.fTestPluginName = fTestPluginName;
    }

    class BundleClassLoader
    extends ClassLoader {
        private Bundle bundle;

        public BundleClassLoader(Bundle target) {
            this.bundle = target;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }

        @Override
        protected URL findResource(String name) {
            return this.bundle.getResource(name);
        }

        protected Enumeration findResources(String name) throws IOException {
            return this.bundle.getResources(name);
        }
    }

    class MultiBundleClassLoader
    extends ClassLoader {
        private List<Bundle> bundleList;

        public MultiBundleClassLoader(List<Bundle> platformEngineBundles) {
            this.bundleList = platformEngineBundles;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class c = null;
            for (Bundle temp : this.bundleList) {
                try {
                    c = temp.loadClass(name);
                    if (c == null) continue;
                    return c;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            return c;
        }

        @Override
        protected URL findResource(String name) {
            URL url = null;
            for (Bundle temp : this.bundleList) {
                url = temp.getResource(name);
                if (url == null) continue;
                return url;
            }
            return url;
        }

        protected Enumeration findResources(String name) throws IOException {
            Enumeration enumFinal = null;
            int i = 0;
            while (i < this.bundleList.size()) {
                if (i == 0) {
                    enumFinal = this.bundleList.get(i).getResources(name);
                } else {
                    Enumeration e2 = this.bundleList.get(i).getResources(name);
                    Vector temp = new Vector();
                    while (enumFinal != null && enumFinal.hasMoreElements()) {
                        temp.add(enumFinal.nextElement());
                    }
                    while (e2 != null && e2.hasMoreElements()) {
                        temp.add(e2.nextElement());
                    }
                    enumFinal = temp.elements();
                }
                ++i;
            }
            return enumFinal;
        }
    }

    static class TestBundleClassLoader
    extends ClassLoader {
        protected Bundle bundle;

        public TestBundleClassLoader(Bundle target) {
            this.bundle = target;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }

        @Override
        protected URL findResource(String name) {
            return this.bundle.getResource(name);
        }

        protected Enumeration findResources(String name) throws IOException {
            return this.bundle.getResources(name);
        }

        @Override
        public Enumeration<URL> getResources(String res) throws IOException {
            ArrayList<URL> resources = new ArrayList<URL>(6);
            String location = null;
            URL url = null;
            if (this.bundle instanceof EquinoxBundle) {
                location = ((EquinoxBundle)this.bundle).getLocation();
            }
            if (location != null && location.startsWith("reference:")) {
                location = location.substring(10, location.length());
                URI uri = URI.create(location);
                String newPath = String.valueOf(uri.getPath()) + "bin" + '/' + res;
                URI newUri = uri.resolve(newPath);
                url = newUri.normalize().toURL();
            }
            if (url != null) {
                File f = new File(url.getFile());
                if (f.exists()) {
                    resources.add(url);
                }
            } else {
                return Collections.emptyEnumeration();
            }
            return Collections.enumeration(resources);
        }
    }
}

