/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.debug.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.debug.Breakpoint;
import org.eclipse.rcptt.debug.BreakpointResource;
import org.eclipse.rcptt.debug.Collection;
import org.eclipse.rcptt.debug.DebugContext;
import org.eclipse.rcptt.debug.DebugContextAdapter;
import org.eclipse.rcptt.debug.DebugPackage;
import org.eclipse.rcptt.debug.Launch;
import org.eclipse.rcptt.debug.LaunchConfiguration;
import org.eclipse.rcptt.debug.LaunchType;
import org.eclipse.rcptt.debug.ListValue;
import org.eclipse.rcptt.debug.MapValue;
import org.eclipse.rcptt.debug.PrimitiveValue;
import org.eclipse.rcptt.debug.SetValue;
import org.eclipse.rcptt.ecl.core.EclBoolean;
import org.eclipse.rcptt.ecl.core.EclInteger;
import org.eclipse.rcptt.ecl.core.EclString;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeColumn;

public class ContentProvider
implements ITreeContentProvider {
    private DebugContext content;
    private static final Object[] none = new Object[0];
    protected final ImageRegistry imageRegistry = new ImageRegistry();
    private final ColumnLabelProvider nameLabelProvider = new ColumnLabelProvider(){

        public Image getImage(Object element) {
            if (element instanceof EList) {
                if (element == ContentProvider.this.content.getBreakpointResources()) {
                    return Images.getImage((String)"icons/launching/breakpoint.gif");
                }
                if (element == ContentProvider.this.content.getLaunches()) {
                    return Images.getImage((String)"icons/launching/run_exc.gif");
                }
                if (element == ContentProvider.this.content.getLaunchTypes()) {
                    return Images.getImage((String)"icons/preferences.gif");
                }
                return Images.getImage((String)"icons/preferences/pref_data.gif");
            }
            if (element instanceof LaunchType) {
                return ContentProvider.this.getCachedImage(((LaunchType)element).getId(), ((LaunchType)element).getImage());
            }
            if (element instanceof LaunchConfiguration) {
                return this.getImage(((LaunchConfiguration)element).eContainer());
            }
            if (element instanceof Launch) {
                return this.getImage(((Launch)element).getConfiguration());
            }
            if (element instanceof BreakpointResource) {
                return Images.getImage((String)"icons/file.gif");
            }
            if (element instanceof Breakpoint) {
                return Images.getImage((String)"icons/launching/breakpoint.gif");
            }
            if (element instanceof ListValue) {
                return Images.getImage((String)"icons/preferences/pref_data.gif");
            }
            if (element instanceof MapValue) {
                return Images.getImage((String)"icons/preferences/pref_node.gif");
            }
            if (element instanceof SetValue) {
                return Images.getImage((String)"icons/preferences/pref_data.gif");
            }
            if (element instanceof PrimitiveValue) {
                EObject value = ((PrimitiveValue)element).getValue();
                if (value instanceof EclString) {
                    return Images.getImage((String)"icons/preferences/pref_data.gif");
                }
                if (value instanceof EclInteger) {
                    return Images.getImage((String)"icons/ecl/attr.gif");
                }
                if (value instanceof EclBoolean) {
                    return Images.getImage((String)"icons/ecl/attr.gif");
                }
            }
            if (element instanceof FeatureOfEObject) {
                return ((FeatureOfEObject)element).getImage();
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof EList) {
                if (element == ContentProvider.this.content.getBreakpointResources()) {
                    return "Breakpoints";
                }
                if (element == ContentProvider.this.content.getLaunches()) {
                    return "Launches";
                }
                if (element == ContentProvider.this.content.getLaunchTypes()) {
                    return "Launch configurations";
                }
            }
            if (element instanceof AttributeOfEObject) {
                return ((AttributeOfEObject)element).getName();
            }
            if (element instanceof BreakpointResource) {
                return ((BreakpointResource)element).getPath();
            }
            if (element instanceof Launch) {
                return ((Launch)element).getConfiguration().getName();
            }
            if (element instanceof FeatureOfEObject) {
                return ((FeatureOfEObject)element).getName();
            }
            if (element instanceof Breakpoint) {
                Breakpoint breakpoint = (Breakpoint)element;
                PrimitiveValue messageAttr = (PrimitiveValue)DebugContextAdapter.findAttribute((List)breakpoint.getAttributes(), (String)"message");
                if (messageAttr == null) {
                    return null;
                }
                return (String)BoxedValues.unbox((Object)messageAttr.getValue());
            }
            if (element instanceof NamedElement) {
                return ((NamedElement)element).getName();
            }
            return super.getText(element);
        }
    };
    private final ColumnLabelProvider valueLabelProvider = new ColumnLabelProvider(){

        public String getText(Object element) {
            if (element instanceof PrimitiveValue) {
                return BoxedValues.unbox((Object)((PrimitiveValue)element).getValue()).toString();
            }
            if (element instanceof AttributeOfEObject) {
                String value = ((AttributeOfEObject)element).getValueLabel();
                if (value != null) {
                    return value.toString();
                }
                return null;
            }
            return null;
        }
    };

    protected Image getCachedImage(String id, byte[] bytes) {
        Image image = this.imageRegistry.get(id);
        if (image == null) {
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            ImageData imageData = new ImageData((InputStream)new ByteArrayInputStream(bytes));
            image = new Image((Device)Display.getDefault(), imageData);
            this.imageRegistry.put(id, image);
        }
        return image;
    }

    public void dispose() {
        this.imageRegistry.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.content = (DebugContext)newInput;
    }

    public Object[] getElements(Object inputElement) {
        DebugContext context = (DebugContext)inputElement;
        ArrayList<EList> rootNodes = new ArrayList<EList>();
        DebugContextAdapter adapter = new DebugContextAdapter(context);
        if (adapter.getNonEmptyLaunchTypes().size() > 0) {
            rootNodes.add(context.getLaunchTypes());
        }
        if (context.getLaunches().size() > 0) {
            rootNodes.add(context.getLaunches());
        }
        if (adapter.getNonEmptyBreakpointResources().size() > 0) {
            rootNodes.add(context.getBreakpointResources());
        }
        return rootNodes.toArray();
    }

    public Object[] getChildrenFromCollection(EObject value) {
        if (value instanceof Collection) {
            return ((Collection)value).getEntries().toArray();
        }
        return none;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof EList) {
            ArrayList rv = new ArrayList();
            for (Object child : (EList)parentElement) {
                if (this.getChildren(child).length <= 0) continue;
                rv.add(child);
            }
            return rv.toArray();
        }
        if (parentElement instanceof Collection) {
            Collection attribute = (Collection)parentElement;
            return attribute.getEntries().toArray();
        }
        if (parentElement instanceof FeatureOfEObject) {
            return ((FeatureOfEObject)parentElement).getChildren();
        }
        if (parentElement instanceof EObject) {
            EObject eObject = (EObject)parentElement;
            ArrayList<FeatureOfEObject> rv = new ArrayList<FeatureOfEObject>();
            if (eObject instanceof Breakpoint) {
                rv.add(new AttributeOfEObject(eObject, DebugPackage.Literals.BREAKPOINT__ENABLED));
                rv.add(new AttributeOfEObject(eObject, DebugPackage.Literals.BREAKPOINT__PERSISTED));
                rv.add(new AttributeOfEObject(eObject, DebugPackage.Literals.BREAKPOINT__REGISTERED));
                rv.add(new AttributeOfEObject(eObject, DebugPackage.Literals.BREAKPOINT__TYPE));
            }
            if (eObject instanceof Launch) {
                rv.add(new ReferenceOfEObject(eObject, DebugPackage.Literals.LAUNCH__CONFIGURATION));
                rv.add(new AttributeOfEObject(eObject, DebugPackage.Literals.LAUNCH__MODE));
                rv.add(new ReferenceOfEObject(eObject, DebugPackage.Literals.LAUNCH__CONFIGURATION_DELTA));
            }
            if (eObject instanceof LaunchType) {
                rv.addAll((java.util.Collection<FeatureOfEObject>)((EList)eObject.eGet((EStructuralFeature)DebugPackage.Literals.LAUNCH_TYPE__CONFIGURATIONS)));
            }
            if (eObject instanceof BreakpointResource) {
                rv.addAll((java.util.Collection<FeatureOfEObject>)((EList)eObject.eGet((EStructuralFeature)DebugPackage.Literals.BREAKPOINT_RESOURCE__BREAKPOINTS)));
            }
            for (EReference reference : eObject.eClass().getEAllContainments()) {
                if (!reference.getName().equals("attributes")) continue;
                rv.addAll((java.util.Collection<FeatureOfEObject>)((EList)eObject.eGet((EStructuralFeature)reference)));
            }
            return rv.toArray();
        }
        return none;
    }

    public Object getParent(Object element) {
        if (element == this.content.getBreakpointResources() || element == this.content.getLaunches() || element == this.content.getLaunchTypes()) {
            return this.content;
        }
        if (element instanceof EObject && ((EObject)element).eContainer() != null) {
            return ((EObject)element).eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof EList) {
            return ((EList)element).size() > 0;
        }
        if (element instanceof PrimitiveValue) {
            return false;
        }
        if (element instanceof ReferenceOfEObject) {
            return true;
        }
        return element instanceof EObject;
    }

    public boolean isRemovable(Object object) {
        if (object instanceof Breakpoint || object instanceof LaunchType || object instanceof BreakpointResource || object instanceof Launch) {
            return true;
        }
        if (object instanceof EObject) {
            EReference reference = ((EObject)object).eContainmentFeature();
            return reference.getUpperBound() == -1;
        }
        Object parent = this.getParent(object);
        return parent instanceof DebugContext || parent instanceof Collection;
    }

    public void remove(Object object) {
        if (object instanceof EObject) {
            EReference reference = ((EObject)object).eContainmentFeature();
            EObject parent = ((EObject)object).eContainer();
            if (reference == null || reference.getUpperBound() != -1) {
                return;
            }
            EList list = (EList)parent.eGet((EStructuralFeature)reference);
            ArrayList<Launch> toRemove = new ArrayList<Launch>();
            if (object instanceof LaunchConfiguration) {
                for (Launch launch : this.content.getLaunches()) {
                    if (!launch.getConfiguration().getName().equals(((LaunchConfiguration)object).getName())) continue;
                    toRemove.add(launch);
                }
            }
            if (object instanceof LaunchType) {
                for (Launch launch : this.content.getLaunches()) {
                    LaunchType type = (LaunchType)launch.getConfiguration().eContainer();
                    if (type != object) continue;
                    toRemove.add(launch);
                }
            }
            this.content.getLaunches().removeAll(toRemove);
            list.remove(object);
        }
        if (object instanceof EList) {
            ((EList)object).clear();
        }
    }

    public void install(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)this);
        TreeColumn treeColumn = new TreeColumn(viewer.getTree(), 16384);
        treeColumn.setText("Attribute");
        treeColumn.setWidth(350);
        TreeViewerColumn viewerColumn = new TreeViewerColumn(viewer, treeColumn);
        viewerColumn.setLabelProvider((CellLabelProvider)this.nameLabelProvider);
        treeColumn = new TreeColumn(viewer.getTree(), 16384);
        treeColumn.setText("Value");
        treeColumn.setWidth(200);
        viewerColumn = new TreeViewerColumn(viewer, treeColumn);
        viewerColumn.setEditingSupport((EditingSupport)new ValueEditing((ColumnViewer)viewer));
        viewerColumn.setLabelProvider((CellLabelProvider)this.valueLabelProvider);
    }

    class AttributeOfEObject
    extends FeatureOfEObject<EAttribute> {
        public AttributeOfEObject(EObject object, EAttribute attribute) {
            super(ContentProvider.this, object, (EStructuralFeature)attribute);
        }

        @Override
        public String getValueLabel() {
            return this.object.eGet(this.attribute).toString();
        }

        public Object getValue() {
            Object value = this.object.eGet(this.attribute);
            Class c = ((EAttribute)this.attribute).getEAttributeType().getInstanceClass();
            if (c == Integer.class) {
                return Integer.toString((Integer)value);
            }
            return value;
        }

        public void setValue(Object value) {
            EDataType c = ((EAttribute)this.attribute).getEAttributeType();
            if (c == EcorePackage.Literals.EINT) {
                value = Integer.parseInt((String)value);
            }
            this.object.eSet(this.attribute, value);
        }

        public CellEditor getCellEditor(Composite composite) {
            EDataType c = ((EAttribute)this.attribute).getEAttributeType();
            if (c == EcorePackage.Literals.EBOOLEAN) {
                return new CheckboxCellEditor(composite);
            }
            if (c == EcorePackage.Literals.ESTRING) {
                return new TextCellEditor(composite, 2);
            }
            return new TextCellEditor(composite);
        }

        @Override
        public Object[] getChildren() {
            return none;
        }

        @Override
        public Image getImage() {
            if (this.object.eGet(this.attribute) instanceof String) {
                return Images.getImage((String)"icons/preferences/pref_data.gif");
            }
            return Images.getImage((String)"icons/ecl/attr.gif");
        }
    }

    static abstract class FeatureOfEObject<T extends EStructuralFeature> {
        final EObject object;
        final T attribute;
        final /* synthetic */ ContentProvider this$0;

        public FeatureOfEObject(EObject object, T attribute) {
            this.this$0 = var1_1;
            this.object = object;
            this.attribute = attribute;
        }

        public int hashCode() {
            return this.object.hashCode() ^ this.attribute.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FeatureOfEObject)) {
                return false;
            }
            FeatureOfEObject that = (FeatureOfEObject)obj;
            return this.object.equals(that.object) && this.attribute.equals(that.attribute);
        }

        public String getName() {
            return this.attribute.getName();
        }

        public abstract String getValueLabel();

        public abstract Object[] getChildren();

        public abstract Image getImage();
    }

    class ReferenceOfEObject
    extends FeatureOfEObject<EReference> {
        public ReferenceOfEObject(EObject object, EReference attribute) {
            super(ContentProvider.this, object, (EStructuralFeature)attribute);
        }

        @Override
        public String getValueLabel() {
            return null;
        }

        @Override
        public Object[] getChildren() {
            if (((EReference)this.attribute).getUpperBound() == -1) {
                return ((EList)this.object.eGet(this.attribute)).toArray();
            }
            return new Object[]{this.object.eGet(this.attribute)};
        }

        @Override
        public Image getImage() {
            return Images.getImage((String)"icons/preferences/pref_node.gif");
        }
    }

    class ValueEditing
    extends EditingSupport {
        public ValueEditing(ColumnViewer viewer) {
            super(viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof PrimitiveValue) {
                EObject value = ((PrimitiveValue)element).getValue();
                if (value instanceof EclString) {
                    return new TextCellEditor((Composite)this.getViewer().getControl());
                }
                if (value instanceof EclInteger) {
                    TextCellEditor rv = new TextCellEditor((Composite)this.getViewer().getControl());
                    rv.setValidator(new ICellEditorValidator(){

                        public String isValid(Object value) {
                            block3: {
                                try {
                                    if (!(value instanceof Integer)) break block3;
                                    return null;
                                }
                                catch (NumberFormatException e) {
                                    return e.getMessage();
                                }
                            }
                            Integer.parseInt((String)value);
                            return null;
                        }
                    });
                    return rv;
                }
                if (value instanceof EclBoolean) {
                    return new CheckboxCellEditor((Composite)this.getViewer().getControl());
                }
            }
            if (element instanceof AttributeOfEObject) {
                return ((AttributeOfEObject)element).getCellEditor((Composite)this.getViewer().getControl());
            }
            return null;
        }

        protected boolean canEdit(Object element) {
            return element instanceof PrimitiveValue || element instanceof AttributeOfEObject;
        }

        protected Object getValue(Object element) {
            if (element instanceof PrimitiveValue) {
                EObject value = ((PrimitiveValue)element).getValue();
                if (value instanceof EclInteger) {
                    return Integer.toString(((EclInteger)value).getValue());
                }
                return BoxedValues.unbox((Object)value);
            }
            if (element instanceof AttributeOfEObject) {
                return ((AttributeOfEObject)element).getValue();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof PrimitiveValue) {
                EObject boxed = ((PrimitiveValue)element).getValue();
                if (boxed instanceof EclInteger) {
                    ((EclInteger)boxed).setValue(Integer.parseInt((String)value));
                } else if (boxed instanceof EclString) {
                    ((EclString)boxed).setValue((String)value);
                } else if (boxed instanceof EclBoolean) {
                    ((EclBoolean)boxed).setValue(((Boolean)value).booleanValue());
                } else assert (false) : "Unknown primitive value type";
            } else if (element instanceof AttributeOfEObject) {
                ((AttributeOfEObject)element).setValue(value);
            }
            this.getViewer().refresh(element);
        }
    }
}

