/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol.raw;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CommandTransferKind implements Enumerator
{
    DEFAULT(0, "Default", "Default"),
    REPLACE_PREVIOUS(1, "ReplacePrevious", "ReplacePrevious"),
    INSERT_BEFORE_ESSENTIAL_COMMAND(2, "InsertBeforeEssentialCommand", "InsertBeforeEssentialCommand"),
    INSERT_BEFORE(3, "InsertBefore", "InsertBefore"),
    REMOVE(4, "Remove", "Remove");

    public static final int DEFAULT_VALUE = 0;
    public static final int REPLACE_PREVIOUS_VALUE = 1;
    public static final int INSERT_BEFORE_ESSENTIAL_COMMAND_VALUE = 2;
    public static final int INSERT_BEFORE_VALUE = 3;
    public static final int REMOVE_VALUE = 4;
    private static final CommandTransferKind[] VALUES_ARRAY;
    public static final List<CommandTransferKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CommandTransferKind[]{DEFAULT, REPLACE_PREVIOUS, INSERT_BEFORE_ESSENTIAL_COMMAND, INSERT_BEFORE, REMOVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CommandTransferKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CommandTransferKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CommandTransferKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CommandTransferKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CommandTransferKind get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return REPLACE_PREVIOUS;
            }
            case 2: {
                return INSERT_BEFORE_ESSENTIAL_COMMAND;
            }
            case 3: {
                return INSERT_BEFORE;
            }
            case 4: {
                return REMOVE;
            }
        }
        return null;
    }

    private CommandTransferKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

