/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditorActionBarContributor;
import org.eclipse.egit.ui.internal.commit.CommitEditorInput;
import org.eclipse.egit.ui.internal.commit.CommitEditorPage;
import org.eclipse.egit.ui.internal.commit.DiffEditorPage;
import org.eclipse.egit.ui.internal.commit.FocusManagerFormPart;
import org.eclipse.egit.ui.internal.commit.FocusTracker;
import org.eclipse.egit.ui.internal.commit.HeaderText;
import org.eclipse.egit.ui.internal.commit.MultiPageEditorContentOutlinePage;
import org.eclipse.egit.ui.internal.commit.NotesEditorPage;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.commit.StashEditorPage;
import org.eclipse.egit.ui.internal.repository.RepositoriesView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CommitEditor
extends SharedHeaderFormEditor
implements RefsChangedListener,
IShowInSource,
IShowInTargetList {
    public static final String ID = "org.eclipse.egit.ui.commitEditor";
    private static final String TOOLBAR_HEADER_ID = "org.eclipse.egit.ui.commitEditor.header.toolbar";
    private IContentOutlinePage outlinePage;
    private CommitEditorPage commitPage;
    private DiffEditorPage diffPage;
    private NotesEditorPage notePage;
    private ListenerHandle refListenerHandle;
    private FocusTracker headerFocusTracker = new FocusTracker();
    private IToolBarManager toolbar;
    private final IPartListener activationListener = new IPartListener(){
        private boolean isActive;

        public void partActivated(IWorkbenchPart part) {
            if (part == CommitEditor.this) {
                if (!this.isActive) {
                    this.isActive = true;
                    CommitEditor.this.updateToolbar();
                }
            } else if (this.isActive) {
                this.isActive = false;
                CommitEditor.this.updateToolbar();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    public static final IEditorPart open(RepositoryCommit commit) throws PartInitException {
        return CommitEditor.open(commit, true);
    }

    public static final IEditorPart open(RepositoryCommit commit, boolean activateOnOpen) throws PartInitException {
        CommitEditorInput input = new CommitEditorInput(commit);
        return IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)ID, (boolean)activateOnOpen);
    }

    public static final IEditorPart openQuiet(RepositoryCommit commit, boolean activateOnOpen) {
        try {
            return CommitEditor.open(commit, activateOnOpen);
        }
        catch (PartInitException e) {
            Activator.logError(e.getMessage(), e);
            return null;
        }
    }

    public static final IEditorPart openQuiet(RepositoryCommit commit) {
        return CommitEditor.openQuiet(commit, true);
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new CommitEditorNestedSite(this, editor);
    }

    protected void addPages() {
        try {
            this.commitPage = this.getCommit().isStash() ? new StashEditorPage((FormEditor)this) : new CommitEditorPage((FormEditor)this);
            this.addPage((IFormPage)this.commitPage);
            this.diffPage = new DiffEditorPage((FormEditor)this);
            this.addPage((IEditorPart)this.diffPage, this.getEditorInput());
            if (this.getCommit().getNotes().length > 0) {
                this.notePage = new NotesEditorPage((FormEditor)this);
                this.addPage((IFormPage)this.notePage);
            }
        }
        catch (PartInitException e) {
            Activator.error("Error adding page", e);
        }
        this.refListenerHandle = Repository.getGlobalListenerList().addRefsChangedListener((RefsChangedListener)this);
    }

    private IContributionItem createActionContributionItem(final String commandId, String title, ImageDescriptor icon) {
        Action action = new Action(title, icon){

            public void run() {
                CommonUtils.runCommand(commandId, (IStructuredSelection)new StructuredSelection((Object)CommitEditor.this.getCommit()));
            }
        };
        return new ActionContributionItem((IAction)action);
    }

    protected void createHeaderContents(final IManagedForm headerForm) {
        ToolBar control;
        headerForm.addPart((IFormPart)new FocusManagerFormPart(this.headerFocusTracker){

            @Override
            public void setDefaultFocus() {
                headerForm.getForm().getForm().setFocus();
            }
        });
        RepositoryCommit commit = this.getCommit();
        ScrolledForm form = headerForm.getForm();
        String commitName = commit.getRevCommit().name();
        String title = this.getFormattedHeaderTitle(commitName);
        HeaderText text = new HeaderText(form.getForm(), title, commitName);
        Control textControl = text.getControl();
        if (textControl != null) {
            this.headerFocusTracker.addToFocusTracking(textControl);
        }
        form.setToolTipText(commitName);
        this.getToolkit().decorateFormHeading(form.getForm());
        this.toolbar = form.getToolBarManager();
        ControlContribution repositoryLabelControl = new ControlContribution("repositoryLabel"){

            protected Control createControl(Composite parent) {
                FormToolkit toolkit = CommitEditor.this.getHeaderForm().getToolkit();
                String label = CommitEditor.this.getCommit().getRepositoryName();
                ImageHyperlink link = new ImageHyperlink(parent, 0);
                CommitEditor.this.headerFocusTracker.addToFocusTracking((Control)link);
                link.setText(label);
                link.setFont(JFaceResources.getBannerFont());
                link.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                link.setToolTipText(UIText.CommitEditor_showGitRepo);
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent event) {
                        try {
                            RepositoriesView view = (RepositoriesView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.RepositoriesView");
                            view.showRepository(CommitEditor.this.getCommit().getRepository());
                        }
                        catch (PartInitException e) {
                            Activator.handleError(UIText.CommitEditor_couldNotShowRepository, e, false);
                        }
                    }
                });
                return link;
            }
        };
        this.toolbar.add((IContributionItem)repositoryLabelControl);
        CommonUtils.getService((IServiceLocator)this.getSite(), IPartService.class).addPartListener(this.activationListener);
        if (commit.isStash()) {
            this.toolbar.add(this.createActionContributionItem("org.eclipse.egit.ui.commit.StashApply", UIText.CommitEditor_toolbarApplyStash, UIIcons.STASH_APPLY));
            this.toolbar.add(this.createActionContributionItem("org.eclipse.egit.ui.commit.StashDrop", UIText.CommitEditor_toolbarDeleteStash, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE")));
        } else {
            this.toolbar.add(this.createActionContributionItem("org.eclipse.egit.ui.commit.CreateTag", UIText.CommitEditor_toolbarCreateTag, UIIcons.TAG));
            this.toolbar.add(this.createActionContributionItem("org.eclipse.egit.ui.commit.CreateBranch", UIText.CommitEditor_toolbarCreateBranch, UIIcons.BRANCH));
            this.toolbar.add(this.createActionContributionItem("org.eclipse.egit.ui.commit.Checkout", UIText.CommitEditor_toolbarCheckOut, UIIcons.CHECKOUT));
            this.toolbar.add(this.createActionContributionItem("org.eclipse.egit.ui.commit.CherryPick", UIText.CommitEditor_toolbarCherryPick, UIIcons.CHERRY_PICK));
            this.toolbar.add(this.createActionContributionItem("org.eclipse.egit.ui.commit.Revert", UIText.CommitEditor_toolbarRevert, UIIcons.REVERT));
            this.toolbar.add(this.createActionContributionItem("org.eclipse.egit.ui.commit.ShowInHistory", UIText.CommitEditor_toolbarShowInHistory, UIIcons.HISTORY));
        }
        this.addContributions(this.toolbar);
        this.toolbar.update(true);
        this.getSite().setSelectionProvider(new ISelectionProvider(){

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return new StructuredSelection((Object)CommitEditor.this.getCommit());
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        });
        if (this.toolbar instanceof ToolBarManager && (control = ((ToolBarManager)this.toolbar).getControl()) != null) {
            this.headerFocusTracker.addToFocusTracking((Control)control);
        }
    }

    private void updateToolbar() {
        if (this.toolbar != null) {
            IContributionItem[] iContributionItemArray = this.toolbar.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                item.isEnabled();
                ++n2;
            }
            this.toolbar.update(true);
        }
    }

    private String getFormattedHeaderTitle(String commitName) {
        if (this.getCommit().isStash()) {
            int stashIndex = this.getStashIndex(this.getCommit().getRepository(), this.getCommit().getRevCommit().getId());
            String stashName = MessageFormat.format("stash@'{'{0}'}'", stashIndex);
            return MessageFormat.format(UIText.CommitEditor_TitleHeaderStashedCommit, stashName);
        }
        return MessageFormat.format(UIText.CommitEditor_TitleHeaderCommit, commitName);
    }

    private int getStashIndex(Repository repo, ObjectId id) {
        int index = 0;
        try {
            for (RevCommit commit : Git.wrap((Repository)repo).stashList().call()) {
                if (commit.getId().equals((AnyObjectId)id)) {
                    return index;
                }
                ++index;
            }
            throw new IllegalStateException(UIText.CommitEditor_couldNotFindStashCommit);
        }
        catch (Exception e) {
            String message = MessageFormat.format(UIText.CommitEditor_couldNotGetStashIndex, id.name());
            Activator.logError(message, e);
            index = -1;
            return index;
        }
    }

    private void addContributions(IToolBarManager toolBarManager) {
        IMenuService menuService = CommonUtils.getService((IServiceLocator)this.getSite(), IMenuService.class);
        if (menuService != null && toolBarManager instanceof ContributionManager) {
            ContributionManager contributionManager = (ContributionManager)toolBarManager;
            String toolbarUri = "toolbar:org.eclipse.egit.ui.commitEditor.header.toolbar";
            menuService.populateContributionManager(contributionManager, toolbarUri);
        }
    }

    private RepositoryCommit getCommit() {
        return (RepositoryCommit)((Object)this.getAdapter(RepositoryCommit.class));
    }

    public Object getAdapter(Class adapter) {
        if (RepositoryCommit.class == adapter) {
            return AdapterUtils.adapt((Object)this.getEditorInput(), RepositoryCommit.class);
        }
        if (IContentOutlinePage.class == adapter) {
            return this.getOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (AdapterUtils.adapt((Object)input, RepositoryCommit.class) == null) {
            throw new PartInitException("Input could not be adapted to commit object");
        }
        super.init(site, input);
        this.setPartName(input.getName());
        this.setTitleToolTip(input.getToolTipText());
    }

    public void dispose() {
        CommonUtils.getService((IServiceLocator)this.getSite(), IPartService.class).removePartListener(this.activationListener);
        this.refListenerHandle.remove();
        this.headerFocusTracker.dispose();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void onRefsChanged(RefsChangedEvent event) {
        if (this.getCommit().getRepository().getDirectory().equals(event.getRepository().getDirectory())) {
            UIJob job = new UIJob("Refreshing editor"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!CommitEditor.this.getContainer().isDisposed()) {
                        CommitEditor.this.commitPage.refresh();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    private IContentOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new MultiPageEditorContentOutlinePage((MultiPageEditorPart)this);
        }
        return this.outlinePage;
    }

    public ShowInContext getShowInContext() {
        IFormPage currentPage = this.getActivePageInstance();
        IShowInSource showInSource = (IShowInSource)AdapterUtils.adapt((Object)currentPage, IShowInSource.class);
        if (showInSource != null) {
            return showInSource.getShowInContext();
        }
        return null;
    }

    public String[] getShowInTargetIds() {
        IFormPage currentPage = this.getActivePageInstance();
        IShowInTargetList targetList = (IShowInTargetList)AdapterUtils.adapt((Object)currentPage, IShowInTargetList.class);
        if (targetList != null) {
            return targetList.getShowInTargetIds();
        }
        return null;
    }

    private static class CommitEditorNestedSite
    extends MultiPageEditorSite {
        public CommitEditorNestedSite(CommitEditor topLevelEditor, IEditorPart nestedEditor) {
            super((MultiPageEditorPart)topLevelEditor, nestedEditor);
        }

        public IEditorActionBarContributor getActionBarContributor() {
            IEditorActionBarContributor globalContributor = this.getMultiPageEditor().getEditorSite().getActionBarContributor();
            if (globalContributor instanceof CommitEditorActionBarContributor) {
                return ((CommitEditorActionBarContributor)globalContributor).getTextEditorActionContributor();
            }
            return super.getActionBarContributor();
        }
    }
}

