/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.build.BaseBuildAction;

public class GenerateFeatureBuildFileAction
extends BaseBuildAction {
    private IFeatureModel fFeatureModel;

    @Override
    protected void makeScripts(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        IFeatureModel[] models;
        IFeatureModel[] iFeatureModelArray = models = PDECore.getDefault().getFeatureModelManager().getModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IResource underlying;
            IFeatureModel model = iFeatureModelArray[n2];
            if (model.getUnderlyingResource() != null && ((underlying = model.getUnderlyingResource()).equals((Object)this.fManifestFile) || underlying.getProject().equals((Object)this.fManifestFile.getProject()))) {
                this.fFeatureModel = model;
            }
            ++n2;
        }
        BuildScriptGenerator generator = new BuildScriptGenerator();
        generator.setChildren(true);
        AbstractScriptGenerator.setEmbeddedSource((boolean)AbstractScriptGenerator.getDefaultEmbeddedSource());
        String url = ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(this.fManifestFile.getProject().getLocation().addTrailingSeparator().toString()) + "dev.properties"), (boolean)false);
        generator.setDevEntries(url);
        generator.setWorkingDirectory(this.fManifestFile.getProject().getLocation().toOSString());
        String configInfo = String.valueOf(TargetPlatform.getOS()) + ", " + TargetPlatform.getWS() + ", " + TargetPlatform.getOSArch();
        AbstractScriptGenerator.setConfigInfo((String)configInfo);
        generator.setArchivesFormat(String.valueOf(AbstractScriptGenerator.getDefaultConfigInfos()) + '-' + "antZip");
        generator.setElements(new String[]{"feature@" + this.fFeatureModel.getFeature().getId() + (this.fFeatureModel.getFeature().getVersion() == null ? "" : ":" + this.fFeatureModel.getFeature().getVersion())});
        generator.setPluginPath(TargetPlatformHelper.getFeaturePaths());
        generator.setPDEState(TargetPlatformHelper.getState());
        generator.setNextId(TargetPlatformHelper.getPDEState().getNextId());
        generator.setStateExtraData(TargetPlatformHelper.getBundleClasspaths((PDEState)TargetPlatformHelper.getPDEState()), TargetPlatformHelper.getPatchMap((PDEState)TargetPlatformHelper.getPDEState()));
        generator.setGenerateAssembleScript(false);
        generator.generate();
    }

    private void refreshLocal(IFeature feature, IProgressMonitor monitor) throws CoreException {
        IFeatureChild[] included;
        IFeaturePlugin[] references;
        IFeaturePlugin[] iFeaturePluginArray = references = feature.getPlugins();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            IFeaturePlugin reference = iFeaturePluginArray[n2];
            IPluginModelBase refmodel = feature.getReferencedModel(reference);
            if (refmodel != null && (resource = refmodel.getUnderlyingResource()) != null) {
                resource.getProject().refreshLocal(1, monitor);
            }
            ++n2;
        }
        IFeatureChild[] iFeatureChildArray = included = feature.getIncludedFeatures();
        int n3 = included.length;
        n = 0;
        while (n < n3) {
            IFeatureChild element = iFeatureChildArray[n];
            IFeature child = ((FeatureChild)element).getReferencedFeature();
            if (child != null && child != this.fFeatureModel.getFeature()) {
                IFeatureModel refmodel = child.getModel();
                if (refmodel != null && refmodel.getUnderlyingResource() != null) {
                    refmodel.getUnderlyingResource().getProject().refreshLocal(1, monitor);
                }
                this.refreshLocal(child, monitor);
            }
            ++n;
        }
    }

    @Override
    protected void refreshLocal(IProgressMonitor monitor) throws CoreException {
        super.refreshLocal(monitor);
        this.refreshLocal(this.fFeatureModel.getFeature(), monitor);
    }
}

