/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.util;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.ImageEntry;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.reporting.core.SimpleSeverity;
import org.eclipse.rcptt.reporting.util.RcpttReportGenerator;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;

public final class ReportEntry {
    public final String name;
    public final String id;
    public final int time;
    private final int status;
    public final String message;

    private ReportEntry(String name, String id, int time, int status, String message) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)time);
        Preconditions.checkNotNull((Object)status);
        Preconditions.checkNotNull((Object)message);
        this.message = message;
        this.name = name;
        this.id = id;
        this.time = time;
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public SimpleSeverity getSimpleSeverity() {
        return SimpleSeverity.create((int)this.status);
    }

    public int getStatusSeverity() {
        return this.status;
    }

    public static ReportEntry create(Report next) {
        Node root = next.getRoot();
        Q7Info info = ReportHelper.getInfo((Node)root);
        StringWriter writer = new StringWriter();
        new RcpttReportGenerator(new PrintWriter(writer), new ArrayList<ImageEntry>()).writeResult(0, info.getResult());
        ReportEntry entry = new ReportEntry(root.getName(), info.getId(), (int)root.getDuration(), info.getResult().getSeverity(), writer.toString());
        return entry;
    }
}

