/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.ui.viewer.IStyledLabelDecorator;
import org.eclipse.emf.common.ui.viewer.IUndecoratingLabelProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticDecorator
extends CellLabelProvider
implements ILabelDecorator {
    private static final Pattern ENQUOTED_SEGMENT_PATTERN = Pattern.compile("\u0002<img src='[^']*'/> (?:<i>)?([^\u0003]*)(?:</i>)?\u0003");
    private static final Map<EditingDomain, LiveValidator> LIVE_VALIDATORS = new HashMap<EditingDomain, LiveValidator>();
    protected DiagnosticAdapter diagnosticAdapter;
    protected EditingDomain editingDomain;
    protected LiveValidator liveValidator;
    protected ResourceSet resourceSet;
    protected StructuredViewer viewer;
    protected ExtendedPropertySheetPage propertySheetPage;
    protected IDialogSettings dialogSettings;
    protected Map<Object, BasicDiagnostic> decorations = new HashMap<Object, BasicDiagnostic>();
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected Object input;
    protected IContentProvider contentProvider;
    protected List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    public static String escapeContent(String content) {
        StringBuilder result = new StringBuilder();
        boolean escape = true;
        int i = 0;
        int length = content.length();
        while (i < length) {
            char character = content.charAt(i);
            if (escape) {
                switch (character) {
                    case '\u0002': {
                        escape = false;
                        break;
                    }
                    case '\u0003': {
                        escape = true;
                        break;
                    }
                    case ' ': {
                        result.append("&#160;");
                        break;
                    }
                    case '&': {
                        result.append("&amp;");
                        break;
                    }
                    case '<': {
                        result.append("&lt;");
                        break;
                    }
                    default: {
                        result.append(character);
                        break;
                    }
                }
            } else {
                result.append(character);
            }
            ++i;
        }
        return result.toString();
    }

    public static String enquote(String content) {
        return String.valueOf('\u0002') + content + '\u0003';
    }

    public static String strip(String content) {
        Matcher matcher = ENQUOTED_SEGMENT_PATTERN.matcher(content);
        if (matcher.find()) {
            StringBuilder result = new StringBuilder();
            int start = 0;
            do {
                result.append(content.substring(start, matcher.start()));
                String label = matcher.group(1);
                result.append(label.replace("&lt;", "<").replace("&amp;", "&"));
                start = matcher.end();
            } while (matcher.find());
            result.append(content.substring(start));
            return result.toString();
        }
        return content;
    }

    public DiagnosticDecorator(ResourceSet resourceSet, StructuredViewer viewer) {
        this.viewer = viewer;
        this.resourceSet = resourceSet;
        this.diagnosticAdapter = new DiagnosticDecoratorAdapter();
        resourceSet.eAdapters().add((Object)this.diagnosticAdapter);
        this.input = viewer.getInput();
        this.contentProvider = viewer.getContentProvider();
    }

    public DiagnosticDecorator(EditingDomain editingDomain, StructuredViewer viewer) {
        this(editingDomain, viewer, null);
    }

    public DiagnosticDecorator(EditingDomain editingDomain, StructuredViewer viewer, IDialogSettings dialogSettings) {
        this.editingDomain = editingDomain;
        this.resourceSet = editingDomain.getResourceSet();
        this.viewer = viewer;
        this.dialogSettings = dialogSettings;
        this.diagnosticAdapter = new DiagnosticDecoratorAdapter();
        this.resourceSet.eAdapters().add((Object)this.diagnosticAdapter);
        this.input = viewer.getInput();
        this.contentProvider = viewer.getContentProvider();
    }

    public DiagnosticDecorator(ResourceSet resourceSet, ExtendedPropertySheetPage propertySheetPage) {
        this.resourceSet = resourceSet;
        this.propertySheetPage = propertySheetPage;
        this.diagnosticAdapter = new DiagnosticDecoratorAdapter();
        resourceSet.eAdapters().add((Object)this.diagnosticAdapter);
        this.input = propertySheetPage.getInput();
    }

    public DiagnosticDecorator(EditingDomain editingDomain, ExtendedPropertySheetPage propertySheetPage) {
        this(editingDomain, propertySheetPage, null);
    }

    public DiagnosticDecorator(EditingDomain editingDomain, ExtendedPropertySheetPage propertySheetPage, IDialogSettings dialogSettings) {
        this.editingDomain = editingDomain;
        this.resourceSet = editingDomain.getResourceSet();
        this.propertySheetPage = propertySheetPage;
        this.dialogSettings = dialogSettings;
        this.diagnosticAdapter = new DiagnosticDecoratorAdapter();
        this.resourceSet.eAdapters().add((Object)this.diagnosticAdapter);
        this.input = propertySheetPage.getInput();
    }

    public static void cancel(EditingDomain editingDomain) {
        LiveValidator liveValidator = LIVE_VALIDATORS.get(editingDomain);
        if (liveValidator != null) {
            liveValidator.cancelValidation();
        }
    }

    protected LiveValidator getLiveValidator() {
        if (this.liveValidator == null && this.editingDomain != null) {
            this.liveValidator = LIVE_VALIDATORS.get(this.editingDomain);
            if (this.liveValidator == null) {
                this.liveValidator = new LiveValidator(this.editingDomain, this.dialogSettings);
                LIVE_VALIDATORS.put(this.editingDomain, this.liveValidator);
            }
            this.liveValidator.register(this);
        }
        return this.liveValidator;
    }

    public String decorateText(String text, Object object) {
        return text;
    }

    public Image decorateImage(Image image, Object object) {
        Diagnostic diagnostic = this.getDecorations().get(object);
        if (diagnostic != null && diagnostic.getSeverity() >= 2) {
            return this.decorate(image, diagnostic);
        }
        return image;
    }

    public Image decorate(Image image, Diagnostic diagnostic) {
        if (image == null) {
            return ExtendedImageRegistry.INSTANCE.getImage(EMFEditUIPlugin.INSTANCE.getImage(diagnostic.getSeverity() == 2 ? "full/ovr16/warning_ovr.gif" : "full/ovr16/error_ovr.gif"));
        }
        ArrayList<Object> images = new ArrayList<Object>(2);
        images.add(image);
        images.add(EMFEditUIPlugin.INSTANCE.getImage(diagnostic.getSeverity() == 2 ? "full/ovr16/warning_ovr.gif" : "full/ovr16/error_ovr.gif"));
        DecoratedComposedImage composedImage = new DecoratedComposedImage(images);
        return ExtendedImageRegistry.INSTANCE.getImage((Object)composedImage);
    }

    public Map<Object, ? extends Diagnostic> getDecorations() {
        if (this.propertySheetPage != null) {
            List<?> input = this.propertySheetPage.getInput();
            if (!input.equals(this.input)) {
                this.redecorate();
            }
            this.input = input;
        } else {
            Object input = this.viewer.getInput();
            IContentProvider contentProvider = this.viewer.getContentProvider();
            if (input != null && !input.equals(this.input) || contentProvider != null && !contentProvider.equals(this.contentProvider)) {
                this.redecorate();
            }
            this.input = input;
            this.contentProvider = contentProvider;
        }
        return this.decorations;
    }

    protected void updateDiagnotics(List<Diagnostic> diagnostics, Diagnostic diagnostic) {
        String source;
        String markerSource = this.markerHelper.getDiagnosticSource();
        if (markerSource.equals(source = diagnostic.getSource())) {
            Iterator<Diagnostic> i = diagnostics.iterator();
            while (i.hasNext()) {
                Diagnostic oldDiagnostic = i.next();
                if (!markerSource.equals(oldDiagnostic.getSource()) || !diagnostic.getData().equals(oldDiagnostic.getData())) continue;
                i.remove();
            }
            diagnostics.add(diagnostic);
        } else {
            Object object = diagnostic.getData().get(0);
            if (object instanceof ResourceSet) {
                for (Diagnostic child : diagnostic.getChildren()) {
                    this.updateDiagnotics(diagnostics, child);
                }
            } else {
                Iterator<Diagnostic> i = diagnostics.iterator();
                while (i.hasNext()) {
                    Diagnostic oldDiagnostic = i.next();
                    String oldSource = oldDiagnostic.getSource();
                    if (!source.equals(oldSource) && !markerSource.equals(oldSource) || !diagnostic.getData().equals(oldDiagnostic.getData())) continue;
                    i.remove();
                }
                diagnostics.add(diagnostic);
            }
        }
    }

    protected void handleDiagnostic(Diagnostic rootDiagnostic) {
        this.updateDiagnotics(this.diagnostics, rootDiagnostic);
        this.redecorate();
    }

    protected void redecorate() {
        if (this.propertySheetPage != null ? this.propertySheetPage.getInput() != null : this.viewer.getInput() != null && this.viewer.getContentProvider() != null) {
            HashMap<Object, BasicDiagnostic> objects = new HashMap<Object, BasicDiagnostic>();
            for (Diagnostic diagnostic : this.diagnostics) {
                for (Diagnostic diagnostic2 : diagnostic.getChildren()) {
                    List data = diagnostic2.getData();
                    if (data.isEmpty()) continue;
                    this.decorate(objects, data.get(0), diagnostic2, null);
                }
            }
            Map<Object, BasicDiagnostic> oldDecorations = this.decorations;
            this.decorations = new HashMap<Object, BasicDiagnostic>();
            this.decorate(objects);
            if (this.propertySheetPage != null) {
                Control control;
                if (!(this.decorations.isEmpty() && oldDecorations.isEmpty() || (control = this.propertySheetPage.getControl()) == null || control.isDisposed())) {
                    control.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!control.isDisposed()) {
                                DiagnosticDecorator.this.propertySheetPage.refreshLabels();
                            }
                        }
                    });
                }
            } else {
                final HashSet<Object> objectsToRefresh = new HashSet<Object>();
                for (Map.Entry entry : this.decorations.entrySet()) {
                    Object decoratedObject = entry.getKey();
                    BasicDiagnostic oldDiagnostic = oldDecorations.get(decoratedObject);
                    if (oldDiagnostic == null || ((BasicDiagnostic)entry.getValue()).getSeverity() != oldDiagnostic.getSeverity()) {
                        objectsToRefresh.add(decoratedObject);
                    }
                    if (oldDiagnostic == null) continue;
                    oldDecorations.remove(decoratedObject);
                }
                objectsToRefresh.addAll(oldDecorations.keySet());
                if (!objectsToRefresh.isEmpty()) {
                    if (!(this.viewer instanceof ColumnViewer) || !((ColumnViewer)this.viewer).isBusy()) {
                        this.viewer.update(objectsToRefresh.toArray(), null);
                    } else {
                        final Control control = this.viewer.getControl();
                        if (!control.isDisposed()) {
                            control.getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    if (!control.isDisposed()) {
                                        DiagnosticDecorator.this.viewer.update(objectsToRefresh.toArray(), null);
                                    }
                                }
                            });
                        }
                    }
                }
            }
        }
    }

    protected BasicDiagnostic decorate(Map<Object, BasicDiagnostic> decorations, Object object, Diagnostic diagnostic, List<Integer> path) {
        BasicDiagnostic oldDiagnostic = decorations.get(object);
        if (diagnostic != null) {
            String message;
            if (oldDiagnostic == null) {
                Object[] objectArray;
                if (path == null) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = object;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = object;
                    objectArray = objectArray3;
                    objectArray3[1] = path.toArray(new Integer[path.size()]);
                }
                oldDiagnostic = new BasicDiagnostic(null, 0, null, objectArray);
                decorations.put(object, oldDiagnostic);
            }
            if ((message = diagnostic.getMessage()) != null) {
                List data = diagnostic.getData();
                for (Diagnostic childDiagnostic : oldDiagnostic.getChildren()) {
                    if (!childDiagnostic.getMessage().equals(message) || !data.equals(childDiagnostic.getData())) continue;
                    return oldDiagnostic;
                }
            }
            oldDiagnostic.add(diagnostic);
        }
        return oldDiagnostic;
    }

    protected void decorate(Map<Object, BasicDiagnostic> objects) {
        block6: {
            block5: {
                if (this.propertySheetPage == null) break block5;
                for (Object object : this.propertySheetPage.getInput()) {
                    this.decorate(this.decorations, object, (Diagnostic)objects.get(object), null);
                    if (!(object instanceof EObject)) continue;
                    EObject eObject = (EObject)object;
                    for (EObject child : eObject.eContents()) {
                        this.decorate(this.decorations, child, (Diagnostic)objects.get(child), null);
                    }
                    for (EObject child : eObject.eCrossReferences()) {
                        this.decorate(this.decorations, child, (Diagnostic)objects.get(child), null);
                    }
                }
                break block6;
            }
            Object input = this.viewer.getInput();
            IContentProvider contentProvider = this.viewer.getContentProvider();
            if (!(contentProvider instanceof IStructuredContentProvider)) break block6;
            ITreeContentProvider treeContentProvider = contentProvider instanceof ITreeContentProvider ? (ITreeContentProvider)contentProvider : null;
            int index = 0;
            ArrayList<Integer> path = new ArrayList<Integer>();
            path.add(-1);
            Object[] objectArray = ((IStructuredContentProvider)contentProvider).getElements(input);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                path.set(0, index++);
                BasicDiagnostic childDiagnostic = this.getDiagnostic(objects, object, path);
                BasicDiagnostic objectDiagnostic = this.decorate(this.decorations, object, (Diagnostic)childDiagnostic, path);
                if (treeContentProvider != null) {
                    HashSet<Object> visited = new HashSet<Object>();
                    objectDiagnostic = this.decorate(objects, treeContentProvider, visited, object, path);
                }
                this.decorate(this.decorations, input, (Diagnostic)objectDiagnostic, null);
                ++n2;
            }
        }
    }

    protected BasicDiagnostic getDiagnostic(Map<Object, BasicDiagnostic> objects, Object object, List<Integer> path) {
        Object unwrappedChild;
        BasicDiagnostic childDiagnostic = objects.get(object);
        if (childDiagnostic == null && object != (unwrappedChild = AdapterFactoryEditingDomain.unwrap((Object)object)) && (childDiagnostic = objects.get(unwrappedChild)) != null) {
            childDiagnostic = new BasicDiagnostic(childDiagnostic.getSource(), childDiagnostic.getCode(), childDiagnostic.getChildren(), childDiagnostic.getMessage(), new Object[]{object, path.toArray(new Integer[path.size()])});
            objects.put(object, childDiagnostic);
        }
        return childDiagnostic;
    }

    protected BasicDiagnostic decorate(Map<Object, BasicDiagnostic> objects, ITreeContentProvider treeContentProvider, Set<Object> visited, Object object, List<Integer> path) {
        BasicDiagnostic result = this.decorations.get(object);
        if (visited.add(object)) {
            int index = 0;
            int last = path.size();
            Object[] objectArray = treeContentProvider.getChildren(object);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                path.add(index++);
                BasicDiagnostic childDiagnostic = this.getDiagnostic(objects, child, path);
                BasicDiagnostic childResult = this.decorate(this.decorations, child, (Diagnostic)childDiagnostic, path);
                childResult = this.decorate(objects, treeContentProvider, visited, child, path);
                path.remove(last);
                result = this.decorate(this.decorations, object, (Diagnostic)childResult, path);
                ++n2;
            }
        }
        return result;
    }

    public String getToolTipText(Object object) {
        BasicDiagnostic diagnostic = this.decorations.get(object);
        if (diagnostic != null) {
            ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider();
            if (labelProvider instanceof IUndecoratingLabelProvider) {
                final IUndecoratingLabelProvider undecoratingLabelProvider = (IUndecoratingLabelProvider)labelProvider;
                labelProvider = new ILabelProvider(){

                    public void removeListener(ILabelProviderListener listener) {
                        undecoratingLabelProvider.removeListener(listener);
                    }

                    public boolean isLabelProperty(Object element, String property) {
                        return undecoratingLabelProvider.isLabelProperty(element, property);
                    }

                    public void dispose() {
                        undecoratingLabelProvider.dispose();
                    }

                    public void addListener(ILabelProviderListener listener) {
                        undecoratingLabelProvider.addListener(listener);
                    }

                    public String getText(Object element) {
                        return undecoratingLabelProvider.getUndecoratedText(element);
                    }

                    public Image getImage(Object element) {
                        return undecoratingLabelProvider.getUndecoratedImage(element);
                    }
                };
            }
            StringBuilder result = new StringBuilder();
            this.buildToolTipText(result, labelProvider, (Diagnostic)diagnostic, object);
            return result.length() == 0 ? null : result.toString();
        }
        return null;
    }

    protected void buildToolTipText(StringBuilder result, ILabelProvider labelProvider, Diagnostic diagnostic, Object object) {
        List children = diagnostic.getChildren();
        Diagnostic child = (Diagnostic)children.get(0);
        int index = 0;
        if (child.getData().contains(object)) {
            ++index;
            for (Diagnostic grandChild : child.getChildren()) {
                this.buildToolTipMessage(result, labelProvider, object, grandChild, 0);
            }
        }
        StringBuilder moreResults = new StringBuilder();
        int size = children.size();
        while (index < size) {
            child = (Diagnostic)children.get(index);
            this.buildMoreToolTipText(moreResults, labelProvider, child);
            ++index;
        }
        if (moreResults.length() != 0) {
            result.append("<h1>Problems on Children</h1>\n");
            result.append((CharSequence)moreResults);
        }
    }

    protected void buildToolTipMessage(StringBuilder result, ILabelProvider labelProvider, Object object, Diagnostic diagnostic, int indentation) {
        String message = diagnostic.getMessage();
        ImageDescriptor imageDescriptor = ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage(diagnostic.getSeverity() == 2 ? "full/ovr16/warning_ovr.gif" : "full/ovr16/error_ovr.gif"));
        URI severityURI = ImageURIRegistry.INSTANCE.getImageURI(imageDescriptor);
        result.append("<div style='white-space: nowrap;'>");
        int i = 0;
        while (i < indentation) {
            result.append("&#160;&#160;&#160;");
            ++i;
        }
        result.append("<img src='");
        result.append(severityURI);
        result.append("'/> ");
        result.append(DiagnosticDecorator.escapeContent(message));
        result.append("</div>\n");
        EList excludedObjects = object instanceof EObject ? ((EObject)object).eClass().getEAllStructuralFeatures() : Collections.emptyList();
        for (Object data : diagnostic.getData()) {
            EObject eObject;
            if (data == object || excludedObjects.contains(data) || !(data instanceof EObject) || (eObject = (EObject)data).eResource() == null || eObject.eResource().getResourceSet() != this.resourceSet) continue;
            result.append("<div style='white-space: nowrap;'>");
            int i2 = 0;
            while (i2 <= indentation) {
                result.append("&#160;&#160;&#160;");
                ++i2;
            }
            String text = DiagnosticDecorator.escapeContent(labelProvider.getText(data));
            Image image = labelProvider.getImage(data);
            result.append("<img src='");
            result.append(ImageURIRegistry.INSTANCE.getImageURI(image));
            result.append("'/> <a href=\"");
            result.append(EcoreUtil.getURI((EObject)((EObject)data)));
            result.append("\">");
            result.append(text);
            result.append("</a></div>\n");
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            this.buildToolTipMessage(result, labelProvider, child.getData().get(0), child, indentation + 1);
        }
    }

    protected void buildMoreToolTipText(StringBuilder result, ILabelProvider labelProvider, Diagnostic diagnostic) {
        List data = diagnostic.getData();
        Object object = data.get(0);
        List children = diagnostic.getChildren();
        Diagnostic child = (Diagnostic)children.get(0);
        int index = 0;
        if (child.getData().contains(object)) {
            ++index;
            if (data.size() > 1) {
                Integer[] path;
                result.append("<div style='white-space: nowrap;'>");
                result.append("<div>");
                Image image = labelProvider.getImage(object);
                if (image != null) {
                    URI imageURI = ImageURIRegistry.INSTANCE.getImageURI(image);
                    result.append("<img src='");
                    result.append(imageURI);
                    result.append("'/> ");
                }
                result.append("<a href='");
                result.append("path:");
                Integer[] integerArray = path = (Integer[])data.get(1);
                int n = path.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer segment = integerArray[n2];
                    result.append('/');
                    result.append(segment);
                    ++n2;
                }
                String text = DiagnosticDecorator.escapeContent(labelProvider.getText(object));
                if (text == null || text.length() == 0) {
                    text = "<i>null</i>";
                }
                result.append("'>");
                result.append(text);
                result.append("</a></div>\n");
                for (Diagnostic grandChild : child.getChildren()) {
                    this.buildToolTipMessage(result, labelProvider, object, grandChild, 1);
                }
            }
        }
        int size = children.size();
        while (index < size) {
            child = (Diagnostic)children.get(index);
            this.buildMoreToolTipText(result, labelProvider, child);
            ++index;
        }
    }

    public void update(ViewerCell cell) {
    }

    public void dispose() {
        if (this.liveValidator != null) {
            this.liveValidator.deregister(this);
        }
        if (this.diagnosticAdapter != null) {
            this.resourceSet.eAdapters().remove((Object)this.diagnosticAdapter);
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DecoratedComposedImage
    extends ComposedImage {
        private DecoratedComposedImage(Collection<?> images) {
            super(images);
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            ArrayList<ComposedImage.Point> result = new ArrayList<ComposedImage.Point>();
            result.add(new ComposedImage.Point());
            ComposedImage.Point overlay = new ComposedImage.Point();
            overlay.y = 7;
            result.add(overlay);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DiagnosticAdapter
    extends EContentAdapter {
        public static void update(Notifier notifier, Diagnostic diagnostic) {
            for (Adapter adapter : notifier.eAdapters()) {
                if (!(adapter instanceof DiagnosticAdapter)) continue;
                ((DiagnosticAdapter)adapter).updateDiagnostic(diagnostic);
            }
        }

        protected abstract void updateDiagnostic(Diagnostic var1);

        protected abstract void handleResourceDiagnostics(List<Resource> var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyChanged(Notification notification) {
            block10: {
                Object notifier;
                block9: {
                    notifier = notification.getNotifier();
                    if (!(notifier instanceof Resource)) break block9;
                    if (notification.isTouch()) break block10;
                    switch (notification.getFeatureID(Resource.class)) {
                        case 4: {
                            Resource resource = (Resource)notifier;
                            this.handleResourceDiagnostics(Collections.singletonList(resource));
                            break;
                        }
                        case 6: 
                        case 7: {
                            Resource.Internal resource = (Resource.Internal)notifier;
                            if (!resource.isLoaded() || resource.isLoading()) break block10;
                            this.handleResourceDiagnostics(Collections.singletonList(resource));
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block10;
                }
                Object object = notifier;
                synchronized (object) {
                    super.notifyChanged(notification);
                }
            }
        }

        protected void setTarget(ResourceSet target) {
            super.setTarget(target);
            this.handleResourceDiagnostics(new ArrayList<Resource>((Collection<Resource>)target.getResources()));
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DiagnosticDecoratorAdapter
    extends DiagnosticAdapter {
        protected Dispatcher dispatcher;

        protected Dispatcher getDispatcher() {
            if (this.dispatcher == null) {
                this.dispatcher = new Dispatcher();
            }
            return this.dispatcher;
        }

        @Override
        public void updateDiagnostic(Diagnostic diagnostic) {
            this.getDispatcher().dispatch(diagnostic);
        }

        @Override
        protected void handleResourceDiagnostics(List<Resource> resources) {
            BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, EMFEditUIPlugin.INSTANCE.getString("_UI_DiagnosisOfNObjects_message", new String[]{"" + resources.size()}), new Object[]{DiagnosticDecorator.this.resourceSet});
            LiveValidator liveValidator = DiagnosticDecorator.this.getLiveValidator();
            if (liveValidator != null) {
                for (Resource resource : resources) {
                    diagnostic.add(DiagnosticDecorator.this.markerHelper.getMarkerDiagnostics((Object)resource, null, false));
                    liveValidator.scheduleValidation(resource);
                }
            }
            this.updateDiagnostic((Diagnostic)diagnostic);
        }

        protected void refreshResourceDiagnostics(List<Resource> resources) {
            BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, EMFEditUIPlugin.INSTANCE.getString("_UI_DiagnosisOfNObjects_message", new String[]{"" + resources.size()}), new Object[]{DiagnosticDecorator.this.resourceSet});
            for (Resource resource : resources) {
                diagnostic.add(DiagnosticDecorator.this.markerHelper.getMarkerDiagnostics((Object)resource, null, false));
                DiagnosticDecorator.this.liveValidator.scheduleValidation(resource);
            }
            DiagnosticDecorator.this.diagnostics.clear();
            this.updateDiagnostic((Diagnostic)diagnostic);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class Dispatcher
        implements Runnable {
            protected Display display = Display.getDefault();
            protected List<Diagnostic> diagnostics;
            protected int expectedSize;
            private boolean isDispatching;

            protected Dispatcher() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispatch(Diagnostic diagnostic) {
                List<Diagnostic> currentDiagnostics = null;
                Dispatcher dispatcher = this;
                synchronized (dispatcher) {
                    if (this.diagnostics == null) {
                        this.diagnostics = new ArrayList<Diagnostic>();
                    }
                    DiagnosticDecorator.this.updateDiagnotics(this.diagnostics, diagnostic);
                    if (!this.dispatch()) {
                        currentDiagnostics = this.diagnostics;
                        this.diagnostics = null;
                    }
                }
                if (currentDiagnostics != null) {
                    this.dispatch(currentDiagnostics);
                }
            }

            protected boolean dispatch() {
                if (Display.getCurrent() != this.display) {
                    this.expectedSize = this.diagnostics.size();
                    this.display.asyncExec(new Runnable(){

                        public void run() {
                            Dispatcher.this.display.timerExec(1000, (Runnable)Dispatcher.this);
                        }
                    });
                    return true;
                }
                return false;
            }

            protected void dispatch(List<Diagnostic> diagnostics) {
                BasicDiagnostic resourceSetDiagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, EMFEditUIPlugin.INSTANCE.getString("_UI_DiagnosisOfNObjects_message", new String[]{"" + diagnostics.size()}), new Object[]{((DiagnosticDecoratorAdapter)DiagnosticDecoratorAdapter.this).DiagnosticDecorator.this.resourceSet});
                for (Diagnostic diagnostic : diagnostics) {
                    resourceSetDiagnostic.add(diagnostic);
                }
                if (!this.isDispatching) {
                    try {
                        this.isDispatching = true;
                        DiagnosticDecorator.this.handleDiagnostic((Diagnostic)resourceSetDiagnostic);
                    }
                    finally {
                        this.isDispatching = false;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<Diagnostic> currentDiagnostics;
                Dispatcher dispatcher = this;
                synchronized (dispatcher) {
                    if (this.diagnostics == null) {
                        return;
                    }
                    if (this.diagnostics.size() != this.expectedSize) {
                        this.expectedSize = this.diagnostics.size();
                        this.display.asyncExec(new Runnable(){

                            public void run() {
                                Dispatcher.this.display.timerExec(1000, (Runnable)Dispatcher.this);
                            }
                        });
                        return;
                    }
                    currentDiagnostics = this.diagnostics;
                    this.diagnostics = null;
                }
                this.dispatch(currentDiagnostics);
            }
        }
    }

    public static class EditingDomainLocationListener
    extends ColumnViewerInformationControlToolTipSupport.PathLocationListener {
        protected EditingDomain editingDomain;

        public EditingDomainLocationListener(EditingDomain editingDomain, StructuredViewer viewer) {
            super(viewer);
            this.editingDomain = editingDomain;
        }

        public void changing(LocationEvent event) {
            EObject eObject = null;
            try {
                URI uri = URI.createURI((String)event.location);
                if (uri.hasFragment()) {
                    eObject = this.editingDomain.getResourceSet().getEObject(uri, false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (eObject != null) {
                event.doit = false;
                if (this.editingDomain instanceof AdapterFactoryEditingDomain) {
                    this.setSelection(((AdapterFactoryEditingDomain)this.editingDomain).getWrapper((Object)eObject));
                } else {
                    this.setSelection(eObject);
                }
            } else {
                super.changing(event);
            }
        }
    }

    public static class LiveValidator {
        private final List<DiagnosticDecorator> diagnosticDecorators = new ArrayList<DiagnosticDecorator>();
        protected EditingDomain editingDomain;
        protected IDialogSettings dialogSettings;
        protected AdapterFactory adapterFactory;
        protected ILabelProvider labelProvider;
        protected Job validationJob;
        protected List<Resource> scheduledResources = Collections.synchronizedList(new UniqueEList());

        public LiveValidator(final EditingDomain editingDomain, IDialogSettings dialogSettings) {
            this.editingDomain = editingDomain;
            this.dialogSettings = dialogSettings;
            this.adapterFactory = editingDomain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory() : null;
            this.labelProvider = this.adapterFactory == null ? null : new AdapterFactoryLabelProvider(this.adapterFactory);
            editingDomain.getCommandStack().addCommandStackListener(new CommandStackListener(){

                public void commandStackChanged(EventObject event) {
                    Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                    if (!(mostRecentCommand instanceof AbstractCommand.NonDirtying)) {
                        LiveValidator.this.scheduledResources.addAll((Collection<Resource>)editingDomain.getResourceSet().getResources());
                        LiveValidator.this.scheduleValidation();
                    }
                }
            });
        }

        public void scheduleValidation(Resource resource) {
            this.scheduledResources.add(resource);
            this.scheduleValidation();
        }

        public void scheduleValidation() {
            if (this.validationJob == null && (this.dialogSettings == null || this.dialogSettings.getBoolean("liveValidator"))) {
                this.validationJob = new Job("Validation Job"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(final IProgressMonitor monitor) {
                        try {
                            TreeIterator i;
                            ResourceSet resourceSet;
                            Diagnostician diagnostician = new Diagnostician(){

                                public String getObjectLabel(EObject eObject) {
                                    Image image;
                                    String text = (this).LiveValidator.this.labelProvider != null && eObject.eIsProxy() ? ((InternalEObject)eObject).eProxyURI().toString() : (this).LiveValidator.this.labelProvider.getText((Object)eObject);
                                    text = text == null || text.length() == 0 ? "<i>null</i>" : DiagnosticDecorator.escapeContent(text);
                                    Image image2 = image = (this).LiveValidator.this.labelProvider != null ? (this).LiveValidator.this.labelProvider.getImage((Object)eObject) : null;
                                    if (image != null) {
                                        URI imageURI = ImageURIRegistry.INSTANCE.getImageURI(image);
                                        return DiagnosticDecorator.enquote("<img src='" + imageURI + "'/> " + text);
                                    }
                                    return text;
                                }

                                public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                                    if (monitor.isCanceled()) {
                                        throw new RuntimeException();
                                    }
                                    monitor.worked(1);
                                    return super.validate(eClass, eObject, diagnostics, context);
                                }
                            };
                            ResourceSet resourceSet2 = LiveValidator.this.editingDomain.getResourceSet();
                            UniqueEList resources = new UniqueEList(Arrays.asList(LiveValidator.this.scheduledResources.toArray(new Resource[0])));
                            LiveValidator.this.scheduledResources.removeAll((Collection<?>)resources);
                            int count = 0;
                            for (Resource resource : resources) {
                                Resource resource2 = resource;
                                synchronized (resource2) {
                                    resourceSet = resourceSet2;
                                    synchronized (resourceSet) {
                                        i = resource.getAllContents();
                                        while (i.hasNext()) {
                                            ++count;
                                            EObject eObject = (EObject)i.next();
                                            for (EObject eCrossReference : eObject.eCrossReferences()) {
                                                if (!monitor.isCanceled()) continue;
                                                throw new RuntimeException();
                                            }
                                        }
                                    }
                                }
                            }
                            List<Resource> moreResources = Arrays.asList(LiveValidator.this.scheduledResources.toArray(new Resource[0]));
                            while (!moreResources.isEmpty()) {
                                resources.addAll(moreResources);
                                LiveValidator.this.scheduledResources.removeAll(moreResources);
                                for (Resource resource : moreResources) {
                                    resourceSet = resource;
                                    synchronized (resourceSet) {
                                        i = resourceSet2;
                                        synchronized (i) {
                                            TreeIterator i2 = resource.getAllContents();
                                            while (i2.hasNext()) {
                                                ++count;
                                                EObject eObject = (EObject)i2.next();
                                                for (EObject eCrossReference : eObject.eCrossReferences()) {
                                                    if (!monitor.isCanceled()) continue;
                                                    throw new RuntimeException();
                                                }
                                            }
                                        }
                                    }
                                }
                                moreResources = Arrays.asList(LiveValidator.this.scheduledResources.toArray(new Resource[0]));
                            }
                            monitor.beginTask("", count);
                            BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, EMFEditUIPlugin.INSTANCE.getString("_UI_DiagnosisOfNObjects_message", new String[]{"" + resources.size()}), new Object[]{resourceSet2});
                            Map context = diagnostician.createDefaultContext();
                            int i3 = 0;
                            while (i3 < resources.size()) {
                                Resource resource = (Resource)resources.get(i3);
                                monitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{resource.getURI()}));
                                BasicDiagnostic resourceDiagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, EMFEditUIPlugin.INSTANCE.getString("_UI_DiagnosisOfNObjects_message", new String[]{"1"}), new Object[]{resource});
                                for (EObject eObject : resource.getContents()) {
                                    diagnostician.validate(eObject, (DiagnosticChain)resourceDiagnostic, context);
                                    context.remove("org.eclipse.emf.ecore.EObject_NoCircularContainment");
                                }
                                for (Diagnostic instrinsicDiagnostic : new EditUIMarkerHelper().getIntrinsicDiagnostics(resource, false)) {
                                    resourceDiagnostic.add(instrinsicDiagnostic);
                                }
                                diagnostic.add((Diagnostic)resourceDiagnostic);
                                if (monitor.isCanceled()) {
                                    throw new RuntimeException();
                                }
                                monitor.worked(1);
                                ++i3;
                            }
                            DiagnosticAdapter.update((Notifier)resourceSet2, (Diagnostic)diagnostic);
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    (this).LiveValidator.this.validationJob = null;
                                    if (!monitor.isCanceled() && !(this).LiveValidator.this.scheduledResources.isEmpty()) {
                                        LiveValidator.this.scheduleValidation();
                                    }
                                }
                            });
                            return Status.OK_STATUS;
                        }
                        catch (RuntimeException exception) {
                            LiveValidator.this.validationJob = null;
                            return Status.CANCEL_STATUS;
                        }
                    }
                };
                this.validationJob.setPriority(50);
                this.validationJob.schedule(500L);
            }
        }

        public void cancelValidation() {
            final Job validationJob = this.validationJob;
            if (validationJob != null) {
                validationJob.cancel();
                Display display = Display.getCurrent();
                BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                    public void run() {
                        while (validationJob.getState() == 4) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                });
                this.validationJob = null;
            }
        }

        public void register(DiagnosticDecorator diagnosticDecorator) {
            this.diagnosticDecorators.add(diagnosticDecorator);
        }

        public void deregister(DiagnosticDecorator diagnosticDecorator) {
            if (this.diagnosticDecorators.remove((Object)diagnosticDecorator) && this.diagnosticDecorators.isEmpty()) {
                this.dispose();
            }
        }

        public void dispose() {
            LIVE_VALIDATORS.remove(this.editingDomain);
            if (this.validationJob != null) {
                this.validationJob.cancel();
            }
        }

        public static class LiveValidationAction
        extends Action {
            public static final String LIVE_VALIDATOR_DIALOG_SETTINGS_KEY = "liveValidator";
            protected EditingDomain domain;
            protected IDialogSettings dialogSettings;

            public LiveValidationAction(EditingDomain domain, IDialogSettings dialogSettings) {
                this(dialogSettings);
                this.domain = domain;
                this.update();
            }

            public LiveValidationAction(IDialogSettings dialogSettings) {
                super(EMFEditUIPlugin.INSTANCE.getString("_UI_LiveValidation_menu_item"));
                this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_LiveValidation_simple_description"));
                this.dialogSettings = dialogSettings;
            }

            public EditingDomain getEditingDomain() {
                return this.domain;
            }

            public void setEditingDomain(EditingDomain domain) {
                this.domain = domain;
            }

            public void run() {
                boolean checked = this.isChecked();
                if (this.dialogSettings != null) {
                    this.dialogSettings.put(LIVE_VALIDATOR_DIALOG_SETTINGS_KEY, checked);
                }
                this.update();
                LiveValidator liveValidator = (LiveValidator)LIVE_VALIDATORS.get(this.domain);
                if (liveValidator != null) {
                    ResourceSet resourceSet = this.domain.getResourceSet();
                    EList resources = resourceSet.getResources();
                    if (checked) {
                        liveValidator.scheduledResources.addAll((Collection<Resource>)resources);
                        liveValidator.scheduleValidation();
                    } else {
                        for (Adapter adapter : resourceSet.eAdapters()) {
                            if (!(adapter instanceof DiagnosticDecoratorAdapter)) continue;
                            DiagnosticDecoratorAdapter diagnosticDecoratorAdapter = (DiagnosticDecoratorAdapter)adapter;
                            diagnosticDecoratorAdapter.refreshResourceDiagnostics((List<Resource>)resources);
                        }
                    }
                }
            }

            public void update() {
                this.setEnabled(this.domain != null);
                if (this.dialogSettings != null) {
                    this.setChecked(this.dialogSettings.getBoolean(LIVE_VALIDATOR_DIALOG_SETTINGS_KEY));
                }
            }

            public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
                this.setEditingDomain(workbenchPart instanceof IEditingDomainProvider ? ((IEditingDomainProvider)workbenchPart).getEditingDomain() : null);
            }
        }
    }

    public static class Styled
    extends DiagnosticDecorator
    implements IStyledLabelDecorator {
        public Styled(EditingDomain editingDomain, ExtendedPropertySheetPage propertySheetPage, IDialogSettings dialogSettings) {
            super(editingDomain, propertySheetPage, dialogSettings);
        }

        public Styled(EditingDomain editingDomain, ExtendedPropertySheetPage propertySheetPage) {
            super(editingDomain, propertySheetPage);
        }

        public Styled(EditingDomain editingDomain, StructuredViewer viewer, IDialogSettings dialogSettings) {
            super(editingDomain, viewer, dialogSettings);
        }

        public Styled(EditingDomain editingDomain, StructuredViewer viewer) {
            super(editingDomain, viewer);
        }

        public Styled(ResourceSet resourceSet, ExtendedPropertySheetPage propertySheetPage) {
            super(resourceSet, propertySheetPage);
        }

        public Styled(ResourceSet resourceSet, StructuredViewer viewer) {
            super(resourceSet, viewer);
        }

        public StyledString decorateStyledText(StyledString styledString, Object object) {
            return styledString;
        }
    }

    public static class StyledError
    extends Styled
    implements IStyledLabelDecorator {
        public StyledError(EditingDomain editingDomain, ExtendedPropertySheetPage propertySheetPage, IDialogSettings dialogSettings) {
            super(editingDomain, propertySheetPage, dialogSettings);
        }

        public StyledError(EditingDomain editingDomain, ExtendedPropertySheetPage propertySheetPage) {
            super(editingDomain, propertySheetPage);
        }

        public StyledError(EditingDomain editingDomain, StructuredViewer viewer, IDialogSettings dialogSettings) {
            super(editingDomain, viewer, dialogSettings);
        }

        public StyledError(EditingDomain editingDomain, StructuredViewer viewer) {
            super(editingDomain, viewer);
        }

        public StyledError(ResourceSet resourceSet, ExtendedPropertySheetPage propertySheetPage) {
            super(resourceSet, propertySheetPage);
        }

        public StyledError(ResourceSet resourceSet, StructuredViewer viewer) {
            super(resourceSet, viewer);
        }

        public StyledString decorateStyledText(StyledString styledString, Object object) {
            if (styledString == null || object == null) {
                throw new NullPointerException();
            }
            Diagnostic diagnostic = this.getDecorations().get(object);
            if (diagnostic != null && diagnostic.getSeverity() >= 2) {
                StyledString result = new StyledString();
                StyleRange[] styleRanges = styledString.getStyleRanges();
                String string = styledString.getString();
                if (styleRanges.length == 0) {
                    result.append(string, ErrorStyler.INSTANCE);
                } else {
                    int start = 0;
                    StyleRange[] styleRangeArray = styleRanges;
                    int n = styleRanges.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StyleRange range = styleRangeArray[n2];
                        if (start < range.start) {
                            result.append(string.substring(start, range.start - start), ErrorStyler.INSTANCE);
                        }
                        start = range.start + range.length;
                        result.append(string.substring(range.start, start), (StyledString.Styler)new ComposedStyler((TextStyle)range, ErrorStyler.INSTANCE));
                        ++n2;
                    }
                    if (start < styledString.length()) {
                        result.append(string.substring(start, string.length()), ErrorStyler.INSTANCE);
                    }
                }
                return result;
            }
            return styledString;
        }

        public static class ComposedStyler
        extends StyledString.Styler {
            protected TextStyle baseStyle;
            protected StyledString.Styler[] stylers;

            public ComposedStyler(TextStyle baseStyle, StyledString.Styler ... stylers) {
                this.baseStyle = baseStyle;
                this.stylers = stylers;
            }

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = this.baseStyle.font;
                textStyle.metrics = this.baseStyle.metrics;
                textStyle.rise = this.baseStyle.rise;
                textStyle.background = this.baseStyle.background;
                textStyle.foreground = this.baseStyle.foreground;
                textStyle.borderColor = this.baseStyle.borderColor;
                textStyle.borderStyle = this.baseStyle.borderStyle;
                textStyle.strikeout = this.baseStyle.strikeout;
                textStyle.strikeoutColor = this.baseStyle.strikeoutColor;
                textStyle.underline = this.baseStyle.underline;
                textStyle.underlineStyle = this.baseStyle.underlineStyle;
                textStyle.underlineColor = this.baseStyle.underlineColor;
                textStyle.data = this.baseStyle.data;
                StyledString.Styler[] stylerArray = this.stylers;
                int n = this.stylers.length;
                int n2 = 0;
                while (n2 < n) {
                    StyledString.Styler styler = stylerArray[n2];
                    styler.applyStyles(textStyle);
                    ++n2;
                }
            }
        }

        public static final class ErrorStyler
        extends StyledString.Styler {
            public static final StyledString.Styler INSTANCE = new ErrorStyler();

            public void applyStyles(TextStyle textStyle) {
                textStyle.underline = true;
                textStyle.underlineStyle = 2;
                textStyle.underlineColor = JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
        }
    }
}

