/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.trace.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.ui.trace.internal.TracingUIActivator;
import org.eclipse.ui.trace.internal.datamodel.TracingComponentDebugOption;
import org.osgi.framework.Bundle;

public class TracingUtils {
    public static boolean isValueBoolean(String value) {
        return value != null && (value.toLowerCase().equals("false") || value.toLowerCase().equals("true"));
    }

    public static String convertToString(TracingComponentDebugOption debugOption) {
        StringBuilder buffer = new StringBuilder();
        if (debugOption != null) {
            buffer.append(debugOption.getOptionPath());
            buffer.append("=");
            buffer.append(debugOption.getOptionPathValue());
            buffer.append(";");
        }
        return buffer.toString();
    }

    public static TracingComponentDebugOption convertToDebugOption(String debugOptionAsString) {
        int separatorIndex;
        TracingComponentDebugOption debugOption = null;
        if (debugOptionAsString != null && (separatorIndex = debugOptionAsString.indexOf("=")) != -1) {
            String key = debugOptionAsString.substring(0, separatorIndex);
            String value = debugOptionAsString.substring(separatorIndex + 1, debugOptionAsString.length());
            debugOption = new TracingComponentDebugOption(key, value);
        }
        return debugOption;
    }

    public static Map<String, String> convertToMap(String debugOptions) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (debugOptions != null) {
            StringTokenizer optionTokens = new StringTokenizer(debugOptions, ";");
            while (optionTokens.hasMoreTokens()) {
                TracingComponentDebugOption newOption = TracingUtils.convertToDebugOption(optionTokens.nextToken());
                if (newOption == null) continue;
                result.put(newOption.getOptionPath(), newOption.getOptionPathValue());
            }
        }
        return result;
    }

    public static Properties loadOptionsFromBundle(Bundle bundle) {
        Properties optionsProperties;
        block13: {
            URL optionsFile;
            optionsProperties = new Properties();
            if (bundle != null && (optionsFile = bundle.getEntry(".options")) != null) {
                InputStream optionsFileInStream = null;
                try {
                    try {
                        optionsFileInStream = optionsFile.openStream();
                        optionsProperties.load(optionsFileInStream);
                    }
                    catch (IOException ioEx) {
                        TracingUIActivator.getDefault().logException(ioEx);
                        if (optionsFileInStream == null) break block13;
                        try {
                            optionsFileInStream.close();
                        }
                        catch (IOException ioEx2) {
                            TracingUIActivator.getDefault().logException(ioEx2);
                        }
                    }
                }
                finally {
                    if (optionsFileInStream != null) {
                        try {
                            optionsFileInStream.close();
                        }
                        catch (IOException ioEx) {
                            TracingUIActivator.getDefault().logException(ioEx);
                        }
                    }
                }
            }
        }
        return optionsProperties;
    }
}

