/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.rcptt.core.builder.IQ7ProblemReporter;
import org.eclipse.rcptt.core.builder.IQ7Validator;
import org.eclipse.rcptt.core.internal.builder.Q7Problem;
import org.eclipse.rcptt.core.internal.builder.Q7ValidatorManager;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.editors.ecl.EclProblemAnnotation;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewer;
import org.eclipse.rcptt.ui.editors.ecl.IEclReconcilingListener;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class EclReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IProgressMonitor fProgressMonitor;
    private boolean fNotify = true;
    private IEclReconcilingListener eclReconcilingListener;
    private EclSourceViewer viewer;
    private IQ7Validator[] validators;
    private final String ERROR_ANNOTATION_TYPE = "org.eclipse.rcptt.editor.q7error";
    private final String WARNING_ANNOTATION_TYPE = "org.eclipse.rcptt.editor.q7warning";

    public EclReconcilingStrategy(EclSourceViewer viewer) {
        this.viewer = viewer;
        this.validators = new Q7ValidatorManager().getExtensions();
    }

    public void setEclReconcilingListener(IEclReconcilingListener eclReconcilingListener) {
        this.eclReconcilingListener = eclReconcilingListener;
    }

    private void reconcile(final boolean initialReconcile) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                EclReconcilingStrategy.this.reconcile(EclReconcilingStrategy.this.viewer.getElement(), initialReconcile);
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.eclipse.rcptt.ui", 0, "Error in RCPTT during reconcile", ex);
                Q7UIPlugin.getDefault().getLog().log((IStatus)status);
            }
        });
    }

    private void reconcile(IQ7NamedElement unit, boolean initialReconcile) {
        final ArrayList problems = new ArrayList();
        IQ7ProblemReporter reporter = new IQ7ProblemReporter(){

            public void reportProblem(IFile element, IQ7ProblemReporter.ProblemType type, String message, int line, int offset, int length, int sourceId) {
                problems.add(new Q7Problem(message, line, offset, type.getValue(), length, sourceId));
            }
        };
        IQ7Validator[] iQ7ValidatorArray = this.validators;
        int n = this.validators.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7Validator validator = iQ7ValidatorArray[n2];
            validator.reconcile(unit, this.viewer.getDocument().get(), reporter, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        IAnnotationModel annotationModel = this.viewer.getAnnotationModel();
        ArrayList<Annotation> toRemove = new ArrayList<Annotation>();
        Iterator iterator = annotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            if (annotation instanceof MarkerAnnotation) {
                try {
                    String type = ((MarkerAnnotation)annotation).getMarker().getType();
                    if ("org.eclipse.rcptt.core.builder.q7Problem".equals(type)) {
                        toRemove.add(annotation);
                    }
                }
                catch (CoreException e) {
                    Q7UIPlugin.log(e);
                }
            }
            if (!(annotation instanceof EclProblemAnnotation)) continue;
            toRemove.add(annotation);
        }
        for (Annotation annotation : toRemove) {
            annotationModel.removeAnnotation(annotation);
        }
        for (Q7Problem q7Problem : problems) {
            String annotationType = null;
            switch (q7Problem.getSeverity()) {
                case 2: {
                    annotationType = "org.eclipse.rcptt.editor.q7error";
                    break;
                }
                case 1: {
                    annotationType = "org.eclipse.rcptt.editor.q7warning";
                }
            }
            EclProblemAnnotation pr = new EclProblemAnnotation(annotationType, q7Problem);
            annotationModel.addAnnotation((Annotation)pr, new Position(q7Problem.getOffset(), q7Problem.getLength()));
        }
        this.viewer.clearElementContainer();
    }

    public void reconcile(IRegion partition) {
        this.reconcile(false);
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(false);
    }

    public void setDocument(IDocument document) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void initialReconcile() {
        this.reconcile(true);
    }

    public void notifyListeners(boolean notify) {
        this.fNotify = notify;
    }

    public void aboutToBeReconciled() {
        this.eclReconcilingListener.aboutToBeReconciled();
    }

    public void reconciled() {
        try {
            IProgressMonitor pm = this.fProgressMonitor;
            if (pm == null) {
                pm = new NullProgressMonitor();
            }
            if (this.eclReconcilingListener != null) {
                this.eclReconcilingListener.reconciled(null, !this.fNotify, pm);
            }
        }
        finally {
            this.fNotify = true;
        }
    }
}

