/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.rename;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.resources.WSUtils;
import org.eclipse.rcptt.ui.editors.INamedElementEditor;
import org.eclipse.rcptt.ui.utils.ModelUtils;
import org.eclipse.rcptt.workspace.WSContainer;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSResource;

public class RenameNamedElementChange
extends ResourceChange {
    private static final String RENAME_MESSAGE = Messages.RenameNamedElementChange_Msg;
    private static final String RENAME_PROGRESS_MESSAGE = Messages.RenameNamedElementChange_ProgressMsg;
    private final String fNewResourceName;
    private final String fNewElementName;
    private final IPath fResourcePath;
    private IQ7NamedElement fElement;
    private ChangeDescriptor fDescriptor;

    public RenameNamedElementChange(IPath resourcePath, String newResourceName, String newElementName) {
        if (resourcePath == null || newResourceName == null || newResourceName.length() == 0 || newElementName == null || newElementName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.fResourcePath = resourcePath;
        this.fElement = (IQ7NamedElement)RcpttCore.create((IResource)((IFile)this.getModifiedResource()));
        if (this.fElement == null) {
            throw new IllegalArgumentException();
        }
        this.fNewResourceName = newResourceName;
        this.fNewElementName = newElementName;
        this.fDescriptor = null;
        this.setValidationMethod(2);
    }

    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    protected IResource getModifiedResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public String getName() {
        return MessageFormat.format(RENAME_MESSAGE, RenameNamedElementChange.getPathLabel(this.fResourcePath), RenameNamedElementChange.getResourceName(this.fNewResourceName));
    }

    private static String getPathLabel(IPath path) {
        String label = path.makeRelative().toString();
        return TextProcessor.process((String)label, (String)"/\\:.");
    }

    private static String getResourceName(String resourceName) {
        return TextProcessor.process((String)resourceName, (String)":.");
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            IPath newPath;
            String oldResourceName;
            String oldElementName;
            block13: {
                pm.beginTask(RENAME_PROGRESS_MESSAGE, 1);
                oldElementName = this.fElement.getElementName();
                oldResourceName = this.fResourcePath.lastSegment();
                IResource resource = this.getModifiedResource();
                INamedElementEditor editor = ModelUtils.findEditor(this.fElement);
                boolean isDirtyInEditor = false;
                if (editor != null && editor.isDirty()) {
                    isDirtyInEditor = true;
                }
                newPath = RenameNamedElementChange.renamedResourcePath(this.fResourcePath, this.fNewResourceName);
                RcpttCore.getInstance().rename((IFile)resource, newPath);
                IQ7Element newElement = RcpttCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(newPath));
                if (newElement == null) {
                    return null;
                }
                IQ7NamedElement copy = ((IQ7NamedElement)newElement).getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                copy.setElementName(this.fNewElementName);
                try {
                    try {
                        if (!isDirtyInEditor) {
                            copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        if (editor != null) {
                            editor.renamed(!isDirtyInEditor);
                        }
                    }
                    catch (Exception e) {
                        Q7UIPlugin.log(e);
                        copy.discardWorkingCopy();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    copy.discardWorkingCopy();
                    throw throwable;
                }
                copy.discardWorkingCopy();
            }
            RenameNamedElementChange renameNamedElementChange = new RenameNamedElementChange(newPath, oldResourceName, oldElementName);
            return renameNamedElementChange;
        }
        finally {
            pm.done();
        }
    }

    private static void updateFileReference(String folderName, WSResource res) {
        WSFile file;
        String uri;
        if (res instanceof WSContainer) {
            for (WSResource child : WSUtils.getContents((WSContainer)((WSContainer)res))) {
                RenameNamedElementChange.updateFileReference(folderName, child);
            }
        } else if (res instanceof WSFile && (uri = (file = (WSFile)res).getContentURI()) != null && uri.length() > 0) {
            Path path = new Path(uri);
            path = new Path(folderName).append(path.removeFirstSegments(1));
            file.setContentURI(path.toString());
        }
    }

    private static String getFolderName(String fileName) {
        String folderName = fileName.replaceAll("\\.", "");
        return "." + folderName;
    }

    private static IPath renamedResourcePath(IPath path, String newName) {
        return path.removeLastSegments(1).append(newName);
    }
}

