/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.toc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ua.core.toc.text.Toc;
import org.eclipse.pde.internal.ua.core.toc.text.TocLink;
import org.eclipse.pde.internal.ua.core.toc.text.TocModel;
import org.eclipse.pde.internal.ua.core.toc.text.TocObject;
import org.eclipse.pde.internal.ua.core.toc.text.TocTopic;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.editor.toc.HelpEditorUtil;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocContentProvider;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocDragAdapter;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocDropAdapter;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocHTMLTitleUtil;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocMessages;
import org.eclipse.pde.internal.ua.ui.editor.toc.actions.TocAddAnchorAction;
import org.eclipse.pde.internal.ua.ui.editor.toc.actions.TocAddLinkAction;
import org.eclipse.pde.internal.ua.ui.editor.toc.actions.TocAddObjectAction;
import org.eclipse.pde.internal.ua.ui.editor.toc.actions.TocAddTopicAction;
import org.eclipse.pde.internal.ua.ui.editor.toc.actions.TocRemoveObjectAction;
import org.eclipse.pde.internal.ua.ui.wizards.toc.NewTocFileWizard;
import org.eclipse.pde.internal.ua.ui.wizards.toc.TocHTMLWizard;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.actions.CollapseAction;
import org.eclipse.pde.internal.ui.editor.plugin.FormFilteredTree;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.pde.internal.ui.util.PDELabelUtility;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.keys.IBindingService;

public class TocTreeSection
extends TreeSection {
    private TocModel fModel;
    private TreeViewer fTocTree;
    private FormFilteredTree fFilteredTree;
    private static final int F_BUTTON_ADD_TOPIC = 0;
    private static final int F_BUTTON_ADD_LINK = 3;
    private static final int F_BUTTON_ADD_ANCHOR = 4;
    private static final int F_BUTTON_REMOVE = 5;
    private static final int F_BUTTON_UP = 6;
    private static final int F_BUTTON_DOWN = 7;
    private static final int F_UP_FLAG = -1;
    private static final int F_DOWN_FLAG = 1;
    private CollapseAction fCollapseAction;
    private TocAddTopicAction fAddTopicAction;
    private TocAddLinkAction fAddLinkAction;
    private TocAddAnchorAction fAddAnchorAction;
    private TocRemoveObjectAction fRemoveObjectAction;
    private TocOpenLinkAction fOpenLinkAction;
    private TocDragAdapter fDragAdapter;
    private boolean fDragFromHere;

    public TocTreeSection(PDEFormPage formPage, Composite parent) {
        String[] stringArray = new String[8];
        stringArray[0] = TocMessages.TocTreeSection_addTopic;
        stringArray[3] = TocMessages.TocTreeSection_addLink;
        stringArray[4] = TocMessages.TocTreeSection_addAnchor;
        stringArray[5] = TocMessages.TocTreeSection_remove;
        stringArray[6] = TocMessages.TocTreeSection_up;
        stringArray[7] = TocMessages.TocTreeSection_down;
        super(formPage, parent, 128, stringArray);
        this.fAddTopicAction = new TocAddTopicAction();
        this.fAddLinkAction = new TocAddLinkAction();
        this.fAddAnchorAction = new TocAddAnchorAction();
        this.fRemoveObjectAction = new TocRemoveObjectAction();
        this.fOpenLinkAction = new TocOpenLinkAction();
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (TocModel)this.getPage().getModel();
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createTree(container, toolkit);
        toolkit.paintBordersFor(container);
        section.setText(TocMessages.TocTreeSection_sectionText);
        section.setDescription(TocMessages.TocTreeSection_sectionDesc);
        section.setClient((Control)container);
        this.initializeTreeViewer();
        this.createSectionToolbar(section, toolkit);
        this.fFilteredTree.createUIListenerEntryFilter((IContextPart)this);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        this.fCollapseAction = new CollapseAction((AbstractTreeViewer)this.fTocTree, TocMessages.TocTreeSection_collapseAll, 1, (Object)this.fModel.getToc());
        toolBarManager.add((IAction)this.fCollapseAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void createTree(Composite container, FormToolkit toolkit) {
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(container, 2050, 2, toolkit);
        this.fTocTree = treePart.getTreeViewer();
        this.fTocTree.setContentProvider((IContentProvider)new TocContentProvider());
        this.fTocTree.setLabelProvider((IBaseLabelProvider)PDEUserAssistanceUIPlugin.getDefault().getLabelProvider());
        PDEUserAssistanceUIPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.createTreeListeners();
        this.initDragAndDrop();
    }

    private void initDragAndDrop() {
        int ops = 1;
        if (this.isEditable()) {
            ops |= 2;
        }
        Transfer[] dragTransfers = new Transfer[]{ModelDataTransfer.getInstance(), TextTransfer.getInstance()};
        this.fDragAdapter = new TocDragAdapter(this);
        this.fTocTree.addDragSupport(ops, dragTransfers, (DragSourceListener)this.fDragAdapter);
        if (this.isEditable()) {
            Transfer[] dropTransfers = new Transfer[]{ModelDataTransfer.getInstance(), FileTransfer.getInstance()};
            this.fTocTree.addDropSupport(ops | 0x10, dropTransfers, (DropTargetListener)new TocDropAdapter(this.fTocTree, this));
        }
    }

    private void createTreeListeners() {
        this.fTocTree.addPostSelectionChangedListener((ISelectionChangedListener)new PDEFormEditor.PDEFormEditorChangeListener(this.getPage().getPDEEditor()));
    }

    private void initializeTreeViewer() {
        if (this.fModel == null) {
            return;
        }
        this.fTocTree.setInput((Object)this.fModel);
        Toc toc = this.fModel.getToc();
        this.getTreePart().setButtonEnabled(0, this.isEditable());
        this.getTreePart().setButtonEnabled(4, this.isEditable());
        this.getTreePart().setButtonEnabled(3, this.isEditable());
        this.getTreePart().setButtonEnabled(5, false);
        this.getTreePart().setButtonEnabled(6, false);
        this.getTreePart().setButtonEnabled(7, false);
        this.fTocTree.setSelection((ISelection)new StructuredSelection((Object)toc), true);
        this.fTocTree.expandToLevel(2);
    }

    public boolean setFormInput(Object object) {
        if (object instanceof TocObject) {
            this.fTocTree.setSelection((ISelection)new StructuredSelection(object), true);
            ISelection selection = this.fTocTree.getSelection();
            if (selection != null && !selection.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public ISelection getSelection() {
        return this.fTocTree.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.fTocTree.setSelection(selection);
    }

    public void fireSelection() {
        this.fTocTree.setSelection(this.fTocTree.getSelection());
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    public void updateButtons() {
        if (!this.fModel.isEditable()) {
            return;
        }
        boolean canAddObject = false;
        boolean canRemove = false;
        ITreeSelection sel = this.fTocTree.getStructuredSelection();
        boolean canMoveUp = sel.size() == 1;
        boolean canMoveDown = sel.size() == 1;
        for (TocObject tocObject : sel) {
            if (tocObject != null) {
                if (tocObject.canBeRemoved()) {
                    canRemove = true;
                }
                TocObject parent = tocObject.getParent();
                if (sel.size() == 1 && (tocObject.getType() == 0 || parent.getType() == 1 || parent.getType() == 0)) {
                    canAddObject = true;
                }
                if (tocObject.getType() == 0) {
                    canMoveUp = false;
                    canMoveDown = false;
                    continue;
                }
                if (parent == null) continue;
                TocTopic topic = (TocTopic)parent;
                if (topic.isFirstChildObject(tocObject)) {
                    canMoveUp = false;
                }
                if (!topic.isLastChildObject(tocObject)) continue;
                canMoveDown = false;
                continue;
            }
            canAddObject = false;
            canRemove = false;
            canMoveUp = false;
            canMoveDown = false;
            break;
        }
        this.getTreePart().setButtonEnabled(0, canAddObject);
        this.getTreePart().setButtonEnabled(3, canAddObject);
        this.getTreePart().setButtonEnabled(4, canAddObject);
        this.getTreePart().setButtonEnabled(5, canRemove);
        this.getTreePart().setButtonEnabled(6, canMoveUp);
        this.getTreePart().setButtonEnabled(7, canMoveDown);
    }

    protected void fillContextMenu(IMenuManager manager) {
        ITreeSelection selection = this.fTocTree.getStructuredSelection();
        Object object = selection.getFirstElement();
        TocObject tocObject = (TocObject)object;
        if (tocObject != null) {
            boolean emptyMenu = true;
            if (tocObject.canBeParent()) {
                MenuManager submenu = new MenuManager(TocMessages.TocTreeSection_New);
                this.fillContextMenuAddActions(submenu, tocObject);
                manager.add((IContributionItem)submenu);
                emptyMenu = false;
            }
            if (tocObject.getPath() != null) {
                this.fOpenLinkAction.setTarget(tocObject);
                manager.add((IAction)this.fOpenLinkAction);
                emptyMenu = false;
            }
            if (!emptyMenu) {
                manager.add((IContributionItem)new Separator());
            }
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        if (tocObject != null) {
            this.fillContextMenuRemoveAction(manager, tocObject);
            manager.add((IContributionItem)new Separator());
            this.fillContextMenuShowInAction(manager);
            manager.add((IContributionItem)new Separator());
        }
    }

    private void fillContextMenuShowInAction(IMenuManager manager) {
        String keyBinding;
        String showInLabel = TocMessages.TocTreeSection_showIn;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null && (keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu")) != null) {
            showInLabel = String.valueOf(showInLabel) + '\t' + keyBinding;
        }
        MenuManager showInMenu = new MenuManager(showInLabel);
        showInMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getPage().getSite().getWorkbenchWindow()));
        manager.add((IContributionItem)showInMenu);
    }

    private void fillContextMenuAddActions(MenuManager submenu, TocObject tocObject) {
        if (tocObject != null && tocObject.canBeParent()) {
            this.fAddTopicAction.setParentObject(tocObject);
            this.fAddTopicAction.setEnabled(this.fModel.isEditable());
            submenu.add((IAction)this.fAddTopicAction);
            this.fAddLinkAction.setParentObject(tocObject);
            this.fAddLinkAction.setEnabled(this.fModel.isEditable());
            submenu.add((IAction)this.fAddLinkAction);
            this.fAddAnchorAction.setParentObject(tocObject);
            this.fAddAnchorAction.setEnabled(this.fModel.isEditable());
            submenu.add((IAction)this.fAddAnchorAction);
        }
    }

    private void fillContextMenuRemoveAction(IMenuManager manager, TocObject tocObject) {
        this.fRemoveObjectAction.setToRemove(tocObject);
        manager.add((IAction)this.fRemoveObjectAction);
        this.fRemoveObjectAction.setEnabled(tocObject.canBeRemoved() && this.fModel.isEditable());
    }

    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        return true;
    }

    public boolean doGlobalAction(String actionId) {
        boolean cutAction = actionId.equals(ActionFactory.CUT.getId());
        if (cutAction || actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDeleteAction();
            return !cutAction;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        this.performDrop(targetObject, sourceObjects, 3);
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        if (selected instanceof TocObject) {
            if (((TocObject)selected).hasXMLChildren()) {
                this.fTocTree.setExpandedState(selected, !this.fTocTree.getExpandedState(selected));
            } else {
                this.open((TocObject)selected);
            }
        }
    }

    private void open(TocObject obj) {
        Path resourcePath;
        String path = obj.getPath();
        Path path2 = resourcePath = path != null ? new Path(path) : null;
        if (!this.isEditable() || resourcePath == null || resourcePath.isEmpty()) {
            MessageDialog.openWarning((Shell)PDEUserAssistanceUIPlugin.getActiveWorkbenchShell(), (String)TocMessages.TocTreeSection_openFile, (String)TocMessages.TocTreeSection_openFileMessage);
            return;
        }
        IResource resource = this.findResource(resourcePath);
        if (resource != null && resource instanceof IFile) {
            this.openResource(resource, obj.getType() == 3);
        } else {
            MessageDialog.openWarning((Shell)PDEUserAssistanceUIPlugin.getActiveWorkbenchShell(), (String)TocMessages.TocTreeSection_openFile, (String)TocMessages.TocTreeSection_openFileMessage2);
        }
    }

    public IFile openFile(String path, boolean isTOCFile) {
        Path resourcePath = new Path(path);
        if (this.isEditable()) {
            IResource page;
            if (!resourcePath.isEmpty() && (page = this.findResource(resourcePath)) != null && page instanceof IFile) {
                this.openResource(page, isTOCFile);
                return null;
            }
            return this.showNewWizard(path, isTOCFile);
        }
        return null;
    }

    private IFile showNewWizard(String path, boolean tocWizard) {
        TocHTMLWizard wizard = tocWizard ? new NewTocFileWizard() : new TocHTMLWizard();
        IProject selectedFolder = this.fModel.getUnderlyingResource().getProject();
        String filename = null;
        Path initialFolder = new Path(path.trim());
        if (!initialFolder.isEmpty()) {
            IPath newPath = selectedFolder.getFullPath().append((IPath)initialFolder);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource newFolder = root.findMember(newPath);
            if (newFolder == null && !newPath.hasTrailingSeparator()) {
                filename = newPath.lastSegment();
            }
            while (newFolder == null && !newPath.isEmpty()) {
                newPath = newPath.removeLastSegments(1);
                newFolder = root.findMember(newPath);
            }
            if (newFolder != null) {
                selectedFolder = newFolder;
            }
        }
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)selectedFolder));
        WizardDialog dialog = new WizardDialog(PDEUserAssistanceUIPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        IWizardPage wizardPage = wizard.getStartingPage();
        if (!(wizardPage instanceof WizardNewFileCreationPage)) {
            return null;
        }
        WizardNewFileCreationPage page = (WizardNewFileCreationPage)wizardPage;
        if (filename != null) {
            page.setFileName(filename);
            page.setErrorMessage(null);
        }
        if (dialog.open() == 0) {
            return wizard.getNewResource();
        }
        return null;
    }

    private IResource findResource(Path resourcePath) {
        IProject pluginProject = this.fModel.getUnderlyingResource().getProject();
        return pluginProject.findMember((IPath)resourcePath);
    }

    private void openResource(IResource resource, boolean tocFile) {
        IPath path = resource.getFullPath();
        if (this.isFileValidInContext(tocFile, path)) {
            try {
                IDE.openEditor((IWorkbenchPage)PDEUserAssistanceUIPlugin.getActivePage(), (IFile)((IFile)resource), (boolean)true);
            }
            catch (PartInitException partInitException) {}
        }
    }

    private boolean isFileValidInContext(boolean tocFile, IPath path) {
        String message = null;
        if (tocFile) {
            if (HelpEditorUtil.isTOCFile(path)) {
                return true;
            }
            message = TocMessages.TocTreeSection_errorMessage1;
        } else {
            if (HelpEditorUtil.hasValidPageExtension(path)) {
                return true;
            }
            message = TocMessages.TocTreeSection_errorMessage2;
        }
        MessageDialog.openWarning((Shell)PDEUserAssistanceUIPlugin.getActiveWorkbenchShell(), (String)TocMessages.TocTreeSection_openFile, (String)message);
        return false;
    }

    public boolean performDrop(Object currentTarget, Object dropped, int location) {
        if (dropped instanceof Object[]) {
            ArrayList<TocObject> objectsToAdd;
            TocObject tocTarget = (TocObject)currentTarget;
            TocTopic targetParent = this.determineParent(tocTarget, location);
            if (location == 5 && targetParent == tocTarget && !tocTarget.getChildren().isEmpty() && this.fTocTree.getExpandedState((Object)tocTarget)) {
                location = 1;
                tocTarget = (TocObject)tocTarget.getChildren().get(0);
            }
            if (targetParent != null && (objectsToAdd = this.getObjectsToAdd((Object[])dropped, targetParent)) != null && !objectsToAdd.isEmpty()) {
                if (this.fDragAdapter.getDraggedElements() != null && this.fDragAdapter.getDraggedElements().size() == 1 && currentTarget == this.fDragAdapter.getDraggedElements().get(0)) {
                    return false;
                }
                boolean insertBefore = location == 1;
                this.handleMultiAddAction(objectsToAdd, tocTarget, insertBefore, (TocObject)targetParent);
                return true;
            }
        }
        return false;
    }

    private TocTopic determineParent(TocObject dropTarget, int dropLocation) {
        if (dropTarget == null || dropTarget.getType() == 0) {
            return this.fModel.getToc();
        }
        if (!dropTarget.canBeParent()) {
            return (TocTopic)dropTarget.getParent();
        }
        switch (dropLocation) {
            case 5: {
                if (!this.fTocTree.getExpandedState((Object)dropTarget)) {
                    return (TocTopic)dropTarget.getParent();
                }
            }
            case 3: {
                return (TocTopic)dropTarget;
            }
            case 1: 
            case 2: {
                return (TocTopic)dropTarget.getParent();
            }
        }
        return null;
    }

    private ArrayList<TocObject> getObjectsToAdd(Object[] droppings, TocTopic targetParent) {
        ArrayList<TocObject> tocObjects = new ArrayList<TocObject>(droppings.length);
        if (this.fDragAdapter.getDraggedElements() != null) {
            this.fDragFromHere = this.fDragAdapter.getDraggedElements().size() == droppings.length;
        }
        int i = 0;
        while (i < droppings.length) {
            if (droppings[i] instanceof String) {
                Path path;
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = root.getFileForLocation((IPath)(path = new Path((String)droppings[i])));
                if (file != null) {
                    if (HelpEditorUtil.isTOCFile((IPath)path) && !HelpEditorUtil.isCurrentResource((IPath)path, (IBaseModel)this.fModel)) {
                        tocObjects.add((TocObject)this.makeNewTocLink((TocObject)targetParent, file));
                    } else if (HelpEditorUtil.hasValidPageExtension((IPath)path)) {
                        TocTopic topic = this.makeNewTocTopic((TocObject)targetParent, file);
                        String title = this.generateTitle(targetParent, path);
                        topic.setFieldLabel(title);
                        tocObjects.add((TocObject)topic);
                    }
                }
            } else if (droppings[i] instanceof TocObject) {
                TocObject draggedObj;
                ArrayList<TocObject> dragged = this.fDragAdapter.getDraggedElements();
                if (this.fDragFromHere && targetParent.descendsFrom(draggedObj = dragged.get(i))) {
                    return null;
                }
                ((TocObject)droppings[i]).reconnect((IDocumentElementNode)targetParent, (IModel)this.fModel);
                tocObjects.add((TocObject)droppings[i]);
            }
            ++i;
        }
        return tocObjects;
    }

    private String generateTitle(TocTopic targetParent, Path path) {
        String title = TocHTMLTitleUtil.findTitle(path.toFile());
        if (title == null) {
            int numChildren = targetParent.getChildren().size();
            TocObject[] children = targetParent.getChildren().toArray(new TocObject[numChildren]);
            String[] tocObjectNames = new String[children.length];
            int j = 0;
            while (j < numChildren) {
                tocObjectNames[j] = children[j].getName();
                ++j;
            }
            title = PDELabelUtility.generateName((String[])tocObjectNames, (String)TocMessages.TocTreeSection_topic);
        }
        return title;
    }

    private TocTopic makeNewTocTopic(TocObject parent, IFile file) {
        return this.fModel.getFactory().createTocTopic(file);
    }

    private TocLink makeNewTocLink(TocObject parent, IFile file) {
        return this.fModel.getFactory().createTocLink(file);
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAddAction(this.fAddTopicAction);
                break;
            }
            case 3: {
                this.handleAddAction(this.fAddLinkAction);
                break;
            }
            case 4: {
                this.handleAddAction(this.fAddAnchorAction);
                break;
            }
            case 5: {
                this.handleDeleteAction();
                break;
            }
            case 6: {
                this.handleMoveAction(-1);
                break;
            }
            case 7: {
                this.handleMoveAction(1);
            }
        }
    }

    private void handleAddAction(TocAddObjectAction action) {
        ITreeSelection sel = this.fTocTree.getStructuredSelection();
        Object object = sel.getFirstElement();
        if (object == null) {
            return;
        }
        TocObject tocObject = (TocObject)object;
        if (tocObject.canBeParent()) {
            action.setParentObject(tocObject);
            action.run();
        } else {
            action.setParentObject(tocObject.getParent());
            action.setTargetObject(tocObject);
            action.run();
        }
    }

    private void handleMultiAddAction(List<TocObject> objectsToAdd, TocObject tocTarget, boolean insertBefore, TocObject targetParent) {
        TocObject[] tocObjects = objectsToAdd.toArray(new TocObject[objectsToAdd.size()]);
        if (tocObjects == null) {
            return;
        }
        TocObject[] tocObjectArray = tocObjects;
        int n = tocObjects.length;
        int n2 = 0;
        while (n2 < n) {
            TocObject tocObject = tocObjectArray[n2];
            if (tocObject != null && targetParent != null && targetParent.canBeParent()) {
                if (tocTarget != null && tocTarget != targetParent) {
                    ((TocTopic)targetParent).addChild(tocObject, tocTarget, insertBefore);
                } else {
                    ((TocTopic)targetParent).addChild(tocObject);
                }
            }
            ++n2;
        }
    }

    private void handleDeleteAction() {
        ArrayList<TocObject> objects = new ArrayList<TocObject>(this.fTocTree.getStructuredSelection().toList());
        boolean beep = false;
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            TocObject tocObject;
            Object object = i.next();
            if (!(object instanceof TocObject) || (tocObject = (TocObject)object).canBeRemoved()) continue;
            i.remove();
            beep = true;
        }
        if (beep) {
            Display.getCurrent().beep();
        }
        this.handleRemove(objects);
    }

    public void handleRemove(List<TocObject> itemsToRemove) {
        if (!itemsToRemove.isEmpty()) {
            this.fRemoveObjectAction.setToRemove(itemsToRemove.toArray(new TocObject[itemsToRemove.size()]));
            this.fRemoveObjectAction.run();
        }
    }

    public void handleDrag(List<TocObject> itemsDragged) {
        this.handleRemove(itemsDragged);
        this.fDragFromHere = false;
    }

    private void handleMoveAction(int positionFlag) {
        ITreeSelection sel = this.fTocTree.getStructuredSelection();
        for (Object object : sel) {
            TocObject tocObject;
            TocTopic parent;
            if (object == null) {
                return;
            }
            if (!(object instanceof TocObject) || (parent = (TocTopic)(tocObject = (TocObject)object).getParent()) == null) continue;
            parent.moveChild(tocObject, positionFlag);
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.handleModelEventWorldChanged(event);
        } else if (event.getChangeType() == 1) {
            this.handleModelInsertType(event);
        } else if (event.getChangeType() == 2) {
            this.handleModelRemoveType(event);
        } else if (event.getChangeType() == 3 && event.getChangedProperty().equals("type_swap")) {
            this.handleModelChangeTypeSwap(event);
        } else if (event.getChangeType() == 3) {
            this.handleModelChangeType(event);
        }
    }

    private void handleModelChangeTypeSwap(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        TocObject object = (TocObject)objects[0];
        if (object != null) {
            this.fTocTree.refresh((Object)object);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.markStale();
    }

    private void handleModelInsertType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        TocObject object = (TocObject)objects[0];
        if (object != null && object.getType() != 0) {
            this.fTocTree.refresh((Object)object.getParent());
            this.fTocTree.setSelection((ISelection)new StructuredSelection((Object)object), true);
        }
    }

    private void handleModelRemoveType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        TocObject object = (TocObject)objects[0];
        if (object != null && object.getType() != 0) {
            this.handleTaskObjectRemove(object);
        }
    }

    private void handleTaskObjectRemove(TocObject object) {
        this.fTocTree.remove((Object)object);
        TocObject tocObject = this.fRemoveObjectAction.getNextSelection();
        if (tocObject == null) {
            tocObject = object.getParent();
        }
        if (tocObject.equals(object.getParent())) {
            this.fTocTree.refresh((Object)object.getParent());
        }
        if (!this.fDragFromHere) {
            this.fTocTree.setSelection((ISelection)new StructuredSelection((Object)tocObject), true);
        }
    }

    private void handleModelChangeType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        TocObject object = (TocObject)objects[0];
        if (object != null) {
            this.fTocTree.update((Object)object, null);
        }
    }

    public void refresh() {
        TocModel model = (TocModel)this.getPage().getModel();
        ISelection selection = this.fTocTree.getSelection();
        this.fTocTree.setInput((Object)model);
        this.fTocTree.expandToLevel(2);
        this.fTocTree.setSelection(selection, true);
        this.getManagedForm().fireSelectionChanged((IFormPart)this, this.fTocTree.getSelection());
        super.refresh();
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        this.fFilteredTree = new FormFilteredTree(parent, style, new PatternFilter());
        parent.setData("filtered", (Object)Boolean.TRUE);
        return this.fFilteredTree.getViewer();
    }

    public void dispose() {
        PDEUserAssistanceUIPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    private class TocOpenLinkAction
    extends Action {
        private TocObject fOpenTarget;

        public TocOpenLinkAction() {
            this.setText(TocMessages.TocTreeSection_open);
        }

        public void setTarget(TocObject target) {
            this.fOpenTarget = target;
        }

        public void run() {
            if (this.fOpenTarget != null) {
                TocTreeSection.this.open(this.fOpenTarget);
            }
        }
    }
}

