/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util.swt.rap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rcptt.util.KeysAndButtons;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;

public class Events {
    public static final int DEFAULT_BUTTON = 1;
    public static final int NO_BUTTON = 0;
    public static final int EMPTY_MASK = 0;
    public static final int SINGLE_COUNT = 1;
    public static final int ZERO_COUNT = 0;

    public static Event[] createDoubleClick() {
        return Events.createDoubleClick(0, 0);
    }

    public static Event[] createDoubleClick(Point point) {
        return Events.createDoubleClick(point.x, point.y);
    }

    public static Event[] createDoubleClick(int x, int y) {
        return Events.createDoubleClick(1, 0, x, y);
    }

    public static Event[] createDoubleClick(int button, int mask, int x, int y) {
        ArrayList<Event> result = new ArrayList<Event>();
        result.add(Events.createMouseEnter(mask, x, y));
        result.addAll(Events.modifiersDown(mask));
        result.add(Events.createMouseDown(button, 1, mask, x, y));
        result.add(Events.createMouseUp(button, 1, mask, x, y));
        result.add(Events.createMouseDown(button, 2, mask, x, y));
        result.add(Events.createMouseDoubleClick(button, mask, x, y));
        result.add(Events.createMouseUp(button, 2, mask, x, y));
        result.addAll(Events.modifiersDown(mask));
        result.add(Events.createSelection(true));
        return result.toArray(new Event[result.size()]);
    }

    public static List<Event> modifiersUp(int stateMask) {
        int currentMask = stateMask;
        ArrayList<Event> result = new ArrayList<Event>();
        stateMask = SWT.MODIFIER_MASK & stateMask;
        int[] nArray = KeysAndButtons.getReverseModifiers();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int modifier = nArray[n2];
            if ((stateMask & modifier) != 0) {
                Event event = new Event();
                event.type = 2;
                event.keyCode = modifier;
                event.stateMask = currentMask;
                currentMask ^= modifier;
                result.add(event);
            }
            ++n2;
        }
        return result;
    }

    public static List<Event> modifiersDown(int stateMask) {
        ArrayList<Event> result = new ArrayList<Event>();
        stateMask = SWT.MODIFIER_MASK & stateMask;
        int currentMask = 0;
        int[] nArray = KeysAndButtons.getOrderedModifiers();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int modifier = nArray[n2];
            if ((stateMask & modifier) != 0) {
                Event event = new Event();
                event.type = 1;
                event.keyCode = modifier;
                event.stateMask = currentMask;
                currentMask |= modifier;
                result.add(event);
            }
            ++n2;
        }
        return result;
    }

    public static Event[] createClick(Point point) {
        return Events.createClick(point.x, point.y);
    }

    public static Event[] createClick(int x, int y) {
        return Events.createClick(1, 0, x, y);
    }

    public static Event[] createClick(int button, int mask, int x, int y) {
        ArrayList<Event> result = new ArrayList<Event>();
        result.add(Events.createMouseEnter(mask, x, y));
        result.addAll(Events.modifiersDown(mask));
        result.add(Events.createMouseDown(button, 1, mask, x, y));
        result.add(Events.createMouseUp(button, 1, mask, x, y));
        result.addAll(Events.modifiersUp(mask));
        return result.toArray(new Event[result.size()]);
    }

    public static Event createActivate() {
        return Events.createSimple(26);
    }

    public static Event createDeactivate() {
        return Events.createSimple(27);
    }

    public static Event createFocusIn() {
        return Events.createSimple(15);
    }

    public static Event createFocusOut() {
        return Events.createSimple(16);
    }

    public static Event createSelection() {
        return Events.createSelection(false);
    }

    public static Event createSelection(boolean isDefault) {
        return Events.createSimple(isDefault ? 14 : 13);
    }

    public static Event createSimple(int type) {
        Event event = new Event();
        event.type = type;
        return event;
    }

    public static Event createMouseEnter(int mask, int x, int y) {
        return Events.createMouseEvent(6, 0, 0, mask, x, y);
    }

    public static Event createMouseMove(int mask, int x, int y) {
        return Events.createMouseEvent(5, 0, 0, mask, x, y);
    }

    public static Event createMouseExit(int mask, int x, int y) {
        return Events.createMouseEvent(7, 0, 0, mask, x, y);
    }

    public static Event createMouseDown(int button, int count, int mask, int x, int y) {
        return Events.createMouseEvent(3, button, count, mask, x, y);
    }

    public static Event createMouseDown() {
        return Events.createMouseDown(new Point(0, 0));
    }

    public static Event createMouseDown(Point point) {
        return Events.createMouseDown(1, 1, 0, point.x, point.y);
    }

    public static Event createMouseUp() {
        return Events.createMouseUp(new Point(0, 0));
    }

    public static Event createMouseUp(Point point) {
        return Events.createMouseUp(1, 1, 0, point.x, point.y);
    }

    public static Event createMouseUp(int button, int count, int mask, int x, int y) {
        return Events.createMouseEvent(4, button, count, mask | KeysAndButtons.getButtonMaskSafe((int)button), x, y);
    }

    public static Event createMouseDoubleClick(int button, int mask, int x, int y) {
        return Events.createMouseEvent(8, button, 2, mask, x, y);
    }

    public static Event createMouseEvent(int type, int button, int count, int mask, int x, int y) {
        Event event = new Event();
        event.type = type;
        event.button = button;
        event.count = count;
        event.stateMask = mask;
        event.x = x;
        event.y = y;
        return event;
    }

    public static Point pointFrom(Event event) {
        return new Point(event.x, event.y);
    }
}

