/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.operations.internal.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Let;
import org.eclipse.rcptt.ecl.core.Val;
import org.eclipse.rcptt.ecl.operations.Repeat;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class RepeatService
implements ICommandService {
    public IStatus service(Command command, IProcess process) throws InterruptedException, CoreException {
        Repeat t = (Repeat)command;
        int times = t.getTimes();
        int delay = t.getDelay();
        if (delay < 0) {
            return new Status(4, "org.eclipse.rcptt.ecl.core", "Illegal parameter 'delay'");
        }
        if (times <= 0) {
            return new Status(4, "org.eclipse.rcptt.ecl.core", "Illegal parameter 'times'");
        }
        List content = CoreUtils.readPipeContent((IPipe)process.getInput());
        IStatus status = Status.OK_STATUS;
        Val indexVal = t.getIndex();
        ArrayList contentOutput = new ArrayList();
        int i = 0;
        while (i < times) {
            IPipe input = process.getSession().createPipe();
            for (Object o : content) {
                input.write(o);
            }
            input.close(Status.OK_STATUS);
            IPipe output = process.getSession().createPipe();
            IProcess doProcess = process.getSession().execute(RepeatService.wrapBody(i, indexVal, t.getCommand()), input, output);
            status = doProcess.waitFor();
            if (!status.isOK()) break;
            contentOutput.addAll(CoreUtils.readPipeContent((IPipe)output));
            if (delay > 0) {
                Thread.sleep(delay);
            }
            ++i;
        }
        if (status.isOK()) {
            for (Object o : contentOutput) {
                process.getOutput().write(o);
            }
        }
        return status;
    }

    private static Command wrapBody(int i, Val indexVal, Command body) {
        Let let = CoreFactory.eINSTANCE.createLet();
        let.setBody(body);
        if (indexVal != null) {
            indexVal.setValue((EObject)BoxedValues.box((int)i));
            let.getVals().add((Object)indexVal);
        }
        return let;
    }
}

