/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl.actions;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.rcptt.ui.editors.ecl.actions.EclTextNavigationAction;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;

public class LineStartAction
extends EclTextNavigationAction {
    protected final boolean fDoSelect;

    public LineStartAction(EclEditor editor, StyledText textWidget, boolean doSelect) {
        super(editor, textWidget, 0x1000007);
        this.fDoSelect = doSelect;
    }

    protected int getLineStartPosition(IDocument document, String line, int length, int offset) {
        LinkedPosition linkedPosition;
        int index = 0;
        while (index < length && Character.isWhitespace(line.charAt(index))) {
            ++index;
        }
        LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)offset);
        if (model != null && (linkedPosition = model.findPosition(new LinkedPosition(document, offset, 0))) != null) {
            int linkedPositionOffset = linkedPosition.getOffset();
            try {
                int lineOffset = document.getLineInformationOfOffset(offset).getOffset();
                if (offset != linkedPositionOffset && index < linkedPositionOffset - lineOffset) {
                    index = linkedPositionOffset - lineOffset;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return index;
    }

    @Override
    public void internalRun(TextViewer viewer) {
        int lineLength;
        int caretOffsetInDocument;
        StyledText st;
        boolean isSmartHomeEndEnabled = false;
        IPreferenceStore store = this.eclEditor.doGetPreferenceStore();
        if (store != null) {
            isSmartHomeEndEnabled = store.getBoolean("AbstractTextEditor.Navigation.SmartHomeEnd");
        }
        if ((st = viewer.getTextWidget()) == null || st.isDisposed()) {
            return;
        }
        int caretOffset = st.getCaretOffset();
        int lineNumber = st.getLineAtOffset(caretOffset);
        int lineOffset = st.getOffsetAtLine(lineNumber);
        IDocument document = viewer.getDocument();
        try {
            caretOffsetInDocument = this.eclEditor.doWidgetOffset2ModelOffset(viewer, caretOffset);
            lineLength = document.getLineInformationOfOffset(caretOffsetInDocument).getLength();
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        String line = "";
        if (lineLength > 0) {
            int end = lineOffset + lineLength - 1;
            end = Math.min(end, st.getCharCount() - 1);
            line = st.getText(lineOffset, end);
        }
        Point oldSelection = st.getSelection();
        int newCaretOffset = -1;
        if (isSmartHomeEndEnabled) {
            int index = this.getLineStartPosition(document, line, lineLength, caretOffsetInDocument);
            newCaretOffset = caretOffset - lineOffset == index ? lineOffset : lineOffset + index;
        } else if (caretOffset > lineOffset) {
            newCaretOffset = lineOffset;
        }
        if (newCaretOffset == -1) {
            newCaretOffset = caretOffset;
        } else {
            st.setCaretOffset(newCaretOffset);
        }
        if (this.fDoSelect) {
            if (caretOffset < oldSelection.y) {
                st.setSelection(oldSelection.y, newCaretOffset);
            } else {
                st.setSelection(oldSelection.x, newCaretOffset);
            }
        } else {
            st.setSelection(newCaretOffset);
        }
        this.fireSelectionChanged(oldSelection);
    }
}

