/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.impl.Utils;
import org.eclipse.rcptt.tesla.internal.core.queue.TeslaQClient;
import org.eclipse.rcptt.tesla.internal.ui.player.ReportScreenshotProvider;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.UIJobCollector;
import org.eclipse.rcptt.tesla.swt.events.ITeslaEventListener;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class UIRunnable<T> {
    public static <T> T exec(final UIRunnable<T> runnable) throws CoreException {
        final Object[] result = new Object[1];
        final AtomicReference<RunningState> processed = new AtomicReference<RunningState>(RunningState.Starting);
        final Throwable[] exception = new Throwable[1];
        final UIJobCollector collector = new UIJobCollector();
        final Display display = PlatformUI.getWorkbench().getDisplay();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)collector);
        collector.enable();
        ITeslaEventListener listener = null;
        final IStatus[] dialogCloseStatus = new IStatus[1];
        try {
            try {
                listener = new ITeslaEventListener(){

                    public synchronized boolean doProcessing(ContextManagement.Context currentContext) {
                        boolean tick = processed.get().equals((Object)RunningState.Starting) || processed.get().equals((Object)RunningState.Execution);
                        Q7WaitInfoRoot info = TeslaBridge.getCurrentWaitInfo(tick);
                        boolean resultValue = true;
                        if (!PlatformUI.getWorkbench().getDisplay().equals(Display.getCurrent())) {
                            resultValue = false;
                        }
                        if (SWTUIPlayer.hasTimers((Display)display, (Q7WaitInfoRoot)info)) {
                            resultValue = false;
                        }
                        if (SWTUIPlayer.hasRunnables((Display)display)) {
                            resultValue = false;
                        }
                        if (!collector.isEmpty(currentContext, info)) {
                            resultValue = false;
                        }
                        if (!resultValue) {
                            return false;
                        }
                        if (processed.get().equals((Object)RunningState.Starting)) {
                            processed.set(RunningState.Execution);
                            try {
                                result[0] = runnable.run();
                            }
                            catch (Throwable e) {
                                exception[0] = e;
                                collector.setNeedDisable();
                                processed.set(RunningState.Finished);
                                return true;
                            }
                            processed.set(RunningState.Done);
                            return true;
                        }
                        if (processed.get().equals((Object)RunningState.Done)) {
                            collector.setNeedDisable();
                            processed.set(RunningState.Finished);
                            return true;
                        }
                        return false;
                    }

                    public void hasEvent(TeslaEventManager.HasEventKind kind, String run) {
                    }
                };
                TeslaEventManager.getManager().addEventListener(listener);
                long start = System.currentTimeMillis();
                while (!((Object)((Object)processed.get())).equals((Object)RunningState.Finished)) {
                    if (display.isDisposed()) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                    SWTUIPlayer.notifyUI((Display)display);
                    Thread.sleep(1L);
                    if (exception[0] != null) {
                        if (exception[0] instanceof CoreException) {
                            throw (CoreException)exception[0];
                        }
                        throw new CoreException(UIRunnable.createError(exception[0]));
                    }
                    long time = System.currentTimeMillis();
                    if (time > start + (long)(UIRunnable.getTimeout() / 2) && ((Object)((Object)processed.get())).equals((Object)RunningState.Starting)) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                dialogCloseStatus[0] = Utils.closeDialogs();
                            }
                        });
                        collector.clean();
                    }
                    if (time <= start + (long)UIRunnable.getTimeout()) continue;
                    UIRunnable.storeTimeoutInReport(display, collector);
                    MultiStatus status = new MultiStatus("org.eclipse.rcptt.tesla.ecl.impl", 123130, "Timeout during execution of " + runnable, null){
                        {
                            this.setSeverity(4);
                        }
                    };
                    if (dialogCloseStatus[0] != null) {
                        status.add(dialogCloseStatus[0]);
                    }
                    throw new CoreException((IStatus)status);
                }
                long timeoutLeft = System.currentTimeMillis() - start;
                long timeLeft = (long)UIRunnable.getTimeout() - timeoutLeft;
                if (timeLeft < 0L) {
                    timeLeft = 5000L;
                }
                collector.join(timeLeft);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
        catch (Throwable throwable) {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)collector);
            TeslaEventManager.getManager().removeEventListener(listener);
            throw throwable;
        }
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)collector);
        TeslaEventManager.getManager().removeEventListener(listener);
        return (T)result[0];
    }

    private static IStatus createError(Throwable exception) {
        return new Status(4, "org.eclipse.rcptt.tesla.ecl.impl", exception.getMessage(), exception);
    }

    private static int getTimeout() {
        return TeslaLimits.getContextRunnableTimeout();
    }

    private static void storeTimeoutInReport(final Display display, UIJobCollector collector) throws InterruptedException {
        ReportManager.getBuilder();
        boolean[] cfr_ignored_0 = new boolean[1];
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                TeslaQClient client = TeslaBridge.getClient();
                if (client != null) {
                    client.collectLastFailureInformation();
                }
                ReportScreenshotProvider.takeScreenshot((Display)display, (boolean)true, (String)"timeout");
            }
        });
    }

    public static <T> T safeExec(UIRunnable<T> runnable) {
        try {
            return UIRunnable.exec(runnable);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public abstract T run() throws CoreException;

    private static enum RunningState {
        Starting,
        Execution,
        Done,
        Finished;

    }
}

