/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.gtk.OS;

public final class Converter {
    public static final byte[] NullByteArray = new byte[1];
    public static final byte[] EmptyByteArray = new byte[0];
    public static final char[] EmptyCharArray = new char[0];

    public static char[] mbcsToWcs(byte[] buffer) {
        int[] items_written = new int[1];
        int ptr = OS.g_utf8_to_utf16(buffer, buffer.length, null, items_written, null);
        if (ptr == 0) {
            return EmptyCharArray;
        }
        int length = items_written[0];
        char[] chars = new char[length];
        C.memmove(chars, ptr, length * 2);
        OS.g_free(ptr);
        return chars;
    }

    public static byte[] wcsToMbcs(String string, boolean terminate) {
        int length = string.length();
        char[] buffer = new char[length];
        string.getChars(0, length, buffer, 0);
        return Converter.wcsToMbcs(buffer, terminate);
    }

    public static byte[] javaStringToCString(String string) {
        return Converter.wcsToMbcs(string, true);
    }

    public static String cCharPtrToJavaString(int cCharPtr, boolean freecCharPtr) {
        int length = C.strlen(cCharPtr);
        byte[] buffer = new byte[length];
        C.memmove(buffer, cCharPtr, length);
        if (freecCharPtr) {
            OS.g_free(cCharPtr);
        }
        return new String(Converter.mbcsToWcs(buffer));
    }

    public static byte[] wcsToMbcs(char[] chars, boolean terminate) {
        int[] items_read = new int[1];
        int[] items_written = new int[1];
        int ptr = OS.g_utf16_to_utf8(chars, chars.length, items_read, items_written, null);
        if (ptr == 0) {
            return terminate ? NullByteArray : EmptyByteArray;
        }
        int written = items_written[0];
        byte[] bytes = new byte[written + (terminate ? 1 : 0)];
        C.memmove(bytes, ptr, written);
        OS.g_free(ptr);
        return bytes;
    }

    public static char wcsToMbcs(char ch) {
        int key = ch & 0xFFFF;
        if (key <= 127) {
            return ch;
        }
        byte[] buffer = Converter.wcsToMbcs(new char[]{ch}, false);
        if (buffer.length == 1) {
            return (char)buffer[0];
        }
        if (buffer.length == 2) {
            return (char)((buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF);
        }
        return '\u0000';
    }

    public static char mbcsToWcs(char ch) {
        int key = ch & 0xFFFF;
        if (key <= 127) {
            return ch;
        }
        byte[] buffer = key <= 255 ? new byte[]{(byte)key} : new byte[]{(byte)(key >> 8 & 0xFF), (byte)(key & 0xFF)};
        char[] result = Converter.mbcsToWcs(buffer);
        if (result.length == 0) {
            return '\u0000';
        }
        return result[0];
    }
}

