/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.CachedObjectDirectory;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LocalObjectRepresentation;
import org.eclipse.jgit.internal.storage.file.ObjectDirectoryInserter;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackInserter;
import org.eclipse.jgit.internal.storage.file.UnpackedObject;
import org.eclipse.jgit.internal.storage.file.UnpackedObjectCache;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDirectory
extends FileObjectDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectDirectory.class);
    private static final PackList NO_PACKS = new PackList(FileSnapshot.DIRTY, new PackFile[0]);
    private static final int RESOLVE_ABBREV_LIMIT = 256;
    private final AlternateHandle handle = new AlternateHandle(this);
    private final Config config;
    private final File objects;
    private final File infoDirectory;
    private final File packDirectory;
    private final File preservedDirectory;
    private final File alternatesFile;
    private final AtomicReference<PackList> packList;
    private final FS fs;
    private final AtomicReference<AlternateHandle[]> alternates;
    private final UnpackedObjectCache unpackedObjectCache;
    private final File shallowFile;
    private FileSnapshot shallowFileSnapshot = FileSnapshot.DIRTY;
    private Set<ObjectId> shallowCommitsIds;

    public ObjectDirectory(Config cfg, File dir, File[] alternatePaths, FS fs, File shallowFile) throws IOException {
        this.config = cfg;
        this.objects = dir;
        this.infoDirectory = new File(this.objects, "info");
        this.packDirectory = new File(this.objects, "pack");
        this.preservedDirectory = new File(this.packDirectory, "preserved");
        this.alternatesFile = new File(this.infoDirectory, "alternates");
        this.packList = new AtomicReference<PackList>(NO_PACKS);
        this.unpackedObjectCache = new UnpackedObjectCache();
        this.fs = fs;
        this.shallowFile = shallowFile;
        this.alternates = new AtomicReference();
        if (alternatePaths != null) {
            AlternateHandle[] alt = new AlternateHandle[alternatePaths.length];
            int i = 0;
            while (i < alternatePaths.length) {
                alt[i] = this.openAlternate(alternatePaths[i]);
                ++i;
            }
            this.alternates.set(alt);
        }
    }

    @Override
    public final File getDirectory() {
        return this.objects;
    }

    public final File getPackDirectory() {
        return this.packDirectory;
    }

    public final File getPreservedDirectory() {
        return this.preservedDirectory;
    }

    @Override
    public boolean exists() {
        return this.fs.exists(this.objects);
    }

    @Override
    public void create() throws IOException {
        FileUtils.mkdirs(this.objects);
        FileUtils.mkdir(this.infoDirectory);
        FileUtils.mkdir(this.packDirectory);
    }

    @Override
    public ObjectDirectoryInserter newInserter() {
        return new ObjectDirectoryInserter(this, this.config);
    }

    public PackInserter newPackInserter() {
        return new PackInserter(this);
    }

    @Override
    public void close() {
        AlternateHandle[] alt;
        int n;
        this.unpackedObjectCache.clear();
        PackList packs = this.packList.get();
        if (packs != NO_PACKS && this.packList.compareAndSet(packs, NO_PACKS)) {
            PackFile[] packFileArray = packs.packs;
            n = packs.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                p.close();
                ++n2;
            }
        }
        if ((alt = this.alternates.get()) != null && this.alternates.compareAndSet(alt, null)) {
            AlternateHandle[] alternateHandleArray = alt;
            int n3 = alt.length;
            n = 0;
            while (n < n3) {
                AlternateHandle od = alternateHandleArray[n];
                od.close();
                ++n;
            }
        }
    }

    @Override
    public Collection<PackFile> getPacks() {
        PackList list = this.packList.get();
        if (list == NO_PACKS) {
            list = this.scanPacks(list);
        }
        PackFile[] packs = list.packs;
        return Collections.unmodifiableCollection(Arrays.asList(packs));
    }

    @Override
    public PackFile openPack(File pack) throws IOException {
        String p = pack.getName();
        if (p.length() != 50 || !p.startsWith("pack-") || !p.endsWith(".pack")) {
            throw new IOException(MessageFormat.format(JGitText.get().notAValidPack, pack));
        }
        int extensions = PackExt.PACK.getBit() | PackExt.INDEX.getBit();
        String base = p.substring(0, p.length() - 4);
        PackExt[] packExtArray = PackExt.values();
        int n = packExtArray.length;
        int n2 = 0;
        while (n2 < n) {
            PackExt ext = packExtArray[n2];
            if ((extensions & ext.getBit()) == 0) {
                String name = String.valueOf(base) + ext.getExtension();
                if (new File(pack.getParentFile(), name).exists()) {
                    extensions |= ext.getBit();
                }
            }
            ++n2;
        }
        PackFile res = new PackFile(pack, extensions);
        this.insertPack(res);
        return res;
    }

    public String toString() {
        return "ObjectDirectory[" + this.getDirectory() + "]";
    }

    @Override
    public boolean has(AnyObjectId objectId) {
        return this.unpackedObjectCache.isUnpacked(objectId) || this.hasPackedInSelfOrAlternate(objectId, null) || this.hasLooseInSelfOrAlternate(objectId, null);
    }

    private boolean hasPackedInSelfOrAlternate(AnyObjectId objectId, Set<AlternateHandle.Id> skips) {
        if (this.hasPackedObject(objectId)) {
            return true;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && alt.db.hasPackedInSelfOrAlternate(objectId, skips)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasLooseInSelfOrAlternate(AnyObjectId objectId, Set<AlternateHandle.Id> skips) {
        if (this.fileFor(objectId).exists()) {
            return true;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && alt.db.hasLooseInSelfOrAlternate(objectId, skips)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean hasPackedObject(AnyObjectId objectId) {
        PackList pList;
        do {
            pList = this.packList.get();
            PackFile[] packFileArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                try {
                    if (p.hasObject(objectId)) {
                        return true;
                    }
                }
                catch (IOException e) {
                    this.removePack(p);
                }
                ++n2;
            }
        } while (this.searchPacksAgain(pList));
        return false;
    }

    @Override
    void resolve(Set<ObjectId> matches, AbbreviatedObjectId id) throws IOException {
        this.resolve(matches, id, null);
    }

    private void resolve(Set<ObjectId> matches, AbbreviatedObjectId id, Set<AlternateHandle.Id> skips) throws IOException {
        Object[] objectArray;
        PackList pList;
        int oldSize = matches.size();
        do {
            pList = this.packList.get();
            PackFile[] packFileArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                try {
                    p.resolve(matches, id, 256);
                    p.resetTransientErrorCount();
                }
                catch (IOException e) {
                    this.handlePackError(e, p);
                }
                if (matches.size() > 256) {
                    return;
                }
                ++n2;
            }
        } while (matches.size() == oldSize && this.searchPacksAgain(pList));
        String fanOut = id.name().substring(0, 2);
        String[] entries = new File(this.getDirectory(), fanOut).list();
        if (entries != null) {
            objectArray = entries;
            int n = entries.length;
            int n3 = 0;
            while (n3 < n) {
                block15: {
                    Object e = objectArray[n3];
                    if (((String)e).length() == 38) {
                        block14: {
                            try {
                                ObjectId entId = ObjectId.fromString(String.valueOf(fanOut) + (String)e);
                                if (id.prefixCompare(entId) != 0) break block14;
                                matches.add(entId);
                            }
                            catch (IllegalArgumentException notId) {
                                break block15;
                            }
                        }
                        if (matches.size() > 256) {
                            return;
                        }
                    }
                }
                ++n3;
            }
        }
        skips = this.addMe(skips);
        objectArray = this.myAlternates();
        int n = objectArray.length;
        int n4 = 0;
        while (n4 < n) {
            Object alt = objectArray[n4];
            if (!skips.contains(((AlternateHandle)alt).getId())) {
                ((AlternateHandle)alt).db.resolve(matches, id, skips);
                if (matches.size() > 256) {
                    return;
                }
            }
            ++n4;
        }
    }

    @Override
    ObjectLoader openObject(WindowCursor curs, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr;
        if (this.unpackedObjectCache.isUnpacked(objectId) && (ldr = this.openLooseObject(curs, objectId)) != null) {
            return ldr;
        }
        ldr = this.openPackedFromSelfOrAlternate(curs, objectId, null);
        if (ldr != null) {
            return ldr;
        }
        return this.openLooseFromSelfOrAlternate(curs, objectId, null);
    }

    private ObjectLoader openPackedFromSelfOrAlternate(WindowCursor curs, AnyObjectId objectId, Set<AlternateHandle.Id> skips) {
        ObjectLoader ldr = this.openPackedObject(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && (ldr = alt.db.openPackedFromSelfOrAlternate(curs, objectId, skips)) != null) {
                return ldr;
            }
            ++n2;
        }
        return null;
    }

    private ObjectLoader openLooseFromSelfOrAlternate(WindowCursor curs, AnyObjectId objectId, Set<AlternateHandle.Id> skips) throws IOException {
        ObjectLoader ldr = this.openLooseObject(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && (ldr = alt.db.openLooseFromSelfOrAlternate(curs, objectId, skips)) != null) {
                return ldr;
            }
            ++n2;
        }
        return null;
    }

    ObjectLoader openPackedObject(WindowCursor curs, AnyObjectId objectId) {
        block3: while (true) {
            PackList pList = this.packList.get();
            PackFile[] packFileArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                try {
                    ObjectLoader ldr = p.get(curs, objectId);
                    p.resetTransientErrorCount();
                    if (ldr != null) {
                        return ldr;
                    }
                }
                catch (PackMismatchException e) {
                    if (this.searchPacksAgain(pList)) {
                        continue block3;
                    }
                }
                catch (IOException e) {
                    this.handlePackError(e, p);
                }
                ++n2;
            }
            if (!this.searchPacksAgain(pList)) break;
        }
        return null;
    }

    @Override
    ObjectLoader openLooseObject(WindowCursor curs, AnyObjectId id) throws IOException {
        File path = this.fileFor(id);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream in = new FileInputStream(path);){
                this.unpackedObjectCache.add(id);
                return UnpackedObject.open(in, path, id, curs);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException noFile) {
            if (path.exists()) {
                throw noFile;
            }
            this.unpackedObjectCache.remove(id);
            return null;
        }
    }

    @Override
    long getObjectSize(WindowCursor curs, AnyObjectId id) throws IOException {
        long len;
        if (this.unpackedObjectCache.isUnpacked(id) && 0L <= (len = this.getLooseObjectSize(curs, id))) {
            return len;
        }
        len = this.getPackedSizeFromSelfOrAlternate(curs, id, null);
        if (0L <= len) {
            return len;
        }
        return this.getLooseSizeFromSelfOrAlternate(curs, id, null);
    }

    private long getPackedSizeFromSelfOrAlternate(WindowCursor curs, AnyObjectId id, Set<AlternateHandle.Id> skips) {
        long len = this.getPackedObjectSize(curs, id);
        if (0L <= len) {
            return len;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && 0L <= (len = alt.db.getPackedSizeFromSelfOrAlternate(curs, id, skips))) {
                return len;
            }
            ++n2;
        }
        return -1L;
    }

    private long getLooseSizeFromSelfOrAlternate(WindowCursor curs, AnyObjectId id, Set<AlternateHandle.Id> skips) throws IOException {
        long len = this.getLooseObjectSize(curs, id);
        if (0L <= len) {
            return len;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && 0L <= (len = alt.db.getLooseSizeFromSelfOrAlternate(curs, id, skips))) {
                return len;
            }
            ++n2;
        }
        return -1L;
    }

    private long getPackedObjectSize(WindowCursor curs, AnyObjectId id) {
        block3: while (true) {
            PackList pList = this.packList.get();
            PackFile[] packFileArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                try {
                    long len = p.getObjectSize(curs, id);
                    p.resetTransientErrorCount();
                    if (0L <= len) {
                        return len;
                    }
                }
                catch (PackMismatchException e) {
                    if (this.searchPacksAgain(pList)) {
                        continue block3;
                    }
                }
                catch (IOException e) {
                    this.handlePackError(e, p);
                }
                ++n2;
            }
            if (!this.searchPacksAgain(pList)) break;
        }
        return -1L;
    }

    private long getLooseObjectSize(WindowCursor curs, AnyObjectId id) throws IOException {
        File f = this.fileFor(id);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream in = new FileInputStream(f);){
                this.unpackedObjectCache.add(id);
                return UnpackedObject.getSize(in, id, curs);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException noFile) {
            if (f.exists()) {
                throw noFile;
            }
            this.unpackedObjectCache.remove(id);
            return -1L;
        }
    }

    @Override
    void selectObjectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs) throws IOException {
        this.selectObjectRepresentation(packer, otp, curs, null);
    }

    private void selectObjectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs, Set<AlternateHandle.Id> skips) throws IOException {
        int n;
        int n2;
        Object[] objectArray;
        PackList pList = this.packList.get();
        block3: while (true) {
            objectArray = pList.packs;
            n2 = pList.packs.length;
            n = 0;
            while (n < n2) {
                PackFile p = objectArray[n];
                try {
                    LocalObjectRepresentation rep = p.representation(curs, otp);
                    p.resetTransientErrorCount();
                    if (rep != null) {
                        packer.select(otp, rep);
                    }
                }
                catch (PackMismatchException e) {
                    pList = this.scanPacks(pList);
                    continue block3;
                }
                catch (IOException e) {
                    this.handlePackError(e, p);
                }
                ++n;
            }
            break;
        }
        skips = this.addMe(skips);
        objectArray = this.myAlternates();
        n2 = objectArray.length;
        n = 0;
        while (n < n2) {
            Object h = objectArray[n];
            if (!skips.contains(((AlternateHandle)h).getId())) {
                ((AlternateHandle)h).db.selectObjectRepresentation(packer, otp, curs, skips);
            }
            ++n;
        }
    }

    private void handlePackError(IOException e, PackFile p) {
        String warnTmpl = null;
        int transientErrorCount = 0;
        String errTmpl = JGitText.get().exceptionWhileReadingPack;
        if (e instanceof CorruptObjectException || e instanceof PackInvalidException) {
            warnTmpl = JGitText.get().corruptPack;
            this.removePack(p);
        } else if (e instanceof FileNotFoundException) {
            if (p.getPackFile().exists()) {
                errTmpl = JGitText.get().packInaccessible;
                transientErrorCount = p.incrementTransientErrorCount();
            } else {
                warnTmpl = JGitText.get().packWasDeleted;
                this.removePack(p);
            }
        } else if (FileUtils.isStaleFileHandleInCausalChain(e)) {
            warnTmpl = JGitText.get().packHandleIsStale;
            this.removePack(p);
        } else {
            transientErrorCount = p.incrementTransientErrorCount();
        }
        if (warnTmpl != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(MessageFormat.format(warnTmpl, p.getPackFile().getAbsolutePath()), (Throwable)e);
            } else {
                LOG.warn(MessageFormat.format(warnTmpl, p.getPackFile().getAbsolutePath()));
            }
        } else if (this.doLogExponentialBackoff(transientErrorCount)) {
            LOG.error(MessageFormat.format(errTmpl, p.getPackFile().getAbsolutePath()), (Object)transientErrorCount, (Object)e);
        }
    }

    private boolean doLogExponentialBackoff(int n) {
        return (n & n - 1) == 0;
    }

    @Override
    FileObjectDatabase.InsertLooseObjectResult insertUnpackedObject(File tmp, ObjectId id, boolean createDuplicate) throws IOException {
        if (this.unpackedObjectCache.isUnpacked(id)) {
            FileUtils.delete(tmp, 2);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_LOOSE;
        }
        if (!createDuplicate && this.has(id)) {
            FileUtils.delete(tmp, 2);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_PACKED;
        }
        File dst = this.fileFor(id);
        if (dst.exists()) {
            FileUtils.delete(tmp, 2);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_LOOSE;
        }
        try {
            Files.move(FileUtils.toPath(tmp), FileUtils.toPath(dst), StandardCopyOption.ATOMIC_MOVE);
            dst.setReadOnly();
            this.unpackedObjectCache.add(id);
            return FileObjectDatabase.InsertLooseObjectResult.INSERTED;
        }
        catch (AtomicMoveNotSupportedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            // empty catch block
        }
        FileUtils.mkdir(dst.getParentFile(), true);
        try {
            Files.move(FileUtils.toPath(tmp), FileUtils.toPath(dst), StandardCopyOption.ATOMIC_MOVE);
            dst.setReadOnly();
            this.unpackedObjectCache.add(id);
            return FileObjectDatabase.InsertLooseObjectResult.INSERTED;
        }
        catch (AtomicMoveNotSupportedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        if (!createDuplicate && this.has(id)) {
            FileUtils.delete(tmp, 2);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_PACKED;
        }
        FileUtils.delete(tmp, 2);
        return FileObjectDatabase.InsertLooseObjectResult.FAILURE;
    }

    private boolean searchPacksAgain(PackList old) {
        boolean trustFolderStat = this.config.getBoolean("core", "trustfolderstat", true);
        return (!trustFolderStat || old.snapshot.isModified(this.packDirectory)) && old != this.scanPacks(old);
    }

    @Override
    Config getConfig() {
        return this.config;
    }

    @Override
    FS getFS() {
        return this.fs;
    }

    @Override
    Set<ObjectId> getShallowCommits() throws IOException {
        if (this.shallowFile == null || !this.shallowFile.isFile()) {
            return Collections.emptySet();
        }
        if (this.shallowFileSnapshot == null || this.shallowFileSnapshot.isModified(this.shallowFile)) {
            this.shallowCommitsIds = new HashSet<ObjectId>();
            Throwable throwable = null;
            Object var2_3 = null;
            try (BufferedReader reader = ObjectDirectory.open(this.shallowFile);){
                String line;
                while ((line = reader.readLine()) != null) {
                    try {
                        this.shallowCommitsIds.add(ObjectId.fromString(line));
                    }
                    catch (IllegalArgumentException ex) {
                        throw new IOException(MessageFormat.format(JGitText.get().badShallowLine, line));
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.shallowFileSnapshot = FileSnapshot.save(this.shallowFile);
        }
        return this.shallowCommitsIds;
    }

    private void insertPack(PackFile pf) {
        PackFile[] newList;
        PackList n;
        PackList o;
        do {
            o = this.packList.get();
            PackFile[] oldList = o.packs;
            String name = pf.getPackFile().getName();
            PackFile[] packFileArray = oldList;
            int n2 = oldList.length;
            int n3 = 0;
            while (n3 < n2) {
                PackFile p = packFileArray[n3];
                if (name.equals(p.getPackFile().getName())) {
                    return;
                }
                ++n3;
            }
            newList = new PackFile[1 + oldList.length];
            newList[0] = pf;
            System.arraycopy(oldList, 0, newList, 1, oldList.length);
        } while (!this.packList.compareAndSet(o, n = new PackList(o.snapshot, newList)));
    }

    private void removePack(PackFile deadPack) {
        PackFile[] newList;
        PackList n;
        PackList o;
        do {
            o = this.packList.get();
            PackFile[] oldList = o.packs;
            int j = ObjectDirectory.indexOf(oldList, deadPack);
            if (j < 0) break;
            newList = new PackFile[oldList.length - 1];
            System.arraycopy(oldList, 0, newList, 0, j);
            System.arraycopy(oldList, j + 1, newList, j, newList.length - j);
        } while (!this.packList.compareAndSet(o, n = new PackList(o.snapshot, newList)));
        deadPack.close();
    }

    private static int indexOf(PackFile[] list, PackFile pack) {
        int i = 0;
        while (i < list.length) {
            if (list[i] == pack) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackList scanPacks(PackList original) {
        AtomicReference<PackList> atomicReference = this.packList;
        synchronized (atomicReference) {
            PackList n;
            PackList o;
            do {
                if ((o = this.packList.get()) != original) {
                    return o;
                }
                n = this.scanPacksImpl(o);
                if (n != o) continue;
                return n;
            } while (!this.packList.compareAndSet(o, n));
            return n;
        }
    }

    private PackList scanPacksImpl(PackList old) {
        Map<String, PackFile> forReuse = ObjectDirectory.reuseMap(old);
        FileSnapshot snapshot = FileSnapshot.save(this.packDirectory);
        Set<String> names = this.listPackDirectory();
        ArrayList<PackFile> list = new ArrayList<PackFile>(names.size() >> 2);
        boolean foundNew = false;
        for (String indexName : names) {
            if (indexName.length() != 49 || !indexName.endsWith(".idx")) continue;
            String base = indexName.substring(0, indexName.length() - 3);
            int extensions = 0;
            PackExt[] packExtArray = PackExt.values();
            int n = packExtArray.length;
            int n2 = 0;
            while (n2 < n) {
                PackExt ext = packExtArray[n2];
                if (names.contains(String.valueOf(base) + ext.getExtension())) {
                    extensions |= ext.getBit();
                }
                ++n2;
            }
            if ((extensions & PackExt.PACK.getBit()) == 0) continue;
            String packName = String.valueOf(base) + PackExt.PACK.getExtension();
            PackFile oldPack = forReuse.remove(packName);
            if (oldPack != null) {
                list.add(oldPack);
                continue;
            }
            File packFile = new File(this.packDirectory, packName);
            list.add(new PackFile(packFile, extensions));
            foundNew = true;
        }
        if (!foundNew && forReuse.isEmpty() && snapshot.equals(old.snapshot)) {
            old.snapshot.setClean(snapshot);
            return old;
        }
        for (PackFile p : forReuse.values()) {
            p.close();
        }
        if (list.isEmpty()) {
            return new PackList(snapshot, ObjectDirectory.NO_PACKS.packs);
        }
        PackFile[] r = list.toArray(new PackFile[list.size()]);
        Arrays.sort(r, PackFile.SORT);
        return new PackList(snapshot, r);
    }

    private static Map<String, PackFile> reuseMap(PackList old) {
        HashMap<String, PackFile> forReuse = new HashMap<String, PackFile>();
        PackFile[] packFileArray = old.packs;
        int n = old.packs.length;
        int n2 = 0;
        while (n2 < n) {
            PackFile p = packFileArray[n2];
            if (p.invalid()) {
                p.close();
            } else {
                PackFile prior = forReuse.put(p.getPackFile().getName(), p);
                if (prior != null) {
                    forReuse.put(prior.getPackFile().getName(), prior);
                    p.close();
                }
            }
            ++n2;
        }
        return forReuse;
    }

    private Set<String> listPackDirectory() {
        String[] nameList = this.packDirectory.list();
        if (nameList == null) {
            return Collections.emptySet();
        }
        HashSet<String> nameSet = new HashSet<String>(nameList.length << 1);
        String[] stringArray = nameList;
        int n = nameList.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.startsWith("pack-")) {
                nameSet.add(name);
            }
            ++n2;
        }
        return nameSet;
    }

    void closeAllPackHandles(File packFile) {
        if (packFile.exists()) {
            for (PackFile p : this.getPacks()) {
                if (!packFile.getPath().equals(p.getPackFile().getPath())) continue;
                p.close();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AlternateHandle[] myAlternates() {
        AlternateHandle[] alt = this.alternates.get();
        if (alt == null) {
            AtomicReference<AlternateHandle[]> atomicReference = this.alternates;
            synchronized (atomicReference) {
                alt = this.alternates.get();
                if (alt == null) {
                    try {
                        alt = this.loadAlternates();
                    }
                    catch (IOException e) {
                        alt = new AlternateHandle[]{};
                    }
                    this.alternates.set(alt);
                }
            }
        }
        return alt;
    }

    Set<AlternateHandle.Id> addMe(Set<AlternateHandle.Id> skips) {
        if (skips == null) {
            skips = new HashSet<AlternateHandle.Id>();
        }
        skips.add(this.handle.getId());
        return skips;
    }

    private AlternateHandle[] loadAlternates() throws IOException {
        ArrayList<AlternateHandle> l = new ArrayList<AlternateHandle>(4);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = ObjectDirectory.open(this.alternatesFile);){
            String line;
            while ((line = br.readLine()) != null) {
                l.add(this.openAlternate(line));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return l.toArray(new AlternateHandle[l.size()]);
    }

    private static BufferedReader open(File f) throws FileNotFoundException {
        return new BufferedReader(new FileReader(f));
    }

    private AlternateHandle openAlternate(String location) throws IOException {
        File objdir = this.fs.resolve(this.objects, location);
        return this.openAlternate(objdir);
    }

    private AlternateHandle openAlternate(File objdir) throws IOException {
        File parent = objdir.getParentFile();
        if (RepositoryCache.FileKey.isGitRepository(parent, this.fs)) {
            RepositoryCache.FileKey key = RepositoryCache.FileKey.exact(parent, this.fs);
            FileRepository db = (FileRepository)RepositoryCache.open(key);
            return new AlternateRepository(db);
        }
        ObjectDirectory db = new ObjectDirectory(this.config, objdir, null, this.fs, null);
        return new AlternateHandle(db);
    }

    @Override
    public File fileFor(AnyObjectId objectId) {
        String n = objectId.name();
        String d = n.substring(0, 2);
        String f = n.substring(2);
        return new File(new File(this.getDirectory(), d), f);
    }

    @Override
    public ObjectDatabase newCachedDatabase() {
        return this.newCachedFileObjectDatabase();
    }

    CachedObjectDirectory newCachedFileObjectDatabase() {
        return new CachedObjectDirectory(this);
    }

    AlternateHandle.Id getAlternateId() {
        return new AlternateHandle.Id(this.objects);
    }

    static class AlternateHandle {
        final ObjectDirectory db;

        AlternateHandle(ObjectDirectory db) {
            this.db = db;
        }

        void close() {
            this.db.close();
        }

        public Id getId() {
            return this.db.getAlternateId();
        }

        static class Id {
            String alternateId;

            public Id(File object) {
                try {
                    this.alternateId = object.getCanonicalPath();
                }
                catch (Exception e) {
                    this.alternateId = null;
                }
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (o == null || !(o instanceof Id)) {
                    return false;
                }
                Id aId = (Id)o;
                return Objects.equals(this.alternateId, aId.alternateId);
            }

            public int hashCode() {
                if (this.alternateId == null) {
                    return 1;
                }
                return this.alternateId.hashCode();
            }
        }
    }

    static class AlternateRepository
    extends AlternateHandle {
        final FileRepository repository;

        AlternateRepository(FileRepository r) {
            super(r.getObjectDatabase());
            this.repository = r;
        }

        @Override
        void close() {
            this.repository.close();
        }
    }

    private static final class PackList {
        final FileSnapshot snapshot;
        final PackFile[] packs;

        PackList(FileSnapshot monitor, PackFile[] packs) {
            this.snapshot = monitor;
            this.packs = packs;
        }
    }
}

