/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.IResourceMappingMerger;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.dialogs.NoChangesDialog;
import org.eclipse.team.ui.synchronize.ModelOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ModelMergeOperation
extends ModelOperation {
    public static IStatus validateMerge(IMergeContext context, IProgressMonitor monitor) {
        try {
            ModelProvider[] providers = context.getScope().getModelProviders();
            monitor.beginTask(null, 100 * providers.length);
            ArrayList<IStatus> notOK = new ArrayList<IStatus>();
            int i = 0;
            while (i < providers.length) {
                ModelProvider provider = providers[i];
                IStatus status = ModelMergeOperation.validateMerge(provider, context, Policy.subMonitorFor(monitor, 100));
                if (!status.isOK()) {
                    notOK.add(status);
                }
                ++i;
            }
            if (notOK.isEmpty()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (notOK.size() == 1) {
                IStatus iStatus = (IStatus)notOK.get(0);
                return iStatus;
            }
            MultiStatus multiStatus = new MultiStatus("org.eclipse.team.ui", 0, notOK.toArray(new IStatus[notOK.size()]), TeamUIMessages.ResourceMappingMergeOperation_3, null);
            return multiStatus;
        }
        finally {
            monitor.done();
        }
    }

    private static IStatus validateMerge(ModelProvider provider, IMergeContext context, IProgressMonitor monitor) {
        IResourceMappingMerger merger = ModelMergeOperation.getMerger(provider);
        if (merger == null) {
            return Status.OK_STATUS;
        }
        return merger.validateMerge(context, monitor);
    }

    private static IResourceMappingMerger getMerger(ModelProvider provider) {
        Assert.isNotNull((Object)provider);
        return (IResourceMappingMerger)Adapters.adapt((Object)provider, IResourceMappingMerger.class);
    }

    protected ModelMergeOperation(IWorkbenchPart part, ISynchronizationScopeManager manager) {
        super(part, manager);
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask(null, 100);
                this.initializeContext(Policy.subMonitorFor(monitor, 50));
                this.executeMerge(Policy.subMonitorFor(monitor, 50));
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void executeMerge(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        if (!this.hasChangesOfInterest()) {
            this.handleNoChanges();
        } else if (this.isPreviewRequested()) {
            this.handlePreviewRequest();
        } else {
            IStatus status = ModelMergeOperation.validateMerge(this.getMergeContext(), Policy.subMonitorFor(monitor, 10));
            if (!status.isOK()) {
                this.handleValidationFailure(status);
            } else {
                status = this.performMerge(Policy.subMonitorFor(monitor, 90));
                if (!status.isOK()) {
                    this.handleMergeFailure(status);
                }
            }
        }
        monitor.done();
    }

    protected void handlePreviewRequest() {
    }

    protected abstract void initializeContext(IProgressMonitor var1) throws CoreException;

    protected void handleValidationFailure(IStatus status) {
        boolean[] result = new boolean[1];
        Runnable runnable = () -> {
            ErrorDialog dialog = new ErrorDialog(this.getShell(), TeamUIMessages.ModelMergeOperation_0, TeamUIMessages.ModelMergeOperation_1, status, 7){

                protected void createButtonsForButtonBar(Composite parent) {
                    this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
                    this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
                    this.createDetailsButton(parent);
                }

                protected void buttonPressed(int id) {
                    if (id == 2) {
                        super.buttonPressed(0);
                    } else if (id == 3) {
                        super.buttonPressed(1);
                    }
                    super.buttonPressed(id);
                }
            };
            int code = dialog.open();
            blArray[0] = code == 0;
        };
        this.getShell().getDisplay().syncExec(runnable);
        if (result[0]) {
            this.handlePreviewRequest();
        }
    }

    protected void handleMergeFailure(IStatus status) {
        Display.getDefault().syncExec(() -> MessageDialog.openInformation((Shell)this.getShell(), (String)TeamUIMessages.MergeIncomingChangesAction_0, (String)status.getMessage()));
        this.handlePreviewRequest();
    }

    protected void handleNoChanges() {
        Display.getDefault().syncExec(() -> NoChangesDialog.open(this.getShell(), TeamUIMessages.ResourceMappingMergeOperation_0, TeamUIMessages.ResourceMappingMergeOperation_1, TeamUIMessages.ModelMergeOperation_3, this.getScope().asInputScope()));
    }

    protected IStatus performMerge(IProgressMonitor monitor) throws CoreException {
        ISynchronizationContext sc = this.getContext();
        if (sc instanceof IMergeContext) {
            IMergeContext context = (IMergeContext)sc;
            ModelProvider[] providers = ModelMergeOperation.sortByExtension(context.getScope().getModelProviders());
            IStatus[] result = new IStatus[]{Status.OK_STATUS};
            context.run(monitor1 -> {
                try {
                    int ticks = 100;
                    monitor1.beginTask(null, ticks + (providers.length - 1) * 10);
                    int i = 0;
                    while (i < providers.length) {
                        ModelProvider provider = providers[i];
                        IStatus status = this.performMerge(provider, Policy.subMonitorFor(monitor1, ticks));
                        ticks = 10;
                        if (!status.isOK()) {
                            iStatusArray[0] = status;
                            return;
                        }
                        try {
                            Job.getJobManager().join((Object)this.getContext(), monitor1);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++i;
                    }
                }
                finally {
                    monitor1.done();
                }
            }, null, 0, monitor);
            return result[0];
        }
        return this.noMergeContextAvailable();
    }

    protected IStatus performMerge(ModelProvider provider, IProgressMonitor monitor) throws CoreException {
        ISynchronizationContext sc = this.getContext();
        if (sc instanceof IMergeContext) {
            IMergeContext context = (IMergeContext)sc;
            IResourceMappingMerger merger = ModelMergeOperation.getMerger(provider);
            if (merger != null) {
                IStatus status = merger.merge(context, monitor);
                if (status.isOK() || status.getCode() == 1) {
                    return status;
                }
                throw new TeamException(status);
            }
            return Status.OK_STATUS;
        }
        return this.noMergeContextAvailable();
    }

    private IStatus noMergeContextAvailable() {
        throw new IllegalStateException(TeamUIMessages.ModelMergeOperation_2);
    }

    protected boolean hasChangesOfInterest() {
        return !this.getContext().getDiffTree().isEmpty() && this.hasIncomingChanges((IDiffTree)this.getContext().getDiffTree());
    }

    private boolean hasIncomingChanges(IDiffTree tree) {
        return tree.hasMatchingDiffs(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), new FastDiffFilter(){

            public boolean select(IDiff node) {
                if (node instanceof IThreeWayDiff) {
                    IThreeWayDiff twd = (IThreeWayDiff)node;
                    int direction = twd.getDirection();
                    return direction == 512 || direction == 768;
                }
                return true;
            }
        });
    }

    private IMergeContext getMergeContext() {
        return (IMergeContext)this.getContext();
    }
}

