/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

class RevisionHoverInformationControlCreator
extends AbstractReusableInformationControlCreator {
    private static final String fgStyleSheet = "/* Font definitions */\nbody, h1, h2, h3, h4, h5, h6, p, table, td, caption, th, ul, ol, dl, li, dd, dt {font-family: sans-serif; font-size: 9pt }\npre\t\t\t\t{ font-family: monospace; font-size: 9pt }\n\n/* Margins */\nbody\t     { overflow: auto; margin-top: 0; margin-bottom: 4; margin-left: 3; margin-right: 0 }\nh1           { margin-top: 5; margin-bottom: 1 }\t\nh2           { margin-top: 25; margin-bottom: 3 }\nh3           { margin-top: 20; margin-bottom: 3 }\nh4           { margin-top: 20; margin-bottom: 3 }\nh5           { margin-top: 0; margin-bottom: 0 }\np            { margin-top: 10px; margin-bottom: 10px }\npre\t         { margin-left: 6 }\nul\t         { margin-top: 0; margin-bottom: 10 }\nli\t         { margin-top: 0; margin-bottom: 0 } \nli p\t     { margin-top: 0; margin-bottom: 0 } \nol\t         { margin-top: 0; margin-bottom: 10 }\ndl\t         { margin-top: 0; margin-bottom: 10 }\ndt\t         { margin-top: 0; margin-bottom: 0; font-weight: bold }\ndd\t         { margin-top: 0; margin-bottom: 0 }\n\n/* Styles and colors */\na:link\t     { color: hyperlinkColor }\na:hover\t     { color: activeHyperlinkColor }\na:visited    { text-decoration: underline }\nh4           { font-style: italic }\nstrong\t     { font-weight: bold }\nem\t         { font-style: italic }\nvar\t         { font-style: italic }\nth\t         { font-weight: bold }\n";
    private boolean fIsFocusable;

    public RevisionHoverInformationControlCreator(boolean isFocusable) {
        this.fIsFocusable = isFocusable;
    }

    public boolean canReuse(IInformationControl control) {
        if (!super.canReuse(control)) {
            return false;
        }
        if (control instanceof IInformationControlExtension4) {
            ((IInformationControlExtension4)control).setStatusText(EditorsUI.getTooltipAffordanceString());
        }
        return true;
    }

    protected IInformationControl doCreateInformationControl(Shell parent) {
        if (BrowserInformationControl.isAvailable((Composite)parent)) {
            if (this.fIsFocusable) {
                return new RevisionInformationControl(parent);
            }
            return new RevisionInformationControl(parent, EditorsUI.getTooltipAffordanceString());
        }
        if (this.fIsFocusable) {
            return new DefaultInformationControl(parent, true);
        }
        return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString());
    }

    private static final class RevisionInformationControl
    extends BrowserInformationControl {
        public RevisionInformationControl(Shell parent, String statusFieldText) {
            super(parent, "org.eclipse.jface.dialogfont", statusFieldText);
        }

        public RevisionInformationControl(Shell parent) {
            super(parent, "org.eclipse.jface.dialogfont", true);
        }

        @Deprecated
        public void setInformation(String content) {
            content = this.addCSSToHTMLFragment(content);
            super.setInformation(content);
        }

        private String addCSSToHTMLFragment(String html) {
            int max = Math.min(100, html.length());
            if (html.substring(0, max).indexOf("<html>") != -1) {
                return html;
            }
            StringBuilder info = new StringBuilder(512 + html.length());
            HTMLPrinter.insertPageProlog((StringBuilder)info, (int)0, (String)RevisionHoverInformationControlCreator.fgStyleSheet);
            info.append(html);
            HTMLPrinter.addPageEpilog((StringBuilder)info);
            return info.toString();
        }
    }
}

