/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.DetailFormatterDialog;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class NewDetailFormatterAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        String typeName;
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        try {
            IJavaType type;
            if (element instanceof IJavaVariable) {
                type = ((IJavaValue)((IJavaVariable)element).getValue()).getJavaType();
            } else if (element instanceof JavaInspectExpression) {
                type = ((IJavaValue)((JavaInspectExpression)((Object)element)).getValue()).getJavaType();
            } else {
                return;
            }
            if (type == null) {
                return;
            }
            typeName = type.getName();
        }
        catch (DebugException debugException) {
            return;
        }
        JavaDetailFormattersManager detailFormattersManager = JavaDetailFormattersManager.getDefault();
        DetailFormatter detailFormatter = new DetailFormatter(typeName, "", true);
        if (new DetailFormatterDialog(JDIDebugUIPlugin.getActivePage().getWorkbenchWindow().getShell(), detailFormatter, null, true, false).open() == 0) {
            detailFormattersManager.setAssociatedDetailFormatter(detailFormatter);
        }
    }
}

