/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.csv;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.AbstractWriter;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvFormat;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvWriterSettings;

public class CsvWriter
extends AbstractWriter<CsvWriterSettings> {
    private char separator;
    private char quoteChar;
    private char escapeChar;
    private char escapeEscape;
    private boolean ignoreLeading;
    private boolean ignoreTrailing;
    private boolean quoteAllFields;
    private boolean escapeUnquoted;
    private boolean inputNotEscaped;
    private char newLine;
    private boolean dontProcessNormalizedNewLines;
    private boolean[] quotationTriggers;
    private char maxTrigger;

    public CsvWriter(CsvWriterSettings settings) {
        this((Writer)null, settings);
    }

    public CsvWriter(Writer writer, CsvWriterSettings settings) {
        super(writer, settings);
    }

    public CsvWriter(File file, CsvWriterSettings settings) {
        super(file, settings);
    }

    public CsvWriter(File file, String encoding, CsvWriterSettings settings) {
        super(file, encoding, settings);
    }

    public CsvWriter(File file, Charset encoding, CsvWriterSettings settings) {
        super(file, encoding, settings);
    }

    public CsvWriter(OutputStream output, CsvWriterSettings settings) {
        super(output, settings);
    }

    public CsvWriter(OutputStream output, String encoding, CsvWriterSettings settings) {
        super(output, encoding, settings);
    }

    public CsvWriter(OutputStream output, Charset encoding, CsvWriterSettings settings) {
        super(output, encoding, settings);
    }

    @Override
    protected final void initialize(CsvWriterSettings settings) {
        int i;
        CsvFormat format = (CsvFormat)settings.getFormat();
        this.separator = format.getDelimiter();
        this.quoteChar = format.getQuote();
        this.escapeChar = format.getQuoteEscape();
        this.escapeEscape = ((CsvFormat)settings.getFormat()).getCharToEscapeQuoteEscaping();
        this.newLine = format.getNormalizedNewline();
        this.quoteAllFields = settings.getQuoteAllFields();
        this.ignoreLeading = settings.getIgnoreLeadingWhitespaces();
        this.ignoreTrailing = settings.getIgnoreTrailingWhitespaces();
        this.escapeUnquoted = settings.isEscapeUnquotedValues();
        this.inputNotEscaped = !settings.isInputEscaped();
        this.dontProcessNormalizedNewLines = !settings.isNormalizeLineEndingsWithinQuotes();
        this.quotationTriggers = null;
        this.maxTrigger = '\u0000';
        int triggerCount = settings.getQuotationTriggers().length;
        int offset = settings.isQuoteEscapingEnabled() ? 1 : 0;
        char[] tmp = Arrays.copyOf(settings.getQuotationTriggers(), triggerCount + offset);
        if (offset == 1) {
            tmp[triggerCount] = this.quoteChar;
        }
        for (i = 0; i < tmp.length; ++i) {
            if (this.maxTrigger >= tmp[i]) continue;
            this.maxTrigger = tmp[i];
        }
        if (this.maxTrigger != '\u0000') {
            this.maxTrigger = (char)(this.maxTrigger + '\u0001');
            this.quotationTriggers = new boolean[this.maxTrigger];
            Arrays.fill(this.quotationTriggers, false);
            for (i = 0; i < tmp.length; ++i) {
                this.quotationTriggers[tmp[i]] = true;
            }
        }
    }

    @Override
    protected void processRow(Object[] row) {
        for (int i = 0; i < row.length; ++i) {
            if (i != 0) {
                this.appendToRow(this.separator);
            }
            if (this.dontProcessNormalizedNewLines) {
                this.appender.enableDenormalizedLineEndings(false);
            }
            String nextElement = this.getStringValue(row[i]);
            int originalLength = this.appender.length();
            boolean isElementQuoted = this.append(this.quoteAllFields, nextElement);
            if (this.appender.length() == originalLength) {
                if (isElementQuoted) {
                    if (nextElement == null) {
                        this.append(false, this.nullValue);
                    } else {
                        this.append(true, this.emptyValue);
                    }
                } else if (nextElement == null) {
                    this.append(false, this.nullValue);
                } else {
                    this.append(false, this.emptyValue);
                }
            }
            if (isElementQuoted) {
                this.appendToRow(this.quoteChar);
                this.appendValueToRow();
                this.appendToRow(this.quoteChar);
                if (!this.dontProcessNormalizedNewLines) continue;
                this.appender.enableDenormalizedLineEndings(true);
                continue;
            }
            this.appendValueToRow();
        }
    }

    private boolean quoteElement(int start, String element) {
        int length = element.length();
        if (this.maxTrigger == '\u0000') {
            for (int i = start; i < length; ++i) {
                char nextChar = element.charAt(i);
                if (nextChar != this.separator && nextChar != this.newLine) continue;
                return true;
            }
        } else {
            for (int i = start; i < length; ++i) {
                char nextChar = element.charAt(i);
                if (nextChar != this.separator && nextChar != this.newLine && (nextChar >= this.maxTrigger || !this.quotationTriggers[nextChar])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean append(boolean isElementQuoted, String element) {
        int i;
        int length;
        if (element == null) {
            if (this.nullValue == null) {
                return isElementQuoted;
            }
            element = this.nullValue;
        }
        int start = 0;
        if (this.ignoreLeading) {
            start = CsvWriter.skipLeadingWhitespace(this.whitespaceRangeStart, element);
        }
        if (start < (length = element.length()) && element.charAt(start) == this.quoteChar) {
            isElementQuoted = true;
        }
        if (isElementQuoted) {
            if (this.usingNullOrEmptyValue && length >= 2) {
                if (element.charAt(0) == this.quoteChar && element.charAt(length - 1) == this.quoteChar) {
                    this.appender.append(element);
                    return false;
                }
                this.appendQuoted(start, element);
                return true;
            }
            this.appendQuoted(start, element);
            return true;
        }
        char ch = '\u0000';
        for (i = start; i < length; ++i) {
            ch = element.charAt(i);
            if (ch != this.quoteChar && ch != this.separator && ch != this.newLine && ch != this.escapeChar && (ch >= this.maxTrigger || !this.quotationTriggers[ch])) continue;
            this.appender.append(element, start, i);
            start = i + 1;
            if (ch == this.quoteChar || ch == this.escapeChar) {
                if (this.quoteElement(i, element)) {
                    this.appendQuoted(i, element);
                    return true;
                }
                if (this.escapeUnquoted) {
                    this.appendQuoted(i, element);
                } else {
                    this.appender.append(element, i, length);
                    if (this.ignoreTrailing && element.charAt(length - 1) <= ' ' && this.whitespaceRangeStart < element.charAt(length - 1)) {
                        this.appender.updateWhitespace();
                    }
                }
                return isElementQuoted;
            }
            if (ch == this.escapeChar && this.inputNotEscaped && this.escapeEscape != '\u0000' && this.escapeUnquoted) {
                this.appender.append(this.escapeEscape);
            } else if (ch == this.separator || ch == this.newLine || ch < this.maxTrigger && this.quotationTriggers[ch]) {
                this.appendQuoted(i, element);
                return true;
            }
            this.appender.append(ch);
        }
        this.appender.append(element, start, i);
        if (ch <= ' ' && this.ignoreTrailing && this.whitespaceRangeStart < ch) {
            this.appender.updateWhitespace();
        }
        return isElementQuoted;
    }

    private void appendQuoted(int start, String element) {
        int i;
        int length = element.length();
        char ch = '\u0000';
        for (i = start; i < length; ++i) {
            ch = element.charAt(i);
            if (ch != this.quoteChar && ch != this.newLine && ch != this.escapeChar) continue;
            this.appender.append(element, start, i);
            start = i + 1;
            if (ch == this.quoteChar && this.inputNotEscaped) {
                this.appender.append(this.escapeChar);
            } else if (ch == this.escapeChar && this.inputNotEscaped && this.escapeEscape != '\u0000') {
                this.appender.append(this.escapeEscape);
            }
            this.appender.append(ch);
        }
        this.appender.append(element, start, i);
        if (ch <= ' ' && this.ignoreTrailing && this.whitespaceRangeStart < ch) {
            this.appender.updateWhitespace();
        }
    }
}

