/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.search;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.pde.core.IIdentifiable;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.search.ISearchResultCollector;
import org.eclipse.pde.internal.core.search.PluginSearchInput;
import org.eclipse.pde.internal.core.util.PatternConstructor;

public class PluginSearchOperation {
    protected PluginSearchInput fInput;
    private ISearchResultCollector fCollector;
    private Pattern fPattern;

    public PluginSearchOperation(PluginSearchInput input, ISearchResultCollector collector) {
        this.fInput = input;
        this.fCollector = collector;
        this.fPattern = PatternConstructor.createPattern(input.getSearchString(), input.isCaseSensitive());
    }

    public void execute(IProgressMonitor monitor) {
        IModelChangeProvider candidate;
        IPluginModelBase[] plugins = this.fInput.getSearchScope().getMatchingModels();
        IFeatureModel[] features = this.fInput.getSearchScope().getMatchingFeatureModels();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(plugins.length + features.length));
        IModelChangeProvider[] iModelChangeProviderArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            candidate = iModelChangeProviderArray[n2];
            this.visit((IPluginModelBase)candidate);
            subMonitor.split(1);
            ++n2;
        }
        iModelChangeProviderArray = features;
        n = features.length;
        n2 = 0;
        while (n2 < n) {
            candidate = iModelChangeProviderArray[n2];
            this.visit((IFeatureModel)candidate);
            subMonitor.split(1);
            ++n2;
        }
    }

    private void visit(IPluginModelBase model) {
        ArrayList<IIdentifiable> matches = this.findMatch(model);
        int i = 0;
        while (i < matches.size()) {
            this.fCollector.accept(matches.get(i));
            ++i;
        }
    }

    private void visit(IFeatureModel model) {
        List<IIdentifiable> matches = this.findMatch(model);
        int i = 0;
        while (i < matches.size()) {
            this.fCollector.accept(matches.get(i));
            ++i;
        }
    }

    private ArrayList<IIdentifiable> findMatch(IPluginModelBase model) {
        ArrayList<IIdentifiable> result = new ArrayList<IIdentifiable>();
        int searchLimit = this.fInput.getSearchLimit();
        switch (this.fInput.getSearchElement()) {
            case 1: {
                if (searchLimit != 2) {
                    this.findPluginDeclaration(model, result);
                }
                if (searchLimit == 1) break;
                this.findPluginReferences(model, result);
                break;
            }
            case 2: {
                this.findFragmentDeclaration(model, result);
                break;
            }
            case 3: {
                if (searchLimit != 2) {
                    this.findExtensionPointDeclarations(model, result);
                }
                if (searchLimit == 1) break;
                this.findExtensionPointReferences(model, result);
            }
        }
        return result;
    }

    private List<IIdentifiable> findMatch(IFeatureModel model) {
        ArrayList<IIdentifiable> result = new ArrayList<IIdentifiable>();
        int searchLimit = this.fInput.getSearchLimit();
        switch (this.fInput.getSearchElement()) {
            case 1: {
                if (searchLimit == 1) break;
                this.findPluginReferences(model, result);
            }
        }
        return result;
    }

    private void findFragmentDeclaration(IPluginModelBase model, ArrayList<IIdentifiable> result) {
        IPluginBase pluginBase = model.getPluginBase();
        if (pluginBase instanceof IFragment && this.fPattern.matcher(pluginBase.getId()).matches()) {
            result.add(pluginBase);
        }
    }

    private void findPluginDeclaration(IPluginModelBase model, ArrayList<IIdentifiable> result) {
        IPluginBase pluginBase = model.getPluginBase();
        if (pluginBase instanceof IPlugin && this.fPattern.matcher(pluginBase.getId()).matches()) {
            result.add(pluginBase);
        }
    }

    private void findPluginReferences(IPluginModelBase model, ArrayList<IIdentifiable> result) {
        IPluginImport[] imports;
        IPluginBase pluginBase = model.getPluginBase();
        if (pluginBase instanceof IFragment && this.fPattern.matcher(((IFragment)pluginBase).getPluginId()).matches()) {
            result.add(pluginBase);
        }
        IPluginImport[] iPluginImportArray = imports = pluginBase.getImports();
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginImport pluginImport = iPluginImportArray[n2];
            if (this.fPattern.matcher(pluginImport.getId()).matches()) {
                result.add(pluginImport);
            }
            ++n2;
        }
    }

    private void findPluginReferences(IFeatureModel model, List<IIdentifiable> result) {
        IFeaturePlugin[] includedPlugins;
        IFeaturePlugin[] iFeaturePluginArray = includedPlugins = model.getFeature().getPlugins();
        int n = includedPlugins.length;
        int n2 = 0;
        while (n2 < n) {
            IFeaturePlugin plugin = iFeaturePluginArray[n2];
            if (this.fPattern.matcher(plugin.getId()).matches()) {
                result.add(plugin);
            }
            ++n2;
        }
    }

    private void findExtensionPointDeclarations(IPluginModelBase model, ArrayList<IIdentifiable> result) {
        IPluginExtensionPoint[] extensionPoints;
        IPluginExtensionPoint[] iPluginExtensionPointArray = extensionPoints = model.getPluginBase().getExtensionPoints();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtensionPoint extensionPoint = iPluginExtensionPointArray[n2];
            if (this.fPattern.matcher(extensionPoint.getFullId()).matches()) {
                result.add(extensionPoint);
            }
            ++n2;
        }
    }

    private void findExtensionPointReferences(IPluginModelBase model, ArrayList<IIdentifiable> result) {
        IPluginExtension[] extensions;
        IPluginExtension[] iPluginExtensionArray = extensions = model.getPluginBase().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            if (this.fPattern.matcher(extension.getPoint()).matches()) {
                result.add(extension);
            }
            ++n2;
        }
    }
}

