/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional;

public final class RestrictionModifiers {
    public static final int NO_RESTRICTIONS = 0;
    public static final int NO_IMPLEMENT = 1;
    public static final int NO_EXTEND = 2;
    public static final int NO_INSTANTIATE = 4;
    public static final int NO_REFERENCE = 8;
    public static final int NO_OVERRIDE = 16;
    public static final int ALL_RESTRICTIONS = 255;

    private RestrictionModifiers() {
    }

    public static final boolean isImplementRestriction(int modifiers) {
        return (modifiers & 1) > 0;
    }

    public static final boolean isExtendRestriction(int modifiers) {
        return (modifiers & 2) > 0;
    }

    public static final boolean isOverrideRestriction(int modifiers) {
        return (modifiers & 0x10) > 0;
    }

    public static final boolean isInstantiateRestriction(int modifiers) {
        return (modifiers & 4) > 0;
    }

    public static final boolean isReferenceRestriction(int modifiers) {
        return (modifiers & 8) > 0;
    }

    public static final boolean isUnrestricted(int modifiers) {
        return modifiers == 0;
    }

    public static String getRestrictionText(int restrictions) {
        StringBuilder buffer = new StringBuilder();
        if (restrictions == 0) {
            return "NO_RESTRICTIONS";
        }
        if (restrictions == 255) {
            buffer.append("ALL_RESTRICTIONS");
        } else {
            if ((restrictions & 2) > 0) {
                buffer.append("NO_EXTEND");
            }
            if ((restrictions & 1) > 0) {
                if (buffer.length() > 0) {
                    buffer.append(" | ");
                }
                buffer.append("NO_IMPLEMENT");
            }
            if ((restrictions & 4) > 0) {
                if (buffer.length() > 0) {
                    buffer.append(" | ");
                }
                buffer.append("NO_INSTANTIATE");
            }
            if ((restrictions & 8) > 0) {
                if (buffer.length() > 0) {
                    buffer.append(" | ");
                }
                buffer.append("NO_REFERENCE");
            }
            if (0 > 0) {
                if (buffer.length() > 0) {
                    buffer.append(" | ");
                }
                buffer.append("NO_RESTRICTIONS");
            }
            if ((restrictions & 0x10) > 0) {
                if (buffer.length() > 0) {
                    buffer.append(" | ");
                }
                buffer.append("NO_OVERRIDE");
            }
        }
        if (buffer.length() == 0) {
            return "UNKNOWN_KIND";
        }
        return buffer.toString();
    }
}

