/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.DeleteTagOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.BranchSelectionDialog;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.swt.widgets.Shell;

public class DeleteTagOnCommitHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<Ref> tagsToDelete;
        Repository repository = this.getRepository(event);
        if (repository == null) {
            return null;
        }
        Shell shell = this.getPart(event).getSite().getShell();
        IStructuredSelection selection = this.getSelection(event);
        List<Ref> tags = this.getTagsOfCommit(selection);
        if (tags.isEmpty()) {
            return null;
        }
        if (tags.size() > 1) {
            BranchSelectionDialog<Ref> dialog = new BranchSelectionDialog<Ref>(shell, tags, UIText.DeleteTagOnCommitHandler_DeleteTagsDialogTitle, UIText.DeleteTagOnCommitHandler_DeleteTagsDialogMessage, UIText.DeleteTagOnCommitHandler_DeleteTagsDialogButton, 2);
            if (dialog.open() != 0) {
                return null;
            }
            tagsToDelete = dialog.getSelectedNodes();
        } else {
            String tagName = Repository.shortenRefName((String)tags.get(0).getName());
            String message = MessageFormat.format(UIText.DeleteTagCommand_messageConfirmSingleTag, tagName);
            boolean confirmed = MessageDialog.openConfirm((Shell)shell, (String)UIText.DeleteTagCommand_titleConfirm, (String)message);
            if (!confirmed) {
                return null;
            }
            tagsToDelete = tags;
        }
        try {
            this.deleteTagsAsTask(shell, repository, tagsToDelete);
        }
        catch (InvocationTargetException e1) {
            Activator.handleError(UIText.RepositoriesView_TagDeletionFailureMessage, e1.getCause(), true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        IStructuredSelection selection = this.getSelection(page);
        if (selection.size() != 1) {
            return false;
        }
        List<Ref> tags = this.getTagsOfCommit(selection);
        return !tags.isEmpty();
    }

    private void deleteTagsAsTask(Shell shell, final Repository repository, final List<Ref> tagsToDelete) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(UIText.DeleteTagCommand_deletingTagsProgress, tagsToDelete.size());
                        for (Ref ref : tagsToDelete) {
                            DeleteTagOnCommitHandler.this.deleteTag(repository, ref.getName());
                            monitor.worked(1);
                        }
                    }
                    catch (CoreException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private List<Ref> getTagsOfCommit(IStructuredSelection selection) {
        ArrayList<Ref> tagsOfCommit = new ArrayList<Ref>();
        if (selection.isEmpty()) {
            return tagsOfCommit;
        }
        PlotCommit commit = (PlotCommit)selection.getFirstElement();
        int i = 0;
        while (i < commit.getRefCount()) {
            Ref ref = commit.getRef(i);
            if (ref.getName().startsWith("refs/tags/")) {
                tagsOfCommit.add(ref);
            }
            ++i;
        }
        return tagsOfCommit;
    }

    private void deleteTag(Repository repository, String tagName) throws CoreException {
        DeleteTagOperation operation = new DeleteTagOperation(repository, tagName);
        operation.execute(null);
    }
}

