/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.field;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.db.BTree;
import org.eclipse.jdt.internal.core.nd.db.Database;
import org.eclipse.jdt.internal.core.nd.db.IBTreeComparator;
import org.eclipse.jdt.internal.core.nd.db.IBTreeVisitor;
import org.eclipse.jdt.internal.core.nd.db.IString;
import org.eclipse.jdt.internal.core.nd.db.IndexException;
import org.eclipse.jdt.internal.core.nd.db.ModificationLog;
import org.eclipse.jdt.internal.core.nd.field.BaseField;
import org.eclipse.jdt.internal.core.nd.field.FieldSearchKey;
import org.eclipse.jdt.internal.core.nd.field.IDestructableField;
import org.eclipse.jdt.internal.core.nd.field.StructDef;

public class FieldSearchIndex<T extends NdNode>
extends BaseField
implements IDestructableField {
    private final ITypeFactory<BTree> btreeFactory = BTree.getFactory(new IBTreeComparator(){

        @Override
        public int compare(Nd nd, long record1, long record2) {
            IString key2;
            IString key1 = FieldSearchIndex.this.searchKey.get(nd, record1);
            int cmp = key1.compareCompatibleWithIgnoreCase(key2 = FieldSearchIndex.this.searchKey.get(nd, record2));
            if (cmp == 0) {
                cmp = Long.signum(record1 - record2);
            }
            return cmp;
        }
    });
    FieldSearchKey<?> searchKey;
    private final ModificationLog.Tag destructTag;
    private static IResultRank anything = new IResultRank(){

        @Override
        public long getRank(Nd nd, long address) {
            return 1L;
        }
    };

    private FieldSearchIndex(FieldSearchKey<?> searchKey, String structName, int fieldNumber) {
        if (searchKey != null) {
            if (searchKey.searchIndex != null && searchKey.searchIndex != this) {
                throw new IllegalArgumentException("Attempted to construct a FieldSearchIndex referring to a search key that is already in use by a different index");
            }
            searchKey.searchIndex = this;
        }
        this.searchKey = searchKey;
        this.setFieldName("field " + fieldNumber + ", a " + this.getClass().getSimpleName() + " in struct " + structName);
        this.destructTag = ModificationLog.createTag("Destructing " + this.getFieldName());
    }

    public static <T extends NdNode, B> FieldSearchIndex<T> create(StructDef<B> builder, FieldSearchKey<B> searchKey) {
        FieldSearchIndex<T> result = new FieldSearchIndex<T>(searchKey, builder.getStructName(), builder.getNumFields());
        builder.add(result);
        builder.addDestructableField(result);
        return result;
    }

    public BTree get(Nd nd, long address) {
        return this.btreeFactory.create(nd, address + (long)this.offset);
    }

    @Override
    public void destruct(Nd nd, long address) {
        Database db = nd.getDB();
        db.getLog().start(this.destructTag);
        try {
            this.btreeFactory.destruct(nd, address);
        }
        finally {
            db.getLog().end(this.destructTag);
        }
    }

    @Override
    public int getRecordSize() {
        return this.btreeFactory.getRecordSize();
    }

    public T findFirst(Nd nd, long address, SearchCriteria searchCriteria) {
        return this.findBest(nd, address, searchCriteria, anything);
    }

    public T findBest(final Nd nd, long address, SearchCriteria searchCriteria, final IResultRank rankFunction) {
        final long[] resultRank = new long[1];
        final long[] result = new long[1];
        this.get(nd, address).accept(new SearchCriteriaToBtreeVisitorAdapter(this, searchCriteria, nd){

            @Override
            protected boolean acceptResult(long resultAddress) {
                long rank = rankFunction.getRank(nd, resultAddress);
                if (rank >= resultRank[0]) {
                    resultRank[0] = rank;
                    result[0] = resultAddress;
                }
                return true;
            }
        });
        if (result[0] == 0L) {
            return null;
        }
        return (T)NdNode.load(nd, result[0]);
    }

    public boolean visitAll(final Nd nd, long address, SearchCriteria searchCriteria, final Visitor<T> visitor) {
        return this.get(nd, address).accept(new SearchCriteriaToBtreeVisitorAdapter(this, searchCriteria, nd){

            @Override
            protected boolean acceptResult(long resultAddress) {
                return visitor.visit(NdNode.load(nd, resultAddress));
            }
        });
    }

    public List<T> findAll(final Nd nd, long address, SearchCriteria searchCriteria) {
        final ArrayList result = new ArrayList();
        this.get(nd, address).accept(new SearchCriteriaToBtreeVisitorAdapter(this, searchCriteria, nd){

            @Override
            protected boolean acceptResult(long resultAddress) {
                result.add(NdNode.load(nd, resultAddress));
                return true;
            }
        });
        return result;
    }

    public List<T> findAll(final Nd nd, long address, SearchCriteria searchCriteria, int count) {
        final ArrayList result = new ArrayList();
        this.get(nd, address).accept(new SearchCriteriaToBtreeVisitorAdapter(this, searchCriteria, nd, count){
            int remainingCount;
            {
                super($anonymous0, $anonymous1);
                this.remainingCount = n;
            }

            @Override
            protected boolean acceptResult(long resultAddress) {
                result.add(NdNode.load(nd, resultAddress));
                --this.remainingCount;
                return this.remainingCount > 0;
            }
        });
        return result;
    }

    public List<T> asList(final Nd nd, long address) {
        final ArrayList result = new ArrayList();
        this.get(nd, address).accept(new IBTreeVisitor(){

            @Override
            public int compare(long record) {
                return 0;
            }

            @Override
            public boolean visit(long resultAddress) {
                result.add(NdNode.load(nd, resultAddress));
                return true;
            }
        });
        return result;
    }

    public static interface IResultRank {
        public long getRank(Nd var1, long var2);
    }

    public static final class SearchCriteria {
        private boolean matchCase = true;
        private boolean isPrefix = false;
        private char[] searchString;
        private short requiredNodeType = (short)-1;
        private boolean matchingParentNodeAddress = false;

        private SearchCriteria(char[] searchString) {
            this.searchString = searchString;
        }

        public static SearchCriteria create(String searchString) {
            return SearchCriteria.create(searchString.toCharArray());
        }

        public static SearchCriteria create(char[] searchString) {
            return new SearchCriteria(searchString);
        }

        public SearchCriteria requireNodeType(short type) {
            this.requiredNodeType = type;
            return this;
        }

        public SearchCriteria allowAnyNodeType() {
            this.requiredNodeType = (short)-1;
            return this;
        }

        public SearchCriteria matchCase(boolean match) {
            this.matchCase = match;
            return this;
        }

        public SearchCriteria prefix(boolean isPrefixSearch) {
            this.isPrefix = isPrefixSearch;
            return this;
        }

        public boolean isMatchingParentNodeAddress() {
            return this.matchingParentNodeAddress;
        }

        public boolean isMatchingCase() {
            return this.matchCase;
        }

        public boolean isPrefixSearch() {
            return this.isPrefix;
        }

        public char[] getSearchString() {
            return this.searchString;
        }

        public boolean acceptsNodeType(short nodeType) {
            return this.requiredNodeType == -1 || this.requiredNodeType == nodeType;
        }

        public boolean requiresSpecificNodeType() {
            return this.requiredNodeType != -1;
        }
    }

    private abstract class SearchCriteriaToBtreeVisitorAdapter
    implements IBTreeVisitor {
        private final SearchCriteria searchCriteria;
        private final Nd nd;

        public SearchCriteriaToBtreeVisitorAdapter(SearchCriteria searchCriteria, Nd nd) {
            this.searchCriteria = searchCriteria;
            this.nd = nd;
        }

        @Override
        public int compare(long address) throws IndexException {
            IString key = FieldSearchIndex.this.searchKey.get(this.nd, address);
            if (this.searchCriteria.isPrefixSearch()) {
                return key.comparePrefix(this.searchCriteria.getSearchString(), false);
            }
            return key.compareCompatibleWithIgnoreCase(this.searchCriteria.getSearchString());
        }

        @Override
        public boolean visit(long address) throws IndexException {
            short nodeType;
            if (this.searchCriteria.requiresSpecificNodeType() && !this.searchCriteria.acceptsNodeType(nodeType = NdNode.NODE_TYPE.get(this.nd, address))) {
                return true;
            }
            IString key = FieldSearchIndex.this.searchKey.get(this.nd, address);
            if (this.searchCriteria.isMatchingCase() && (this.searchCriteria.isPrefixSearch() ? key.comparePrefix(this.searchCriteria.getSearchString(), true) != 0 : key.compare(this.searchCriteria.getSearchString(), true) != 0)) {
                return true;
            }
            return this.acceptResult(address);
        }

        protected abstract boolean acceptResult(long var1);
    }

    public static interface Visitor<T> {
        public boolean visit(T var1);
    }
}

