/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.markers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.genericeditor.markers.MarkerHoverControlCreator;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class MarkerAnnotationHover
implements ITextHoverExtension,
ITextHoverExtension2,
ITextHover {
    protected static boolean isIncluded(Annotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        AnnotationPreference preference = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
        if (preference == null) {
            return false;
        }
        String key = preference.getTextPreferenceKey();
        return !(key != null ? !EditorsUI.getPreferenceStore().getBoolean(key) : (key = preference.getHighlightPreferenceKey()) == null || !EditorsUI.getPreferenceStore().getBoolean(key));
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object hoverInfo = this.getHoverInfo2(textViewer, hoverRegion);
        if (hoverInfo == null) {
            return null;
        }
        return hoverInfo.toString();
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (!(textViewer instanceof ISourceViewerExtension2)) {
            return null;
        }
        ISourceViewerExtension2 viewer = (ISourceViewerExtension2)textViewer;
        List<MarkerAnnotation> annotations = MarkerAnnotationHover.findMarkerAnnotations(viewer, (IRegion)new Region(offset, 0));
        if (annotations.isEmpty()) {
            return null;
        }
        int highestOffsetStart = 0;
        int lowestOffsetEnd = Integer.MAX_VALUE;
        IAnnotationModel annotationModel = viewer.getVisualAnnotationModel();
        for (Annotation annotation : annotations) {
            Position position = annotationModel.getPosition(annotation);
            highestOffsetStart = Math.max(highestOffsetStart, position.getOffset());
            lowestOffsetEnd = Math.min(lowestOffsetEnd, position.getOffset() + position.getLength());
        }
        return new Region(highestOffsetStart, Math.max(0, lowestOffsetEnd - highestOffsetStart));
    }

    public List<IMarker> getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (!(textViewer instanceof ISourceViewerExtension2)) {
            return null;
        }
        List<MarkerAnnotation> annotations = MarkerAnnotationHover.findMarkerAnnotations((ISourceViewerExtension2)textViewer, hoverRegion);
        if (annotations.isEmpty()) {
            return null;
        }
        ArrayList<IMarker> markers = new ArrayList<IMarker>(annotations.size());
        for (MarkerAnnotation annotation : annotations) {
            markers.add(annotation.getMarker());
        }
        return markers;
    }

    private static List<MarkerAnnotation> findMarkerAnnotations(ISourceViewerExtension2 viewer, IRegion region) {
        ArrayList<MarkerAnnotation> res = new ArrayList<MarkerAnnotation>();
        IAnnotationModel annotationModel = viewer.getVisualAnnotationModel();
        annotationModel.getAnnotationIterator().forEachRemaining(annotation -> {
            if (MarkerAnnotationHover.isIncluded(annotation)) {
                Position position = annotationModel.getPosition(annotation);
                if (region.getOffset() >= position.getOffset() && region.getOffset() + region.getLength() <= position.getOffset() + position.getLength()) {
                    res.add((MarkerAnnotation)annotation);
                }
            }
        });
        return res;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new MarkerHoverControlCreator();
    }
}

