/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.ui.authenticator;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jsch.core.IJSchLocation;
import org.eclipse.jsch.internal.core.IUserAuthenticator;
import org.eclipse.jsch.internal.core.IUserInfo;
import org.eclipse.jsch.internal.ui.Messages;
import org.eclipse.jsch.internal.ui.authenticator.KeyboardInteractiveDialog;
import org.eclipse.jsch.internal.ui.authenticator.UserValidationDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WorkbenchUserAuthenticator
implements IUserAuthenticator {
    public void promptForUserInfo(final IJSchLocation location, final IUserInfo userinfo, final String message) {
        final String[] result = new String[2];
        Display display = Display.getCurrent();
        final boolean[] allowCaching = new boolean[1];
        if (display != null) {
            allowCaching[0] = this.promptForPassword(location, userinfo.getUsername(), message, userinfo.isUsernameMutable(), result);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    allowCaching[0] = WorkbenchUserAuthenticator.this.promptForPassword(location, userinfo.getUsername(), message, userinfo.isUsernameMutable(), result);
                }
            });
        }
        if (result[0] == null) {
            throw new OperationCanceledException(Messages.WorkbenchUserAuthenticator_cancelled);
        }
        if (userinfo.isUsernameMutable()) {
            userinfo.setUsername(result[0]);
        }
        userinfo.setPassword(result[1]);
        if (location != null) {
            if (userinfo.isUsernameMutable()) {
                location.setUsername(result[0]);
            }
            location.setPassword(result[1]);
            if (location.getPasswordStore() != null) {
                if (allowCaching[0]) {
                    location.getPasswordStore().update(location);
                } else {
                    location.getPasswordStore().clear(location);
                }
            }
        }
    }

    protected boolean promptForPassword(IJSchLocation location, String username, String message, boolean userMutable, String[] result) {
        String comment = location == null ? null : location.getComment();
        UserValidationDialog dialog = new UserValidationDialog(null, comment, username == null ? "" : username, message, location != null && location.getPasswordStore() != null);
        dialog.setUsernameMutable(userMutable);
        dialog.open();
        result[0] = dialog.getUsername();
        result[1] = dialog.getPassword();
        return dialog.getAllowCaching();
    }

    public String[] promptForKeyboradInteractive(final IJSchLocation location, final String destination, final String name, final String instruction, final String[] prompt, final boolean[] echo) {
        final String[][] result = new String[1][];
        final boolean[] allowCaching = new boolean[1];
        Display display = Display.getCurrent();
        if (display != null) {
            result[0] = this._promptForUserInteractive(location, destination, name, instruction, prompt, echo, allowCaching);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = WorkbenchUserAuthenticator.this._promptForUserInteractive(location, destination, name, instruction, prompt, echo, allowCaching);
                }
            });
        }
        if (result[0] != null && location != null && prompt != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
            location.setPassword(result[0][0]);
            if (location.getPasswordStore() != null) {
                if (allowCaching[0]) {
                    location.getPasswordStore().update(location);
                } else {
                    location.getPasswordStore().clear(location);
                }
            }
        }
        return result[0];
    }

    protected String[] _promptForUserInteractive(IJSchLocation location, String destination, String name, String instruction, String[] prompt, boolean[] echo, boolean[] allowCaching) {
        String comment = location == null ? null : location.getComment();
        String username = location == null ? "" : location.getUsername();
        KeyboardInteractiveDialog dialog = new KeyboardInteractiveDialog(null, comment, destination, name, username, instruction, prompt, echo);
        dialog.setUsernameMutable(false);
        dialog.open();
        String[] _result = dialog.getResult();
        if (_result != null) {
            allowCaching[0] = dialog.getAllowCaching();
        }
        return _result;
    }

    public int prompt(IJSchLocation location, final int promptType, final String title, final String message, int[] promptResponses, int defaultResponse) {
        final Display display = this.getStandardDisplay();
        final int[] retval = new int[1];
        final String[] buttons = new String[promptResponses.length];
        int i = 0;
        while (i < promptResponses.length) {
            int prompt = promptResponses[i];
            switch (prompt) {
                case 0: {
                    buttons[i] = IDialogConstants.OK_LABEL;
                    break;
                }
                case 1: {
                    buttons[i] = IDialogConstants.CANCEL_LABEL;
                    break;
                }
                case 3: {
                    buttons[i] = IDialogConstants.NO_LABEL;
                    break;
                }
                case 2: {
                    buttons[i] = IDialogConstants.YES_LABEL;
                }
            }
            ++i;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(new Shell(display), title, null, message, promptType, buttons, 1);
                retval[0] = dialog.open();
            }
        });
        return retval[0];
    }

    public boolean promptForHostKeyChange(final IJSchLocation location) {
        final boolean[] openConfirm = new boolean[1];
        Display display = this.getStandardDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                openConfirm[0] = MessageDialog.openConfirm(null, (String)Messages.WorkbenchUserAuthenticator_1, (String)NLS.bind((String)Messages.WorkbenchUserAuthenticator_2, (Object[])new String[]{location.getHost()}));
            }
        });
        if (!openConfirm[0]) {
            throw new OperationCanceledException();
        }
        return openConfirm[0];
    }

    private Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

