/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.servlet.PrioritizedFilter;
import org.eclipse.help.webapp.IFilter;

public class ExtraFilters
implements IFilter {
    public static final String CONTENTFILTER_XP_NAME = "org.eclipse.help.webapp.contentFilter";
    private static List<PrioritizedFilter> filters = null;

    public ExtraFilters() {
        if (filters == null) {
            this.readFilters();
        }
    }

    private void readFilters() {
        IConfigurationElement[] elements;
        filters = new ArrayList<PrioritizedFilter>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(CONTENTFILTER_XP_NAME);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Object obj = null;
            try {
                obj = element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                HelpWebappPlugin.logError("Create extension failed:[org.eclipse.help.webapp.contentFilter].", e);
            }
            if (obj instanceof IFilter) {
                int priority = 0;
                String priStr = element.getAttribute("priority");
                if (priStr != null && !"".equals(priStr)) {
                    try {
                        priority = Integer.parseInt(priStr);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                PrioritizedFilter filter = new PrioritizedFilter((IFilter)obj, priority);
                filters.add(filter);
            }
            ++n2;
        }
        ExtraFilters.sortFilters();
    }

    private static void sortFilters() {
        Collections.sort(filters);
        Collections.reverse(filters);
    }

    public static void setFilters(PrioritizedFilter[] newFilters) {
        filters = new ArrayList<PrioritizedFilter>();
        Collections.addAll(filters, newFilters);
        ExtraFilters.sortFilters();
    }

    @Override
    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        int index = 0;
        while (index < filters.size()) {
            PrioritizedFilter filter = filters.get(index);
            out = filter.filter(req, out);
            ++index;
        }
        return out;
    }
}

