/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.dom.properties.css2;

import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyFontCompositeHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyFontHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.exceptions.UnsupportedPropertyException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractCSSPropertyFontHandler
extends AbstractCSSPropertyFontCompositeHandler
implements ICSSPropertyFontHandler {
    @Override
    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (property == null) {
            return false;
        }
        switch (property) {
            case "font": {
                this.applyCSSPropertyFont(element, value, pseudo, engine);
                break;
            }
            case "font-family": {
                this.applyCSSPropertyFontFamily(element, value, pseudo, engine);
                break;
            }
            case "font-size": {
                this.applyCSSPropertyFontSize(element, value, pseudo, engine);
                break;
            }
            case "font-adjust": {
                this.applyCSSPropertyFontSizeAdjust(element, value, pseudo, engine);
                break;
            }
            case "font-stretch": {
                this.applyCSSPropertyFontStretch(element, value, pseudo, engine);
                break;
            }
            case "font-style": {
                this.applyCSSPropertyFontStyle(element, value, pseudo, engine);
                break;
            }
            case "font-variant": {
                this.applyCSSPropertyFontVariant(element, value, pseudo, engine);
                break;
            }
            case "font-weight": {
                this.applyCSSPropertyFontWeight(element, value, pseudo, engine);
            }
        }
        return false;
    }

    @Override
    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "font-family": {
                return this.retrieveCSSPropertyFontFamily(element, pseudo, engine);
            }
            case "font-size": {
                return this.retrieveCSSPropertyFontSize(element, pseudo, engine);
            }
            case "font-adjust": {
                return this.retrieveCSSPropertyFontAdjust(element, pseudo, engine);
            }
            case "font-stretch": {
                return this.retrieveCSSPropertyFontStretch(element, pseudo, engine);
            }
            case "font-style": {
                return this.retrieveCSSPropertyFontStyle(element, pseudo, engine);
            }
            case "font-variant": {
                return this.retrieveCSSPropertyFontVariant(element, pseudo, engine);
            }
            case "font-weight": {
                return this.retrieveCSSPropertyFontWeight(element, pseudo, engine);
            }
        }
        return null;
    }

    @Override
    public void applyCSSPropertyFont(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        super.applyCSSPropertyComposite(element, "font", value, pseudo, engine);
    }

    @Override
    public void applyCSSPropertyFontFamily(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (element instanceof CSS2FontProperties) {
            this.applyCSSPropertyFontFamily((CSS2FontProperties)element, value, pseudo, engine);
            return;
        }
        throw new UnsupportedPropertyException("font-family");
    }

    protected void applyCSSPropertyFontFamily(CSS2FontProperties font, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            font.setFamily((CSSPrimitiveValue)value);
        }
    }

    @Override
    public void applyCSSPropertyFontSize(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (element instanceof CSS2FontProperties) {
            this.applyCSSPropertyFontSize((CSS2FontProperties)element, value, pseudo, engine);
            return;
        }
        throw new UnsupportedPropertyException("font-size");
    }

    protected void applyCSSPropertyFontSize(CSS2FontProperties font, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            font.setSize((CSSPrimitiveValue)value);
        }
    }

    @Override
    public void applyCSSPropertyFontSizeAdjust(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        throw new UnsupportedPropertyException("font-adjust");
    }

    @Override
    public void applyCSSPropertyFontStretch(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        throw new UnsupportedPropertyException("font-stretch");
    }

    @Override
    public void applyCSSPropertyFontStyle(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (element instanceof CSS2FontProperties) {
            this.applyCSSPropertyFontStyle((CSS2FontProperties)element, value, pseudo, engine);
            return;
        }
        throw new UnsupportedPropertyException("font-style");
    }

    protected void applyCSSPropertyFontStyle(CSS2FontProperties font, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            font.setStyle((CSSPrimitiveValue)value);
        }
    }

    @Override
    public void applyCSSPropertyFontVariant(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        throw new UnsupportedPropertyException("font-variant");
    }

    @Override
    public void applyCSSPropertyFontWeight(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (element instanceof CSS2FontProperties) {
            this.applyCSSPropertyFontWeight((CSS2FontProperties)element, value, pseudo, engine);
            return;
        }
        throw new UnsupportedPropertyException("font-weight");
    }

    protected void applyCSSPropertyFontWeight(CSS2FontProperties font, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            font.setWeight((CSSPrimitiveValue)value);
        }
    }
}

