/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.EngineDescriptorManager;
import org.eclipse.help.ui.internal.views.LocalScopeDialog;
import org.eclipse.help.ui.internal.views.RenameDialog;
import org.eclipse.help.ui.internal.views.ScopePreferenceDialog;
import org.eclipse.help.ui.internal.views.ScopePreferenceManager;
import org.eclipse.help.ui.internal.views.ScopeSet;
import org.eclipse.help.ui.internal.views.ScopeSetManager;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class ScopeSetDialog
extends TrayDialog {
    private ScopeSetManager manager;
    private EngineDescriptorManager descManager;
    private static final int NEW_ID = 1025;
    private static final int EDIT_ID = 1026;
    private static final int RENAME_ID = 1027;
    private static final int REMOVE_ID = 1028;
    private Button editButton;
    private Button renameButton;
    private Button removeButton;
    private ArrayList<ScopeSet> sets;
    private ArrayList<PendingOperation> operations;
    private IStructuredContentProvider contentProvider;
    private Button showAllRadio;
    private Button showSelectedRadio;
    private ILabelProvider labelProvider;
    private Object input;
    private TableViewer viewer;
    private int widthInChars = 55;
    private int heightInChars = 15;
    private ScopeSet initialSelection;
    private Object[] result;
    private boolean localOnly;

    public ScopeSetDialog(Shell parent, ScopeSetManager manager, EngineDescriptorManager descManager, boolean localOnly) {
        super(parent);
        this.manager = manager;
        this.descManager = descManager;
        this.sets = this.extractSets(manager.getScopeSets(false));
        this.localOnly = localOnly;
        this.contentProvider = new ScopeContentProvider();
        this.labelProvider = new ScopeLabelProvider();
        this.setInitialSelections(manager.getActiveSet());
    }

    private void setInitialSelections(ScopeSet scopeSet) {
        this.initialSelection = scopeSet;
    }

    private ArrayList<ScopeSet> extractSets(ScopeSet[] array) {
        ArrayList<ScopeSet> list = new ArrayList<ScopeSet>();
        Collections.addAll(list, array);
        return list;
    }

    protected Control createDialogArea(Composite container) {
        Composite innerContainer = (Composite)super.createDialogArea(container);
        this.createRadioButtons(innerContainer);
        this.createTable(innerContainer);
        this.enableTable();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)innerContainer, "org.eclipse.help.ui.searchScope");
        this.createEditingButtons(innerContainer);
        this.viewer.addSelectionChangedListener(event -> this.updateButtons());
        ViewerFilter[] filters = new ViewerFilter[]{new NonDefaultFilter()};
        this.viewer.setFilters(filters);
        return innerContainer;
    }

    private void createRadioButtons(Composite parent) {
        boolean showAll = this.initialSelection != null && this.initialSelection.isDefault();
        this.showAllRadio = new Button(parent, 16);
        this.showAllRadio.setText(Messages.ScopeSet_selectAll);
        this.showSelectedRadio = new Button(parent, 16);
        this.showSelectedRadio.setText(Messages.ScopeSet_selectWorkingSet);
        this.showAllRadio.addSelectionListener((SelectionListener)new ShowAllListener());
        this.showAllRadio.setSelection(showAll);
        this.showSelectedRadio.setSelection(!showAll);
    }

    private void createTable(Composite parent) {
        this.viewer = new TableViewer(parent, 2820);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput(this.input);
        this.viewer.addDoubleClickListener(event -> this.okPressed());
        if (this.initialSelection != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.initialSelection));
        }
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(this.heightInChars);
        gd.widthHint = this.convertWidthInCharsToPixels(this.widthInChars);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)gd);
        table.setFont(parent.getFont());
    }

    private void enableTable() {
        if (this.viewer != null) {
            Object firstElement;
            boolean showSelected = this.showSelectedRadio.getSelection();
            this.viewer.getTable().setEnabled(showSelected);
            this.viewer.refresh();
            if (showSelected && this.viewer.getSelection().isEmpty() && (firstElement = this.viewer.getElementAt(0)) != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection(firstElement));
            }
        }
    }

    private void createEditingButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        this.createButton(buttonComposite, 1025, Messages.ScopeSetDialog_new, false);
        this.renameButton = this.createButton(buttonComposite, 1027, Messages.ScopeSetDialog_rename, false);
        this.editButton = this.createButton(buttonComposite, 1026, Messages.ScopeSetDialog_edit, false);
        this.removeButton = this.createButton(buttonComposite, 1028, Messages.ScopeSetDialog_remove, false);
        this.updateButtons();
    }

    public ScopeSet getActiveSet() {
        if (this.result != null && this.result.length > 0) {
            return (ScopeSet)this.result[0];
        }
        return null;
    }

    protected void okPressed() {
        if (this.operations != null) {
            int i = 0;
            while (i < this.operations.size()) {
                PendingOperation operation = this.operations.get(i);
                operation.commit();
                ++i;
            }
            this.operations = null;
        }
        if (this.showAllRadio.getSelection()) {
            this.setResult(this.manager.getDefaultScope());
        } else {
            IStructuredSelection selection = this.viewer.getStructuredSelection();
            this.setResult(selection.toList());
        }
        super.okPressed();
    }

    private void setResult(ScopeSet scope) {
        this.result = new Object[]{scope};
    }

    private void setResult(List<?> newResult) {
        if (newResult == null) {
            this.result = null;
        } else {
            this.result = new Object[newResult.size()];
            newResult.toArray(this.result);
        }
    }

    protected void cancelPressed() {
        if (this.operations != null) {
            int i = 0;
            while (i < this.operations.size()) {
                PendingOperation operation = this.operations.get(i);
                operation.cancel();
                ++i;
            }
            this.operations = null;
        }
        super.cancelPressed();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.doNew();
                this.doEdit();
                break;
            }
            case 1026: {
                this.doEdit();
                break;
            }
            case 1027: {
                this.doRename();
                break;
            }
            case 1028: {
                this.doRemove();
            }
        }
        super.buttonPressed(buttonId);
    }

    private void doNew() {
        ScopeSet newSet = new ScopeSet(this.getDefaultName());
        String name = this.getNewName(newSet.getName(), false);
        if (name != null) {
            newSet.setName(name);
            this.scheduleOperation(new AddOperation(newSet));
            this.sets.add(newSet);
            this.viewer.refresh();
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)newSet));
            this.updateButtons();
        }
    }

    private String getDefaultName() {
        HashSet<String> namesInUse = new HashSet<String>();
        int i = 0;
        while (i < this.sets.size()) {
            ScopeSet set = this.sets.get(i);
            namesInUse.add(set.getName().toLowerCase());
            ++i;
        }
        i = 1;
        while (i < 1000) {
            String name = String.valueOf(Messages.ScopeSetDialog_defaultName) + i;
            if (!namesInUse.contains(name.toLowerCase())) {
                return name;
            }
            ++i;
        }
        return "";
    }

    private void doEdit() {
        IStructuredSelection ssel = this.viewer.getStructuredSelection();
        ScopeSet set = (ScopeSet)ssel.getFirstElement();
        if (set == null) {
            return;
        }
        ScopePreferenceManager manager = new ScopePreferenceManager(this.descManager, set);
        if (!this.localOnly) {
            ScopePreferenceDialog dialog = new ScopePreferenceDialog(this.getShell(), manager, this.descManager, set.isEditable());
            dialog.setPreferenceStore(set.getPreferenceStore());
            dialog.create();
            dialog.getShell().setText(NLS.bind((String)Messages.ScopePreferenceDialog_wtitle, (Object)set.getName()));
            dialog.open();
        } else {
            LocalScopeDialog localDialog = new LocalScopeDialog(this.getShell(), manager, this.descManager, set);
            localDialog.create();
            localDialog.getShell().setText(NLS.bind((String)Messages.ScopePreferenceDialog_wtitle, (Object)set.getName()));
            localDialog.open();
        }
    }

    private void doRename() {
        RenameOperation rop;
        String oldName;
        String newName;
        IStructuredSelection ssel = this.viewer.getStructuredSelection();
        ScopeSet set = (ScopeSet)ssel.getFirstElement();
        if (set != null && (newName = this.getNewName(oldName = (rop = (RenameOperation)this.findOperation(set, RenameOperation.class)) != null ? rop.newName : set.getName(), true)) != null) {
            if (rop != null) {
                rop.newName = newName;
            } else {
                this.scheduleOperation(new RenameOperation(set, newName));
            }
            this.viewer.update((Object)set, null);
            this.updateButtons();
        }
    }

    private String getNewName(String oldName, boolean isRename) {
        RenameDialog dialog = new RenameDialog(this.getShell(), oldName);
        int i = 0;
        while (i < this.sets.size()) {
            ScopeSet set = this.sets.get(i);
            dialog.addOldName(set.getName());
            ++i;
        }
        dialog.create();
        String dialogTitle = isRename ? Messages.RenameDialog_wtitle : Messages.NewDialog_wtitle;
        dialog.getShell().setText(dialogTitle);
        if (dialog.open() == 0) {
            return dialog.getNewName();
        }
        return null;
    }

    private void doRemove() {
        IStructuredSelection ssel = this.viewer.getStructuredSelection();
        ScopeSet set = (ScopeSet)ssel.getFirstElement();
        if (set != null) {
            this.scheduleOperation(new RemoveOperation(set));
            this.sets.remove(set);
            this.viewer.refresh();
            Object element = this.viewer.getElementAt(0);
            if (element != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection(element));
            }
            this.updateButtons();
        }
    }

    private void scheduleOperation(PendingOperation op) {
        if (this.operations == null) {
            this.operations = new ArrayList();
        }
        this.operations.add(op);
    }

    private void updateButtons() {
        IStructuredSelection ssel = this.viewer.getStructuredSelection();
        this.editButton.setEnabled(!ssel.isEmpty());
        ScopeSet set = (ScopeSet)ssel.getFirstElement();
        boolean editableSet = set != null && set.isEditable() && !set.isImplicit();
        this.removeButton.setEnabled(editableSet);
        this.renameButton.setEnabled(editableSet);
    }

    private PendingOperation findOperation(ScopeSet set, Class<?> type) {
        if (this.operations != null) {
            int i = 0;
            while (i < this.operations.size()) {
                PendingOperation op = this.operations.get(i);
                if (op.getClass().equals(type) && op.set.equals(set)) {
                    return op;
                }
                ++i;
            }
        }
        return null;
    }

    public void setInput(ScopeSetManager scopeSetManager) {
        this.input = scopeSetManager;
    }

    private class AddOperation
    extends PendingOperation {
        public AddOperation(ScopeSet set) {
            super(set);
        }

        @Override
        public void commit() {
            ScopeSetDialog.this.manager.add(this.set);
        }

        @Override
        public void cancel() {
            this.set.dispose();
        }
    }

    public class NonDefaultFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof ScopeSet) || !((ScopeSet)element).isDefault();
        }
    }

    private abstract class PendingOperation {
        ScopeSet set;

        public PendingOperation(ScopeSet set) {
            this.set = set;
        }

        public abstract void commit();

        public abstract void cancel();
    }

    private class RemoveOperation
    extends PendingOperation {
        public RemoveOperation(ScopeSet set) {
            super(set);
        }

        @Override
        public void commit() {
            ScopeSetDialog.this.manager.remove(this.set);
        }

        @Override
        public void cancel() {
        }
    }

    private class RenameOperation
    extends PendingOperation {
        private String newName;

        public RenameOperation(ScopeSet set, String newName) {
            super(set);
            this.newName = newName;
        }

        @Override
        public void commit() {
            this.set.setName(this.newName);
        }

        @Override
        public void cancel() {
        }
    }

    private class ScopeContentProvider
    implements IStructuredContentProvider {
        private ScopeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ScopeSetDialog.this.sets.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ScopeLabelProvider
    extends LabelProvider {
        private ScopeLabelProvider() {
        }

        public String getText(Object obj) {
            String name = this.findNewName((ScopeSet)obj);
            if (name != null) {
                return name;
            }
            return ((ScopeSet)obj).getName();
        }

        private String findNewName(ScopeSet set) {
            PendingOperation op = ScopeSetDialog.this.findOperation(set, RenameOperation.class);
            if (op != null) {
                RenameOperation rop = (RenameOperation)op;
                return rop.newName;
            }
            return null;
        }

        public Image getImage(Object obj) {
            return HelpUIResources.getImage("obj16/scopeset_obj.png");
        }
    }

    public class ShowAllListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            ScopeSetDialog.this.enableTable();
        }
    }
}

