/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search2.internal.ui.text.EditorAnnotationManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class WindowAnnotationManager {
    private IWorkbenchWindow fWindow;
    private Map<IEditorPart, EditorAnnotationManager> fAnnotationManagers;
    private IPartListener2 fPartListener;
    private ArrayList<AbstractTextSearchResult> fSearchResults;

    public WindowAnnotationManager(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fAnnotationManagers = new HashMap<IEditorPart, EditorAnnotationManager>();
        this.fSearchResults = new ArrayList();
        this.initEditors();
        this.fPartListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
                WindowAnnotationManager.this.startHighlighting(WindowAnnotationManager.this.getEditor(partRef));
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                WindowAnnotationManager.this.startHighlighting(WindowAnnotationManager.this.getEditor(partRef));
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                WindowAnnotationManager.this.stopHighlighting(WindowAnnotationManager.this.getEditor(partRef));
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                WindowAnnotationManager.this.stopHighlighting(WindowAnnotationManager.this.getEditor(partRef));
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                WindowAnnotationManager.this.startHighlighting(WindowAnnotationManager.this.getEditor(partRef));
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
                WindowAnnotationManager.this.updateHighlighting(WindowAnnotationManager.this.getEditor(partRef));
            }
        };
        this.fWindow.getPartService().addPartListener(this.fPartListener);
    }

    private void startHighlighting(IEditorPart editor) {
        if (editor == null) {
            return;
        }
        EditorAnnotationManager mgr = this.fAnnotationManagers.get(editor);
        if (mgr == null) {
            mgr = new EditorAnnotationManager(editor);
            this.fAnnotationManagers.put(editor, mgr);
            mgr.setSearchResults(this.fSearchResults);
        }
    }

    private void updateHighlighting(IEditorPart editor) {
        if (editor == null) {
            return;
        }
        EditorAnnotationManager mgr = this.fAnnotationManagers.get(editor);
        if (mgr != null) {
            mgr.doEditorInputChanged();
        }
    }

    private void initEditors() {
        IWorkbenchPage[] pages;
        IWorkbenchPage[] iWorkbenchPageArray = pages = this.fWindow.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] editors;
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
            int n3 = editors.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference editor2 = iEditorReferenceArray[n4];
                IEditorPart editor = editor2.getEditor(false);
                if (editor != null && page.isPartVisible((IWorkbenchPart)editor)) {
                    this.startHighlighting(editor);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void stopHighlighting(IEditorPart editor) {
        if (editor == null) {
            return;
        }
        EditorAnnotationManager mgr = this.fAnnotationManagers.remove(editor);
        if (mgr != null) {
            mgr.dispose();
        }
    }

    private IEditorPart getEditor(IWorkbenchPartReference partRef) {
        if (partRef instanceof IEditorReference) {
            return ((IEditorReference)partRef).getEditor(false);
        }
        return null;
    }

    void dispose() {
        this.fWindow.getPartService().removePartListener(this.fPartListener);
        for (EditorAnnotationManager mgr : this.fAnnotationManagers.values()) {
            mgr.dispose();
        }
        this.fAnnotationManagers = null;
    }

    void addSearchResult(AbstractTextSearchResult result) {
        boolean alreadyShown = this.fSearchResults.contains(result);
        this.fSearchResults.add(result);
        if (!alreadyShown) {
            for (EditorAnnotationManager mgr : this.fAnnotationManagers.values()) {
                mgr.addSearchResult(result);
            }
        }
    }

    void removeSearchResult(AbstractTextSearchResult result) {
        this.fSearchResults.remove(result);
        boolean stillShown = this.fSearchResults.contains(result);
        if (!stillShown) {
            for (EditorAnnotationManager mgr : this.fAnnotationManagers.values()) {
                mgr.removeSearchResult(result);
            }
        }
    }
}

