/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.databinding.typed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.SimpleListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;

public class WorkbenchProperties {
    public static <S, T> IValueProperty<S, T> adaptedValue(Class<T> adapter) {
        return WorkbenchProperties.adaptedValue(adapter, Platform.getAdapterManager());
    }

    public static <S, T> IValueProperty<S, T> adaptedValue(Class<T> adapter, IAdapterManager adapterManager) {
        return new AdaptedValueProperty(adapter, adapterManager);
    }

    public static <S extends ISelectionService, T> IValueProperty<S, T> singleSelection() {
        return WorkbenchProperties.singleSelection(null, false);
    }

    public static <S extends ISelectionService, T> IValueProperty<S, T> singleSelection(String partId, boolean postSelection) {
        return WorkbenchProperties.singleSelection(partId, postSelection, Object.class);
    }

    public static <S extends ISelectionService, T> IValueProperty<S, T> singleSelection(String partId, boolean postSelection, Class<T> valueType) {
        return new SingleSelectionProperty(partId, postSelection, valueType);
    }

    public static <S extends ISelectionService, E> IListProperty<S, E> multipleSelection() {
        return WorkbenchProperties.multipleSelection(Object.class);
    }

    public static <S extends ISelectionService, E> IListProperty<S, E> multipleSelection(Class<E> elementType) {
        return WorkbenchProperties.multipleSelection(null, false, elementType);
    }

    public static <S extends ISelectionService, E> IListProperty<S, E> multipleSelection(String partId, boolean postSelection) {
        return WorkbenchProperties.multipleSelection(partId, postSelection, Object.class);
    }

    public static <S extends ISelectionService, E> IListProperty<S, E> multipleSelection(String partId, boolean postSelection, Class<E> elementType) {
        return new MultiSelectionProperty(partId, postSelection, elementType);
    }

    private static final class AdaptedValueProperty<S, T>
    extends SimpleValueProperty<S, T> {
        private final Class<T> adapter;
        private final IAdapterManager adapterManager;

        private AdaptedValueProperty(Class<T> adapter, IAdapterManager adapterManager) {
            this.adapter = adapter;
            this.adapterManager = adapterManager;
        }

        public Object getValueType() {
            return this.adapter;
        }

        protected T doGetValue(S source) {
            if (this.adapter.isInstance(source)) {
                return (T)source;
            }
            return (T)this.adapterManager.getAdapter(source, this.adapter);
        }

        protected void doSetValue(S source, T value) {
            throw new UnsupportedOperationException();
        }

        public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ValueDiff<? extends T>> listener) {
            return null;
        }
    }

    private static class MultiSelectionProperty<S extends ISelectionService, E>
    extends SimpleListProperty<S, E> {
        private final String partId;
        private final boolean post;
        private final Object elementType;

        MultiSelectionProperty(String partId, boolean post, Object elementType) {
            this.partId = partId;
            this.post = post;
            this.elementType = elementType;
        }

        public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ListDiff<E>> listener) {
            return new SelectionServiceListener((IProperty)this, listener, this.partId, this.post);
        }

        public Object getElementType() {
            return this.elementType;
        }

        protected List<E> doGetList(S source) {
            ISelection selection = this.partId != null ? source.getSelection(this.partId) : source.getSelection();
            if (selection instanceof IStructuredSelection) {
                List list = ((IStructuredSelection)selection).toList();
                return new ArrayList(list);
            }
            return Collections.emptyList();
        }

        protected void doSetList(S source, List<E> list, ListDiff<E> diff) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SelectionServiceListener<S extends ISelectionService, D extends IDiff>
    extends NativePropertyListener<S, D>
    implements ISelectionListener {
        private final String partId;
        private final boolean post;

        private SelectionServiceListener(IProperty property, ISimplePropertyListener<S, D> wrapped, String partID, boolean post) {
            super(property, wrapped);
            this.partId = partID;
            this.post = post;
        }

        protected void doAddTo(S source) {
            S selectionService = source;
            if (this.post) {
                if (this.partId != null) {
                    selectionService.addPostSelectionListener(this.partId, this);
                } else {
                    selectionService.addPostSelectionListener(this);
                }
            } else if (this.partId != null) {
                selectionService.addSelectionListener(this.partId, this);
            } else {
                selectionService.addSelectionListener(this);
            }
        }

        protected void doRemoveFrom(S source) {
            S selectionService = source;
            if (this.post) {
                if (this.partId != null) {
                    selectionService.removePostSelectionListener(this.partId, this);
                } else {
                    selectionService.removePostSelectionListener(this);
                }
            } else if (this.partId != null) {
                selectionService.removeSelectionListener(this.partId, this);
            } else {
                selectionService.removeSelectionListener(this);
            }
        }

        @Override
        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            this.fireChange((ISelectionService)((Object)part), null);
        }
    }

    private static class SingleSelectionProperty<S extends ISelectionService, T>
    extends SimpleValueProperty<S, T> {
        private final String partId;
        private final boolean post;
        private final Object elementType;

        private SingleSelectionProperty(String partId, boolean post, Object elementType) {
            this.partId = partId;
            this.post = post;
            this.elementType = elementType;
        }

        public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ValueDiff<? extends T>> listener) {
            return new SelectionServiceListener((IProperty)this, listener, this.partId, this.post);
        }

        protected T doGetValue(S source) {
            ISelection selection = this.partId != null ? source.getSelection(this.partId) : source.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object elem = ((IStructuredSelection)selection).getFirstElement();
                return (T)elem;
            }
            return null;
        }

        protected void doSetValue(S source, T value) {
            throw new UnsupportedOperationException();
        }

        public Object getValueType() {
            return this.elementType;
        }
    }
}

