/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.Set;
import org.eclipse.ui.internal.preferences.IPropertyMap;
import org.eclipse.ui.internal.preferences.PropertyMapUnion;

public class PropertyUtil {
    private PropertyUtil() {
    }

    public static boolean isEqual(IPropertyMap map1, IPropertyMap map2) {
        Set map2Keys;
        Set map1Keys = map1.keySet();
        if (!map1Keys.equals(map2Keys = map2.keySet())) {
            return false;
        }
        for (String next : map1Keys) {
            if (map1.getValue(next, Object.class).equals(map2.getValue(next, Object.class))) continue;
            return false;
        }
        return true;
    }

    public static void copy(IPropertyMap destination, IPropertyMap source) {
        Set keys = source.keySet();
        for (String key : keys) {
            destination.setValue(key, source.getValue(key, Object.class));
        }
    }

    public static IPropertyMap union(IPropertyMap[] sources) {
        PropertyMapUnion result = new PropertyMapUnion();
        IPropertyMap[] iPropertyMapArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyMap map = iPropertyMapArray[n2];
            result.addMap(map);
            ++n2;
        }
        return result;
    }

    public static boolean get(IPropertyMap toRead, String propertyId, boolean defaultValue) {
        Boolean result = (Boolean)toRead.getValue(propertyId, Boolean.class);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static int get(IPropertyMap toRead, String propertyId, int defaultValue) {
        Integer result = (Integer)toRead.getValue(propertyId, Integer.class);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }
}

