/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.views.dependencies.OpenPluginDependenciesAction;
import org.eclipse.pde.internal.ui.views.features.action.CollapseAllAction;
import org.eclipse.pde.internal.ui.views.features.action.ContentProviderAction;
import org.eclipse.pde.internal.ui.views.features.action.FeatureAndPluginCopyAction;
import org.eclipse.pde.internal.ui.views.features.action.FilterFeatureChildAction;
import org.eclipse.pde.internal.ui.views.features.action.ShowCalleesContentProviderAction;
import org.eclipse.pde.internal.ui.views.features.action.ShowCallersContentProviderAction;
import org.eclipse.pde.internal.ui.views.features.action.ShowPluginsAction;
import org.eclipse.pde.internal.ui.views.features.action.ViewerFilterAction;
import org.eclipse.pde.internal.ui.views.features.support.FeatureIndex;
import org.eclipse.pde.internal.ui.views.features.support.FeatureInput;
import org.eclipse.pde.internal.ui.views.features.support.FeatureSupport;
import org.eclipse.pde.internal.ui.views.features.support.PluginSupport;
import org.eclipse.pde.internal.ui.views.features.viewer.FeatureElementComparer;
import org.eclipse.pde.internal.ui.views.features.viewer.FeatureViewerComparator;
import org.eclipse.pde.internal.ui.views.features.viewer.RootElementsFilteredTree;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class FeaturesView
extends ViewPart {
    private final Action fOpenAction = new Action(PDEUIMessages.FeaturesView_OpenAction_label){

        public void run() {
            FeaturesView.this.handleOpen();
        }
    };
    private final Collection<ViewerFilterAction> fViewerFilterActions = new ArrayList<ViewerFilterAction>();
    private final Collection<ViewerFilter> fViewerFilters = new ArrayList<ViewerFilter>();
    private PatternFilter fPatternFilter;
    private Action fShowPluginsAction;
    private TreeViewer fViewer;
    private Clipboard fClipboard;
    private Action fCopyAction;
    private FeatureIndex fFeatureIndex;

    public void createPartControl(Composite parent) {
        FeatureModelManager featureModelManager = FeatureSupport.getManager();
        FeatureInput input = new FeatureInput(featureModelManager);
        this.fFeatureIndex = new FeatureIndex(featureModelManager);
        FilteredTree filteredTree = this.createFilteredTree(parent);
        this.fViewer = filteredTree.getViewer();
        this.fPatternFilter = filteredTree.getPatternFilter();
        this.fViewerFilters.add((ViewerFilter)this.fPatternFilter);
        this.fClipboard = new Clipboard(parent.getDisplay());
        this.fCopyAction = new FeatureAndPluginCopyAction((StructuredViewer)this.fViewer, this.fClipboard);
        this.registerGlobalActions();
        this.contributeToActionBar(featureModelManager);
        this.hookContextMenu();
        this.initialiseViewer(input);
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        this.fFeatureIndex.dispose();
        this.fClipboard.dispose();
    }

    private FilteredTree createFilteredTree(Composite parent) {
        RootElementsFilteredTree filteredTree = new RootElementsFilteredTree(parent, 770);
        filteredTree.setInitialText(PDEUIMessages.FeaturesView_searchPlaceholder);
        PatternFilter patternFilter = filteredTree.getPatternFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        TreeViewer viewer = filteredTree.getViewer();
        viewer.setComparer((IElementComparer)new FeatureElementComparer());
        viewer.setLabelProvider((IBaseLabelProvider)new PDELabelProvider());
        viewer.addDoubleClickListener(event -> this.handleOpen());
        viewer.addSelectionChangedListener(event -> {
            Collection<?> selection = this.getViewerSelection();
            this.fOpenAction.setEnabled(!selection.isEmpty());
            this.fCopyAction.setEnabled(!selection.isEmpty());
        });
        return filteredTree;
    }

    private void initialiseViewer(FeatureInput input) {
        this.resetViewerFilters();
        this.fViewer.setComparator((ViewerComparator)new FeatureViewerComparator());
        this.fViewer.setInput((Object)input);
    }

    private void resetViewerFilters() {
        this.fViewer.setFilters(this.fViewerFilters.toArray(new ViewerFilter[this.fViewerFilters.size()]));
    }

    public void toggle(ViewerFilter filter) {
        if (this.fViewerFilters.contains(filter)) {
            this.fViewerFilters.remove(filter);
        } else {
            this.fViewerFilters.add(filter);
        }
        this.resetViewerFilters();
    }

    public boolean isActive(ViewerFilter filter) {
        return this.fViewerFilters.contains(filter);
    }

    private void setContentProvider(IContentProvider contentProvider, boolean supportsFilters, boolean supportsPlugins) {
        this.fViewer.setContentProvider(contentProvider);
        this.setViewerFilterActionsEnabled(supportsFilters);
        this.fShowPluginsAction.setEnabled(supportsPlugins);
        if (supportsFilters) {
            this.resetViewerFilters();
        } else {
            this.fViewer.setFilters(new ViewerFilter[]{this.fPatternFilter});
        }
    }

    private void setViewerFilterActionsEnabled(boolean supportsFilters) {
        for (ViewerFilterAction viewerFilterAction : this.fViewerFilterActions) {
            viewerFilterAction.setEnabled(supportsFilters);
        }
    }

    public void configureContent(Consumer<FeatureInput> configurator) {
        configurator.accept((FeatureInput)this.fViewer.getInput());
        this.fViewer.refresh();
    }

    private void registerGlobalActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
    }

    private void contributeToActionBar(FeatureModelManager featureModelManager) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)new CollapseAllAction(this.fViewer));
        toolBarManager.add((IContributionItem)new Separator());
        ShowCalleesContentProviderAction calleesAction = new ShowCalleesContentProviderAction(this, featureModelManager);
        calleesAction.setChecked(true);
        toolBarManager.add((IAction)calleesAction);
        ShowCallersContentProviderAction callersAction = new ShowCallersContentProviderAction(this, featureModelManager, this.fFeatureIndex);
        toolBarManager.add((IAction)callersAction);
        toolBarManager.add((IContributionItem)new Separator());
        FilterFeatureChildAction filterFeatureChildAction = new FilterFeatureChildAction(this, this.fFeatureIndex);
        filterFeatureChildAction.setChecked(true);
        toolBarManager.add((IAction)filterFeatureChildAction);
        this.fShowPluginsAction = new ShowPluginsAction(this);
        toolBarManager.add((IAction)this.fShowPluginsAction);
        this.setContentProvider(calleesAction);
        this.setContentProvider(callersAction);
        this.registerFilterAction(filterFeatureChildAction);
        actionBars.updateActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this::fillContextMenu);
        Menu menu = menuManager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fOpenAction);
        IPluginModelBase selectedPluginModel = this.getSelectedPluginModel();
        if (selectedPluginModel != null) {
            OpenPluginDependenciesAction dependenciesAction = new OpenPluginDependenciesAction(selectedPluginModel);
            manager.add((IAction)dependenciesAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fCopyAction);
    }

    private void registerFilterAction(ViewerFilterAction filterAction) {
        this.fViewerFilterActions.add(filterAction);
        if (!filterAction.isChecked()) {
            this.fViewerFilters.add(filterAction.getViewerFilter());
        }
    }

    public void setContentProvider(ContentProviderAction contentProviderAction) {
        if (contentProviderAction.isChecked()) {
            this.setContentProvider(contentProviderAction.createContentProvider(), contentProviderAction.isSupportsFilters(), contentProviderAction.isSupportsPlugins());
        }
    }

    private void handleOpen() {
        for (Object selection : this.getViewerSelection()) {
            IFeatureModel featureModel = FeatureSupport.toFeatureModel(selection);
            if (featureModel != null) {
                FeatureEditor.openFeatureEditor(featureModel);
                continue;
            }
            IPluginModelBase pluginModel = PluginSupport.toPluginModel(selection);
            if (pluginModel == null) continue;
            ManifestEditor.openPluginEditor(pluginModel);
        }
    }

    private Collection<?> getViewerSelection() {
        return this.fViewer.getStructuredSelection().toList();
    }

    private IPluginModelBase getSelectedPluginModel() {
        return PluginSupport.toSinglePluginModel((IStructuredSelection)this.fViewer.getStructuredSelection());
    }
}

