/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.features.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class FeatureIndex
implements IFeatureModelListener {
    private final Map<String, Collection<IFeatureModel>> fIncludingFeatures = new HashMap<String, Collection<IFeatureModel>>();
    private final FeatureModelManager fFeatureModelManager;

    public FeatureIndex(FeatureModelManager featureModelManager) {
        this.fFeatureModelManager = featureModelManager;
        this.fFeatureModelManager.addFeatureModelListener((IFeatureModelListener)this);
        this.reIndex();
    }

    public Collection<IFeatureModel> getIncludingFeatures(String childId) {
        return this.fIncludingFeatures.getOrDefault(childId, Collections.emptySet());
    }

    public void dispose() {
        this.fFeatureModelManager.removeFeatureModelListener((IFeatureModelListener)this);
    }

    private void reIndex() {
        this.fIncludingFeatures.clear();
        IFeatureModel[] iFeatureModelArray = this.fFeatureModelManager.getModels();
        int n = iFeatureModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel parentModel = iFeatureModelArray[n2];
            IFeatureChild[] iFeatureChildArray = parentModel.getFeature().getIncludedFeatures();
            int n3 = iFeatureChildArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IFeatureChild child = iFeatureChildArray[n4];
                IFeatureModel childModel = this.fFeatureModelManager.findFeatureModel(child.getId());
                if (childModel != null) {
                    this.index(childModel, parentModel);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void index(IFeatureModel childModel, IFeatureModel parentModel) {
        String childId = childModel.getFeature().getId();
        Collection parents = this.fIncludingFeatures.computeIfAbsent(childId, key -> new HashSet());
        parents.add(parentModel);
    }

    public void modelsChanged(IFeatureModelDelta delta) {
        this.reIndex();
    }
}

