/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.internal.decorators.DecoratableResource;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceAdapter;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceGroup;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceHelper;
import org.eclipse.egit.ui.internal.resources.IResourceState;
import org.eclipse.egit.ui.internal.resources.ResourceStateFactory;
import org.eclipse.jgit.lib.Repository;

public class DecoratableResourceMapping
extends DecoratableResourceGroup {
    private static final String MULTIPLE = "*";
    public static final int RESOURCE_MAPPING = 16;

    public DecoratableResourceMapping(ResourceMapping mapping) throws IOException {
        super(mapping);
        HashSet<Repository> repositories = new HashSet<Repository>();
        HashSet<IResourceState.StagingState> stagingStates = new HashSet<IResourceState.StagingState>();
        List extractResourcesFromMapping = ResourceUtil.extractResourcesFromMapping((ResourceMapping)mapping);
        boolean anyIsTracked = false;
        boolean anyIsConflict = false;
        boolean anyIsDirty = false;
        for (IResource mappingResource : extractResourcesFromMapping) {
            IndexDiffData indexDiffData;
            if (mappingResource == null || (indexDiffData = ResourceStateFactory.getInstance().getIndexDiffDataOrNull(mappingResource)) == null) continue;
            Repository repository = ResourceUtil.getRepository((IResource)mappingResource);
            repositories.add(repository);
            DecoratableResourceAdapter adapter = new DecoratableResourceAdapter(indexDiffData, mappingResource);
            if (adapter.isTracked()) {
                anyIsTracked = true;
            }
            if (adapter.hasConflicts()) {
                anyIsConflict = true;
            }
            if (adapter.isDirty()) {
                anyIsDirty = true;
            }
            stagingStates.add(adapter.getStagingState());
        }
        if (anyIsTracked) {
            this.setTracked(true);
        }
        if (anyIsConflict) {
            this.setConflicts(true);
        }
        if (anyIsDirty) {
            this.setDirty(true);
        }
        if (stagingStates.isEmpty()) {
            this.setStagingState(IResourceState.StagingState.NOT_STAGED);
        } else if (stagingStates.size() == 1) {
            IResourceState.StagingState state = (IResourceState.StagingState)((Object)stagingStates.iterator().next());
            if (state != null) {
                this.setStagingState(state);
            }
        } else {
            this.setStagingState(IResourceState.StagingState.MODIFIED);
        }
        if (repositories.isEmpty()) {
            return;
        }
        this.someShared = true;
        DecoratableResourceMapping.decorateRepositoryInformation(this, repositories);
    }

    protected static void decorateRepositoryInformation(DecoratableResource resource, Collection<Repository> repositories) throws IOException {
        if (repositories.size() == 1) {
            Repository repository = repositories.iterator().next();
            resource.repositoryName = DecoratableResourceHelper.getRepositoryName(repository);
            resource.branch = DecoratableResourceHelper.getShortBranch(repository);
            resource.branchStatus = DecoratableResourceHelper.getBranchStatus(repository);
        } else if (repositories.size() > 1) {
            HashSet<String> branches = new HashSet<String>(2);
            for (Repository repository : repositories) {
                branches.add(DecoratableResourceHelper.getShortBranch(repository));
                if (branches.size() > 1) break;
            }
            if (branches.size() == 1) {
                resource.repositoryName = MULTIPLE;
                resource.branch = (String)branches.iterator().next();
            }
        }
    }

    @Override
    public int getType() {
        return 16;
    }

    @Override
    public String getName() {
        return "<unknown>";
    }
}

