/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.internal.core.refactoring.BufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.ltk.internal.core.refactoring.ContentStamps;
import org.eclipse.ltk.internal.core.refactoring.Lock;
import org.eclipse.ltk.internal.core.refactoring.MultiStateUndoChange;
import org.eclipse.ltk.internal.core.refactoring.NonDeletingPositionUpdater;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

public class MultiStateTextFileChange
extends TextEditBasedChange {
    private static final String COMPOSABLE_POSITION_CATEGORY = "ComposableEditPositionCategory_" + System.currentTimeMillis();
    private static final String MARKER_POSITION_CATEGORY = "MarkerPositionCategory_" + System.currentTimeMillis();
    private ITextFileBuffer fBuffer;
    private String fCachedString;
    private final ArrayList<ComposableBufferChange> fChanges = new ArrayList(4);
    private ContentStamp fContentStamp;
    private TextEditCopier fCopier;
    private int fCount;
    private boolean fDirty;
    private IFile fFile;
    private int fSaveMode = 1;
    private BufferValidationState fValidationState;

    public MultiStateTextFileChange(String name, IFile file) {
        super(name);
        Assert.isNotNull((Object)file);
        this.fFile = file;
        this.setTextType("txt");
    }

    private IDocument acquireDocument(IProgressMonitor monitor) throws CoreException {
        if (this.fCount > 0) {
            return this.fBuffer.getDocument();
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = this.fFile.getFullPath();
        manager.connect(path, LocationKind.IFILE, monitor);
        ++this.fCount;
        this.fBuffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
        IDocument document = this.fBuffer.getDocument();
        this.fContentStamp = ContentStamps.get(this.fFile, document);
        return document;
    }

    public final void addChange(TextChange change) {
        Assert.isNotNull((Object)change);
        ComposableBufferChange result = new ComposableBufferChange();
        result.setEdit(change.getEdit());
        TextEditBasedChangeGroup[] groups = change.getChangeGroups();
        ArrayList<ComposableBufferChangeGroup> list = new ArrayList<ComposableBufferChangeGroup>(groups.length);
        TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditBasedChangeGroup g = textEditBasedChangeGroupArray[n2];
            ComposableBufferChangeGroup group = new ComposableBufferChangeGroup(this, g.getTextEditGroup());
            list.add(group);
            this.addChangeGroup(group);
            ++n2;
        }
        result.setGroups(list);
        this.fChanges.add(result);
    }

    private TextEditProcessor createTextEditProcessor(ComposableBufferChange change, IDocument document, int flags, boolean preview) {
        ArrayList<TextEdit> excludes = new ArrayList<TextEdit>(0);
        for (TextEditBasedChangeGroup group : change.getGroups()) {
            if (group.isEnabled()) continue;
            excludes.addAll(Arrays.asList(group.getTextEdits()));
        }
        if (preview) {
            this.fCopier = new TextEditCopier(change.getEdit());
            TextEdit copiedEdit = this.fCopier.perform();
            boolean keep = this.getKeepPreviewEdits();
            if (keep) {
                flags |= 2;
            }
            TextEditBasedChange.LocalTextEditProcessor result = new TextEditBasedChange.LocalTextEditProcessor(document, copiedEdit, flags);
            result.setExcludes(this.mapEdits(excludes.toArray(new TextEdit[excludes.size()]), this.fCopier));
            if (!keep) {
                this.fCopier = null;
            }
            return result;
        }
        TextEditBasedChange.LocalTextEditProcessor result = new TextEditBasedChange.LocalTextEditProcessor(document, change.getEdit(), flags | 2);
        result.setExcludes(excludes.toArray(new TextEdit[excludes.size()]));
        return result;
    }

    private ReplaceEdit createUndoEdit(IDocument document, int offset, int length, String text) {
        String currentText = null;
        try {
            currentText = document.get(offset, length);
        }
        catch (BadLocationException badLocationException) {}
        if (this.fCachedString != null && this.fCachedString.equals(currentText)) {
            currentText = this.fCachedString;
        } else {
            this.fCachedString = currentText;
        }
        return new ReplaceEdit(offset, text != null ? text.length() : 0, currentText);
    }

    @Override
    public final void dispose() {
        if (this.fValidationState != null) {
            this.fValidationState.dispose();
        }
    }

    @Override
    public final String getCurrentContent(IProgressMonitor monitor) throws CoreException {
        return this.getCurrentDocument(monitor).get();
    }

    @Override
    public final String getCurrentContent(IRegion region, boolean expand, int surround, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)region);
        Assert.isTrue((surround >= 0 ? 1 : 0) != 0);
        IDocument document = this.getCurrentDocument(monitor);
        Assert.isTrue((document.getLength() >= region.getOffset() + region.getLength() ? 1 : 0) != 0);
        return this.getContent(document, region, expand, surround);
    }

    public final IDocument getCurrentDocument(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IDocument result = null;
        monitor.beginTask("", 2);
        try {
            result = this.acquireDocument((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            if (result != null) {
                this.releaseDocument(result, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        monitor.done();
        if (result == null) {
            result = new Document();
        }
        return result;
    }

    @Override
    public final Object getModifiedElement() {
        return this.fFile;
    }

    @Override
    public final String getPreviewContent(TextEditBasedChangeGroup[] groups, IRegion region, boolean expand, int surround, IProgressMonitor monitor) throws CoreException {
        HashSet<TextEditBasedChangeGroup> cachedGroups = new HashSet<TextEditBasedChangeGroup>(Arrays.asList(groups));
        Document document = new Document(this.getCurrentDocument(monitor).get());
        Position range = new Position(region.getOffset(), region.getLength());
        try {
            block48: {
                IPositionUpdater positionUpdater;
                block47: {
                    ComposableBufferChange change = null;
                    final TextEditBasedChangeGroup[] changedGroups = this.getChangeGroups();
                    LinkedList compositeUndo = new LinkedList();
                    int index = 0;
                    while (index < this.fChanges.size()) {
                        change = this.fChanges.get(index);
                        TextEdit copy = null;
                        try {
                            this.fCopier = new TextEditCopier(change.getEdit());
                            copy = this.fCopier.perform();
                            final HashMap<TextEdit, TextEdit> originalMap = new HashMap<TextEdit, TextEdit>();
                            for (ComposableBufferChangeGroup group : change.getGroups()) {
                                for (TextEdit originalEdit : group.getCachedEdits()) {
                                    TextEdit copiedEdit = this.fCopier.getCopy(originalEdit);
                                    if (copiedEdit != null) {
                                        originalMap.put(copiedEdit, originalEdit);
                                        continue;
                                    }
                                    RefactoringCorePlugin.logErrorMessage("Could not find a copy for the indexed text edit " + originalEdit.toString());
                                }
                            }
                            final ComposableBufferChangeGroup[] currentGroup = new ComposableBufferChangeGroup[1];
                            final TextEdit[] currentEdit = new TextEdit[1];
                            TextEditProcessor processor = new TextEditProcessor((IDocument)document, copy, 0){

                                protected final boolean considerEdit(TextEdit edit) {
                                    TextEdit originalEdit = (TextEdit)originalMap.get(edit);
                                    if (originalEdit != null) {
                                        currentEdit[0] = originalEdit;
                                        boolean found = false;
                                        int offset = 0;
                                        while (offset < changedGroups.length && !found) {
                                            ComposableBufferChangeGroup group = (ComposableBufferChangeGroup)changedGroups[offset];
                                            if (group.containsEdit(originalEdit)) {
                                                currentGroup[0] = group;
                                                found = true;
                                            }
                                            ++offset;
                                        }
                                        if (!found) {
                                            currentGroup[0] = null;
                                        }
                                    } else if (!(edit instanceof MultiTextEdit)) {
                                        RefactoringCorePlugin.logErrorMessage("Could not find the original of the copied text edit " + edit.toString());
                                    }
                                    return true;
                                }
                            };
                            LinkedList eventUndos = new LinkedList();
                            IDocumentListener listener = new IDocumentListener((IDocument)document, eventUndos){
                                private final /* synthetic */ IDocument val$document;
                                private final /* synthetic */ LinkedList val$eventUndos;
                                {
                                    this.val$document = iDocument;
                                    this.val$eventUndos = linkedList;
                                }

                                public final void documentAboutToBeChanged(DocumentEvent event) {
                                    ComposableUndoEdit edit = new ComposableUndoEdit();
                                    edit.setGroup(currentGroup[0]);
                                    edit.setOriginal(currentEdit[0]);
                                    edit.setUndo(MultiStateTextFileChange.this.createUndoEdit(this.val$document, event.getOffset(), event.getLength(), event.getText()));
                                    this.val$eventUndos.addFirst(edit);
                                }

                                public final void documentChanged(DocumentEvent event) {
                                }
                            };
                            try {
                                document.addDocumentListener(listener);
                                processor.performEdits();
                            }
                            finally {
                                document.removeDocumentListener(listener);
                            }
                            compositeUndo.addFirst(eventUndos);
                        }
                        finally {
                            this.fCopier = null;
                        }
                        ++index;
                    }
                    positionUpdater = new IPositionUpdater(){

                        public final void update(DocumentEvent event) {
                            int eventOffset = event.getOffset();
                            int eventLength = event.getLength();
                            int eventOldEndOffset = eventOffset + eventLength;
                            String eventText = event.getText();
                            int eventNewLength = eventText == null ? 0 : eventText.length();
                            int eventNewEndOffset = eventOffset + eventNewLength;
                            int deltaLength = eventNewLength - eventLength;
                            try {
                                Position[] positions;
                                Position[] positionArray = positions = event.getDocument().getPositions(COMPOSABLE_POSITION_CATEGORY);
                                int n = positions.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Position position = positionArray[n2];
                                    if (!position.isDeleted()) {
                                        int offset = position.getOffset();
                                        int length = position.getLength();
                                        int end = offset + length;
                                        if (offset > eventOldEndOffset) {
                                            position.setOffset(offset + deltaLength);
                                        } else if (end >= eventOffset && offset != eventOffset) {
                                            if (offset <= eventOffset && end >= eventOldEndOffset) {
                                                position.setLength(length + deltaLength);
                                            } else if (offset < eventOffset) {
                                                position.setLength(eventNewEndOffset - offset);
                                            } else if (end > eventOldEndOffset) {
                                                position.setOffset(eventOffset);
                                                int deleted = eventOldEndOffset - offset;
                                                position.setLength(length - deleted + eventNewLength);
                                            } else {
                                                int newOffset = Math.min(offset, eventNewEndOffset);
                                                int newEndOffset = Math.min(end, eventNewEndOffset);
                                                position.setOffset(newOffset);
                                                position.setLength(newEndOffset - newOffset);
                                            }
                                        }
                                    }
                                    ++n2;
                                }
                            }
                            catch (BadPositionCategoryException badPositionCategoryException) {}
                        }
                    };
                    try {
                        try {
                            document.addPositionCategory(COMPOSABLE_POSITION_CATEGORY);
                            document.addPositionUpdater(positionUpdater);
                            LinkedList<ComposableEditPosition> undoQueue = new LinkedList<ComposableEditPosition>();
                            Iterator outer = compositeUndo.iterator();
                            while (outer.hasNext()) {
                                for (ComposableUndoEdit edit : (LinkedList)outer.next()) {
                                    ReplaceEdit undo = edit.getUndo();
                                    int offset = undo.getOffset();
                                    int length = undo.getLength();
                                    String text = undo.getText();
                                    ComposableEditPosition position = new ComposableEditPosition();
                                    if (cachedGroups.contains(edit.getGroup())) {
                                        if (text == null || text.equals("")) {
                                            position.offset = offset;
                                            if (length != 0) {
                                                position.length = 0;
                                                position.setText(edit.getOriginalText());
                                            } else {
                                                RefactoringCorePlugin.logErrorMessage("Dubious undo edit found: " + undo.toString());
                                            }
                                        } else if (length == 0) {
                                            position.offset = offset;
                                            position.setText("");
                                            position.length = text.length();
                                        } else {
                                            position.offset = offset;
                                            position.length = length;
                                            position.setText(edit.getOriginalText());
                                        }
                                        document.addPosition(COMPOSABLE_POSITION_CATEGORY, (Position)position);
                                    }
                                    position = new ComposableEditPosition();
                                    position.offset = undo.getOffset();
                                    position.length = undo.getLength();
                                    position.setText(undo.getText());
                                    undoQueue.add(position);
                                }
                                Iterator iterator = undoQueue.iterator();
                                while (iterator.hasNext()) {
                                    ComposableEditPosition position = (ComposableEditPosition)((Object)iterator.next());
                                    document.replace(position.offset, position.length, position.getText());
                                    iterator.remove();
                                }
                            }
                            NonDeletingPositionUpdater markerUpdater = new NonDeletingPositionUpdater(MARKER_POSITION_CATEGORY);
                            try {
                                try {
                                    Position[] positions = document.getPositions(COMPOSABLE_POSITION_CATEGORY);
                                    document.addPositionCategory(MARKER_POSITION_CATEGORY);
                                    document.addPositionUpdater((IPositionUpdater)markerUpdater);
                                    document.addPosition(MARKER_POSITION_CATEGORY, range);
                                    Position[] positionArray = positions;
                                    int n = positions.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Position p = positionArray[n2];
                                        ComposableEditPosition position = (ComposableEditPosition)p;
                                        document.replace(position.offset, position.length, position.getText() != null ? position.getText() : "");
                                        ++n2;
                                    }
                                }
                                catch (BadPositionCategoryException exception) {
                                    RefactoringCorePlugin.log(exception);
                                    document.removePositionUpdater((IPositionUpdater)markerUpdater);
                                    try {
                                        document.removePosition(MARKER_POSITION_CATEGORY, range);
                                        document.removePositionCategory(MARKER_POSITION_CATEGORY);
                                    }
                                    catch (BadPositionCategoryException badPositionCategoryException) {}
                                    break block47;
                                }
                            }
                            catch (Throwable throwable) {
                                document.removePositionUpdater((IPositionUpdater)markerUpdater);
                                try {
                                    document.removePosition(MARKER_POSITION_CATEGORY, range);
                                    document.removePositionCategory(MARKER_POSITION_CATEGORY);
                                }
                                catch (BadPositionCategoryException badPositionCategoryException) {}
                                throw throwable;
                            }
                            document.removePositionUpdater((IPositionUpdater)markerUpdater);
                            try {
                                document.removePosition(MARKER_POSITION_CATEGORY, range);
                                document.removePositionCategory(MARKER_POSITION_CATEGORY);
                            }
                            catch (BadPositionCategoryException badPositionCategoryException) {}
                        }
                        catch (BadPositionCategoryException exception) {
                            RefactoringCorePlugin.log(exception);
                            document.removePositionUpdater(positionUpdater);
                            try {
                                document.removePositionCategory(COMPOSABLE_POSITION_CATEGORY);
                            }
                            catch (BadPositionCategoryException exception2) {
                                RefactoringCorePlugin.log(exception2);
                            }
                            break block48;
                        }
                    }
                    catch (Throwable throwable) {
                        document.removePositionUpdater(positionUpdater);
                        try {
                            document.removePositionCategory(COMPOSABLE_POSITION_CATEGORY);
                        }
                        catch (BadPositionCategoryException exception) {
                            RefactoringCorePlugin.log(exception);
                        }
                        throw throwable;
                    }
                }
                document.removePositionUpdater(positionUpdater);
                try {
                    document.removePositionCategory(COMPOSABLE_POSITION_CATEGORY);
                }
                catch (BadPositionCategoryException exception) {
                    RefactoringCorePlugin.log(exception);
                }
            }
            return this.getContent((IDocument)document, (IRegion)new Region(range.offset, range.length), expand, surround);
        }
        catch (MalformedTreeException exception) {
            RefactoringCorePlugin.log(exception);
        }
        catch (BadLocationException exception) {
            RefactoringCorePlugin.log(exception);
        }
        return this.getPreviewDocument(monitor).get();
    }

    @Override
    public final String getPreviewContent(IProgressMonitor monitor) throws CoreException {
        return this.getPreviewDocument(monitor).get();
    }

    public final IDocument getPreviewDocument(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        Document result = null;
        IDocument document = null;
        try {
            try {
                document = this.acquireDocument((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (document != null) {
                    result = new Document(document.get());
                    this.performChanges((IDocument)result, null, true);
                }
            }
            catch (BadLocationException exception) {
                throw Changes.asCoreException(exception);
            }
        }
        finally {
            if (document != null) {
                this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.done();
        }
        if (result == null) {
            result = new Document();
        }
        return result;
    }

    public final int getSaveMode() {
        return this.fSaveMode;
    }

    @Override
    public final void initializeValidationData(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 1);
        try {
            this.fValidationState = BufferValidationState.create(this.fFile);
        }
        finally {
            monitor.worked(1);
        }
    }

    @Override
    public final RefactoringStatus isValid(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 1);
        try {
            if (this.fValidationState == null) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), "MultiStateTextFileChange has not been initialialized"));
            }
            ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
            this.fDirty = buffer != null && buffer.isDirty();
            RefactoringStatus status = this.fValidationState.isValid(this.needsSaving());
            if (this.needsSaving()) {
                status.merge(Changes.validateModifiesFiles(new IFile[]{this.fFile}));
            } else {
                status.merge(Changes.checkInSync(new IFile[]{this.fFile}));
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    public final boolean needsSaving() {
        return (this.fSaveMode & 2) != 0 || !this.fDirty && (this.fSaveMode & 1) != 0;
    }

    @Override
    public final Change perform(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 3);
        IDocument document = null;
        try {
            document = this.acquireDocument((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            LinkedList<UndoEdit> undoList = new LinkedList<UndoEdit>();
            this.performChanges(document, undoList, false);
            if (this.needsSaving()) {
                this.fBuffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
            }
            MultiStateUndoChange multiStateUndoChange = new MultiStateUndoChange(this.getName(), this.fFile, undoList.toArray(new UndoEdit[undoList.size()]), this.fContentStamp, this.fSaveMode);
            return multiStateUndoChange;
        }
        catch (BadLocationException exception) {
            throw Changes.asCoreException(exception);
        }
        finally {
            if (document != null) {
                this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performChanges(final IDocument document, final LinkedList<UndoEdit> undoList, final boolean preview) throws BadLocationException {
        if (!this.fBuffer.isSynchronizationContextRequested()) {
            this.performChangesInSynchronizationContext(document, undoList, preview);
            return;
        }
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        final Lock completionLock = new Lock();
        final BadLocationException[] exception = new BadLocationException[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Lock lock = completionLock;
                synchronized (lock) {
                    block8: {
                        try {
                            try {
                                MultiStateTextFileChange.this.performChangesInSynchronizationContext(document, undoList, preview);
                            }
                            catch (BadLocationException e) {
                                exception[0] = e;
                                completionLock.fDone = true;
                                completionLock.notifyAll();
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            completionLock.fDone = true;
                            completionLock.notifyAll();
                            throw throwable;
                        }
                        completionLock.fDone = true;
                        completionLock.notifyAll();
                    }
                }
            }
        };
        Lock lock = completionLock;
        synchronized (lock) {
            fileBufferManager.execute(runnable);
            while (!completionLock.fDone) {
                try {
                    completionLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    private void performChangesInSynchronizationContext(IDocument document, LinkedList<UndoEdit> undoList, boolean preview) throws BadLocationException {
        DocumentRewriteSession session = null;
        try {
            if (document instanceof IDocumentExtension4) {
                session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
            }
            for (ComposableBufferChange change : this.fChanges) {
                UndoEdit edit = this.createTextEditProcessor(change, document, undoList != null ? 1 : 0, preview).performEdits();
                if (undoList == null) continue;
                undoList.addFirst(edit);
            }
        }
        finally {
            if (session != null) {
                ((IDocumentExtension4)document).stopRewriteSession(session);
            }
        }
    }

    private void releaseDocument(IDocument document, IProgressMonitor monitor) throws CoreException {
        Assert.isTrue((this.fCount > 0 ? 1 : 0) != 0);
        if (this.fCount == 1) {
            FileBuffers.getTextFileBufferManager().disconnect(this.fFile.getFullPath(), LocationKind.IFILE, monitor);
        }
        --this.fCount;
    }

    @Override
    public final void setKeepPreviewEdits(boolean keep) {
        super.setKeepPreviewEdits(keep);
        if (!keep) {
            this.fCopier = null;
        }
    }

    public final void setSaveMode(int mode) {
        this.fSaveMode = mode;
    }

    private static final class ComposableBufferChange {
        private TextEdit fEdit;
        private List<TextEditBasedChangeGroup> fGroups;

        private ComposableBufferChange() {
        }

        private final TextEdit getEdit() {
            return this.fEdit;
        }

        private final List<TextEditBasedChangeGroup> getGroups() {
            return this.fGroups;
        }

        private final void setEdit(TextEdit edit) {
            Assert.isNotNull((Object)edit);
            this.fEdit = edit;
        }

        private final void setGroups(List<TextEditBasedChangeGroup> groups) {
            Assert.isNotNull(groups);
            this.fGroups = groups;
        }
    }

    private static final class ComposableBufferChangeGroup
    extends TextEditBasedChangeGroup {
        private final Set<TextEdit> fEdits = new HashSet<TextEdit>();

        private ComposableBufferChangeGroup(MultiStateTextFileChange change, TextEditGroup group) {
            super(change, group);
            TextEdit[] edits;
            TextEdit[] textEditArray = edits = group.getTextEdits();
            int n = edits.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit edit = textEditArray[n2];
                this.cacheEdit(edit);
                ++n2;
            }
        }

        private final void cacheEdit(TextEdit edit) {
            TextEdit[] edits;
            this.fEdits.add(edit);
            TextEdit[] textEditArray = edits = edit.getChildren();
            int n = edits.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit e = textEditArray[n2];
                this.cacheEdit(e);
                ++n2;
            }
        }

        private final boolean containsEdit(TextEdit edit) {
            return this.fEdits.contains(edit);
        }

        private final Set<TextEdit> getCachedEdits() {
            return this.fEdits;
        }
    }

    private static final class ComposableEditPosition
    extends Position {
        private String fText;

        private ComposableEditPosition() {
        }

        private final String getText() {
            return this.fText;
        }

        private final void setText(String text) {
            Assert.isNotNull((Object)text);
            this.fText = text;
        }
    }

    private static final class ComposableUndoEdit {
        private ComposableBufferChangeGroup fGroup;
        private TextEdit fOriginal;
        private ReplaceEdit fUndo;

        private ComposableUndoEdit() {
        }

        private final ComposableBufferChangeGroup getGroup() {
            return this.fGroup;
        }

        private final TextEdit getOriginal() {
            return this.fOriginal;
        }

        private final String getOriginalText() {
            if (this.fOriginal instanceof ReplaceEdit) {
                return ((ReplaceEdit)this.getOriginal()).getText();
            }
            if (this.fOriginal instanceof InsertEdit) {
                return ((InsertEdit)this.getOriginal()).getText();
            }
            return "";
        }

        private final ReplaceEdit getUndo() {
            return this.fUndo;
        }

        private final void setGroup(ComposableBufferChangeGroup group) {
            Assert.isNotNull((Object)group);
            this.fGroup = group;
        }

        private final void setOriginal(TextEdit edit) {
            this.fOriginal = edit;
        }

        private final void setUndo(ReplaceEdit undo) {
            Assert.isNotNull((Object)undo);
            this.fUndo = undo;
        }
    }
}

