/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.ui.breakpoints.StandardJavaBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ExceptionBreakpointEditor
extends StandardJavaBreakpointEditor {
    public static final int PROP_CAUGHT = 4128;
    public static final int PROP_UNCAUGHT = 4129;
    public static final int PROP_SUBCLASSES = 4130;
    public static final int PROP_RECURRENCE = 4131;
    private Button fCaught;
    private Button fUncaught;
    private Button fSubclasses;
    private Combo fRecurrence;
    private Map<IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy, String> fRecurrenceOptions;

    @Override
    public Control createControl(Composite parent) {
        Composite container = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)0, (int)0, (int)0);
        super.createControl(container);
        Composite composite = SWTFactory.createComposite((Composite)container, (Font)parent.getFont(), (int)5, (int)1, (int)0, (int)0, (int)0);
        this.fCaught = this.createSusupendPropertyEditor(composite, this.processMnemonics(PropertyPageMessages.ExceptionBreakpointEditor_1), 4128);
        this.fUncaught = this.createSusupendPropertyEditor(composite, this.processMnemonics(PropertyPageMessages.ExceptionBreakpointEditor_2), 4129);
        this.fSubclasses = this.createSusupendPropertyEditor(composite, this.processMnemonics(PropertyPageMessages.ExceptionBreakpointEditor_3), 4130);
        composite = SWTFactory.createComposite((Composite)container, (Font)parent.getFont(), (int)2, (int)1, (int)0, (int)0, (int)0);
        this.fRecurrence = this.createRecurrenceEditor(composite, this.processMnemonics(PropertyPageMessages.ExceptionBreakpointEditor_recurrence_label), 4131);
        return container;
    }

    private Combo createRecurrenceEditor(Composite parent, String labelText, final int propId) {
        this.fRecurrenceOptions = new HashMap<IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy, String>();
        this.fRecurrenceOptions.put(IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy.RECURRENCE_UNCONFIGURED, PropertyPageMessages.ExceptionBreakpointEditor_recurrence_unconfigured);
        this.fRecurrenceOptions.put(IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy.SUSPEND_ALWAYS, PropertyPageMessages.ExceptionBreakpointEditor_recurrence_always);
        this.fRecurrenceOptions.put(IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy.SKIP_RECURRENCES, PropertyPageMessages.ExceptionBreakpointEditor_recurrence_onlyOnce);
        SWTFactory.createLabel((Composite)parent, (String)labelText, (int)1);
        Combo box = SWTFactory.createCombo((Composite)parent, (int)8, (int)1, (int)768, (String[])this.fRecurrenceOptions.values().toArray(new String[this.fRecurrenceOptions.size()]));
        box.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExceptionBreakpointEditor.this.setDirty(propId);
            }
        });
        return box;
    }

    @Override
    protected void setBreakpoint(IJavaBreakpoint breakpoint) throws CoreException {
        super.setBreakpoint(breakpoint);
        if (breakpoint instanceof IJavaExceptionBreakpoint) {
            IJavaExceptionBreakpoint ex = (IJavaExceptionBreakpoint)breakpoint;
            this.fCaught.setEnabled(true);
            this.fUncaught.setEnabled(true);
            this.fSubclasses.setEnabled(true);
            this.fRecurrence.setEnabled(true);
            this.fCaught.setSelection(ex.isCaught());
            this.fUncaught.setSelection(ex.isUncaught());
            this.fSubclasses.setSelection(((JavaExceptionBreakpoint)ex).isSuspendOnSubclasses());
            this.fRecurrence.setText(this.fRecurrenceOptions.get(ex.getSuspendOnRecurrenceStrategy()));
        } else {
            this.fCaught.setEnabled(false);
            this.fUncaught.setEnabled(false);
            this.fSubclasses.setEnabled(false);
            this.fRecurrence.setEnabled(false);
        }
    }

    @Override
    public void doSave() throws CoreException {
        super.doSave();
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint instanceof IJavaExceptionBreakpoint) {
            IJavaExceptionBreakpoint ex = (IJavaExceptionBreakpoint)breakpoint;
            ex.setCaught(this.fCaught.getSelection());
            ex.setUncaught(this.fUncaught.getSelection());
            ((JavaExceptionBreakpoint)ex).setSuspendOnSubclasses(this.fSubclasses.getSelection());
            ex.setSuspendOnRecurrenceStrategy(this.stringToRecurrence(this.fRecurrence.getText()));
        }
    }

    private IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy stringToRecurrence(String text) {
        for (Map.Entry<IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy, String> entry : this.fRecurrenceOptions.entrySet()) {
            if (!entry.getValue().equals(text)) continue;
            return entry.getKey();
        }
        return IJavaExceptionBreakpoint.SuspendOnRecurrenceStrategy.RECURRENCE_UNCONFIGURED;
    }
}

